/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.bench;

import cern.colt.Timer;
import cern.colt.Version;
import cern.colt.function.Double9Function;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleFactory3D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.bench.BenchmarkKernel;
import cern.colt.matrix.bench.Double2DProcedure;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.doublealgo.Statistic;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.Former;
import cern.colt.matrix.impl.FormerFactory;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.LUDecompositionQuick;
import cern.colt.matrix.linalg.Property;
import cern.colt.matrix.linalg.SeqBlas;
import cern.colt.matrix.linalg.SmpBlas;
import cern.jet.math.Functions;
import hep.aida.bin.BinFunction1D;
import hep.aida.bin.BinFunctions1D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public class BenchmarkMatrix {
    protected BenchmarkMatrix() {
    }

    protected static void bench_dgemm(String[] stringArray) {
        int[] nArray;
        boolean bl;
        boolean bl2;
        double[] dArray;
        double d2;
        int n;
        String[] stringArray2;
        try {
            int n2 = 1;
            stringArray2 = new String[]{stringArray[n2++]};
            n = Integer.parseInt(stringArray[n2++]);
            d2 = new Double(stringArray[n2++]);
            dArray = new double[]{new Double(stringArray[n2++])};
            bl2 = new Boolean(stringArray[n2++]);
            bl = new Boolean(stringArray[n2++]);
            nArray = new int[stringArray.length - n2];
            int n3 = 0;
            while (n2 < stringArray.length) {
                nArray[n3] = Integer.parseInt(stringArray[n2]);
                ++n2;
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(BenchmarkMatrix.usage(stringArray[0]));
            System.out.println("Ignoring command...\n");
            return;
        }
        SmpBlas.allocateBlas(n, SeqBlas.seqBlas);
        Double2DProcedure double2DProcedure = BenchmarkMatrix.fun_dgemm(bl2, bl);
        String string = double2DProcedure.toString();
        String string2 = bl2 + ", " + bl + ", 1, A, B, 0, C";
        string = string + " dgemm(" + string2 + ")";
        BenchmarkMatrix.run(d2, string, double2DProcedure, stringArray2, nArray, dArray);
    }

    protected static void bench_dgemv(String[] stringArray) {
        int[] nArray;
        boolean bl;
        double[] dArray;
        double d2;
        int n;
        String[] stringArray2;
        try {
            int n2 = 1;
            stringArray2 = new String[]{stringArray[n2++]};
            n = Integer.parseInt(stringArray[n2++]);
            d2 = new Double(stringArray[n2++]);
            dArray = new double[]{new Double(stringArray[n2++])};
            bl = new Boolean(stringArray[n2++]);
            nArray = new int[stringArray.length - n2];
            int n3 = 0;
            while (n2 < stringArray.length) {
                nArray[n3] = Integer.parseInt(stringArray[n2]);
                ++n2;
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(BenchmarkMatrix.usage(stringArray[0]));
            System.out.println("Ignoring command...\n");
            return;
        }
        SmpBlas.allocateBlas(n, SeqBlas.seqBlas);
        Double2DProcedure double2DProcedure = BenchmarkMatrix.fun_dgemv(bl);
        String string = double2DProcedure.toString();
        String string2 = bl + ", 1, A, B, 0, C";
        string = string + " dgemv(" + string2 + ")";
        BenchmarkMatrix.run(d2, string, double2DProcedure, stringArray2, nArray, dArray);
    }

    protected static void bench_pow(String[] stringArray) {
        int[] nArray;
        int n;
        double[] dArray;
        double d2;
        int n2;
        String[] stringArray2;
        try {
            int n3 = 1;
            stringArray2 = new String[]{stringArray[n3++]};
            n2 = Integer.parseInt(stringArray[n3++]);
            d2 = new Double(stringArray[n3++]);
            dArray = new double[]{new Double(stringArray[n3++])};
            n = Integer.parseInt(stringArray[n3++]);
            nArray = new int[stringArray.length - n3];
            int n4 = 0;
            while (n3 < stringArray.length) {
                nArray[n4] = Integer.parseInt(stringArray[n3]);
                ++n3;
                ++n4;
            }
        }
        catch (Exception exception) {
            System.out.println(BenchmarkMatrix.usage(stringArray[0]));
            System.out.println("Ignoring command...\n");
            return;
        }
        SmpBlas.allocateBlas(n2, SeqBlas.seqBlas);
        Double2DProcedure double2DProcedure = BenchmarkMatrix.fun_pow(n);
        String string = double2DProcedure.toString();
        String string2 = "A," + n;
        string = string + " pow(" + string2 + ")";
        BenchmarkMatrix.run(d2, string, double2DProcedure, stringArray2, nArray, dArray);
    }

    protected static void benchGeneric(Double2DProcedure double2DProcedure, String[] stringArray) {
        int[] nArray;
        double[] dArray;
        double d2;
        int n;
        String[] stringArray2;
        try {
            int n2 = 1;
            stringArray2 = new String[]{stringArray[n2++]};
            n = Integer.parseInt(stringArray[n2++]);
            d2 = new Double(stringArray[n2++]);
            dArray = new double[]{new Double(stringArray[n2++])};
            nArray = new int[stringArray.length - n2];
            int n3 = 0;
            while (n2 < stringArray.length) {
                nArray[n3] = Integer.parseInt(stringArray[n2]);
                ++n2;
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(BenchmarkMatrix.usage(stringArray[0]));
            System.out.println("Ignoring command...\n");
            return;
        }
        SmpBlas.allocateBlas(n, SeqBlas.seqBlas);
        String string = double2DProcedure.toString();
        BenchmarkMatrix.run(d2, string, double2DProcedure, stringArray2, nArray, dArray);
    }

    protected static String commands() {
        return "dgemm, dgemv, pow, assign, assignGetSet, assignGetSetQuick, assignLog, assignPlusMult, elementwiseMult, elementwiseMultB, SOR5, SOR8, LUDecompose, LUSolve";
    }

    protected static Double2DProcedure fun_dgemm(final boolean bl, final boolean bl2) {
        return new Double2DProcedure(){

            public String toString() {
                return "Blas matrix-matrix mult";
            }

            public void setParameters(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                super.setParameters(doubleMatrix2D, doubleMatrix2D2);
                this.D = new DenseDoubleMatrix2D(this.A.rows(), this.A.columns()).assign(0.5);
                this.C = this.D.copy();
                this.B = this.D.copy();
            }

            public void init() {
                this.C.assign(this.D);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.dgemm(bl, bl2, 1.0, this.A, this.B, 0.0, this.C);
            }

            public double operations() {
                double d2 = this.A.rows();
                double d3 = this.A.columns();
                double d4 = this.B.columns();
                return 2.0 * d2 * d3 * d4 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure fun_dgemv(final boolean bl) {
        return new Double2DProcedure(){

            public String toString() {
                return "Blas matrix-vector mult";
            }

            public void setParameters(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                super.setParameters(doubleMatrix2D, doubleMatrix2D2);
                this.D = new DenseDoubleMatrix2D(this.A.rows(), this.A.columns()).assign(0.5);
                this.C = this.D.copy();
                this.B = this.D.copy();
            }

            public void init() {
                this.C.viewRow(0).assign(this.D.viewRow(0));
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.dgemv(bl, 1.0, this.A, this.B.viewRow(0), 0.0, this.C.viewRow(0));
            }

            public double operations() {
                double d2 = this.A.rows();
                double d3 = this.A.columns();
                return 2.0 * d2 * d3 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure fun_pow(final int n) {
        return new Double2DProcedure(){
            public double dummy;

            public String toString() {
                return "matrix to the power of an exponent";
            }

            public void setParameters(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                if (n < 0) {
                    if (!Property.ZERO.isDiagonallyDominantByRow(doubleMatrix2D) || !Property.ZERO.isDiagonallyDominantByColumn(doubleMatrix2D)) {
                        Property.ZERO.generateNonSingular(doubleMatrix2D);
                    }
                    super.setParameters(doubleMatrix2D, doubleMatrix2D2);
                }
            }

            public void init() {
            }

            public void apply(Timer timer) {
                Algebra.DEFAULT.pow(this.A, n);
            }

            public double operations() {
                double d2 = this.A.rows();
                if (n == 0) {
                    return d2;
                }
                double d3 = 0.0;
                if (n < 0) {
                    double d4 = Math.min(this.A.rows(), this.A.columns());
                    d3 += 2.0 * d4 * d4 * d4 / 3.0 / 1000000.0;
                    double d5 = this.A.columns();
                    double d6 = this.B.columns();
                    d3 += 2.0 * d6 * (d5 * d5 + d5) / 1000000.0;
                }
                return d3 += 2.0 * (double)(Math.abs(n) - 1) * d2 * d2 * d2 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funAssign() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(B) [Mops/sec]";
            }

            public void init() {
                this.A.assign(0.0);
            }

            public void apply(Timer timer) {
                this.A.assign(this.B);
            }
        };
    }

    protected static Double2DProcedure funAssignGetSet() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(B) via get and set [Mops/sec]";
            }

            public void init() {
                this.A.assign(0.0);
            }

            public void apply(Timer timer) {
                int n = this.B.rows();
                int n2 = this.B.columns();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        this.A.set(i, j, this.B.get(i, j));
                    }
                }
            }
        };
    }

    protected static Double2DProcedure funAssignGetSetQuick() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(B) via getQuick and setQuick [Mops/sec]";
            }

            public void init() {
                this.A.assign(0.0);
            }

            public void apply(Timer timer) {
                int n = this.B.rows();
                int n2 = this.B.columns();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        this.A.setQuick(i, j, this.B.getQuick(i, j));
                    }
                }
            }
        };
    }

    protected static Double2DProcedure funAssignLog() {
        return new Double2DProcedure(){

            public String toString() {
                return "A[i,j] = log(A[i,j]) via Blas.assign(fun) [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.assign(this.A, Functions.log);
            }
        };
    }

    protected static Double2DProcedure funAssignPlusMult() {
        return new Double2DProcedure(){

            public String toString() {
                return "A[i,j] = A[i,j] + s*B[i,j] via Blas.assign(fun) [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.assign(this.A, this.B, Functions.plusMult(0.5));
            }

            public double operations() {
                double d2 = this.A.rows();
                double d3 = this.A.columns();
                return 2.0 * d2 * d3 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funCorrelation() {
        return new Double2DProcedure(){

            public String toString() {
                return "xxxxxxx";
            }

            public void init() {
            }

            public void setParameters(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                super.setParameters(doubleMatrix2D.viewDice(), doubleMatrix2D2);
            }

            public void apply(Timer timer) {
                Statistic.correlation(Statistic.covariance(this.A));
            }

            public double operations() {
                double d2 = this.A.rows();
                double d3 = this.A.columns();
                return d2 * (d3 * d3 + d3) / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funElementwiseMult() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(F.mult(0.5)) via Blas [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.assign(this.A, Functions.mult(0.5));
            }
        };
    }

    protected static Double2DProcedure funElementwiseMultB() {
        return new Double2DProcedure(){

            public String toString() {
                return "A.assign(B,F.mult) via Blas [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                SmpBlas.smpBlas.assign(this.A, this.B, Functions.mult);
            }
        };
    }

    protected static Double2DProcedure funGetQuick() {
        return new Double2DProcedure(){
            public double dummy;

            public String toString() {
                return "xxxxxxx";
            }

            public void init() {
            }

            public void apply(Timer timer) {
                int n = this.B.rows();
                int n2 = this.B.columns();
                double d2 = 0.0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        d2 += this.A.getQuick(i, j);
                    }
                }
                this.dummy = d2;
            }
        };
    }

    protected static Double2DProcedure funLUDecompose() {
        return new Double2DProcedure(){
            LUDecompositionQuick lu = new LUDecompositionQuick(0.0);

            public String toString() {
                return "LU.decompose(A) [Mflops/sec]";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                this.lu.decompose(this.A);
            }

            public double operations() {
                double d2 = Math.min(this.A.rows(), this.A.columns());
                return 2.0 * d2 * d2 * d2 / 3.0 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funLUSolve() {
        return new Double2DProcedure(){
            LUDecompositionQuick lu;

            public String toString() {
                return "LU.solve(A) [Mflops/sec]";
            }

            public void setParameters(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                this.lu = null;
                if (!Property.ZERO.isDiagonallyDominantByRow(doubleMatrix2D) || !Property.ZERO.isDiagonallyDominantByColumn(doubleMatrix2D)) {
                    Property.ZERO.generateNonSingular(doubleMatrix2D);
                }
                super.setParameters(doubleMatrix2D, doubleMatrix2D2);
                this.lu = new LUDecompositionQuick(0.0);
                this.lu.decompose(doubleMatrix2D);
            }

            public void init() {
                this.B.assign(this.D);
            }

            public void apply(Timer timer) {
                this.lu.solve(this.B);
            }

            public double operations() {
                double d2 = this.A.columns();
                double d3 = this.B.columns();
                return 2.0 * d3 * (d2 * d2 + d2) / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funMatMultLarge() {
        return new Double2DProcedure(){

            public String toString() {
                return "xxxxxxx";
            }

            public void setParameters(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                this.A = doubleMatrix2D;
                this.B = doubleMatrix2D2;
                this.C = doubleMatrix2D.copy();
            }

            public void init() {
                this.C.assign(0.0);
            }

            public void apply(Timer timer) {
                this.A.zMult(this.B, this.C);
            }

            public double operations() {
                double d2 = this.A.rows();
                double d3 = this.A.columns();
                double d4 = this.B.columns();
                return 2.0 * d2 * d3 * d4 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funMatVectorMult() {
        return new Double2DProcedure(){

            public String toString() {
                return "xxxxxxx";
            }

            public void setParameters(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
                super.setParameters(doubleMatrix2D, doubleMatrix2D2);
                this.D = new DenseDoubleMatrix2D(this.A.rows(), this.A.columns()).assign(0.5);
                this.C = this.D.copy();
                this.B = this.D.copy();
            }

            public void init() {
                this.C.viewRow(0).assign(this.D.viewRow(0));
            }

            public void apply(Timer timer) {
                this.A.zMult(this.B.viewRow(0), this.C.viewRow(0));
            }

            public double operations() {
                double d2 = this.A.rows();
                double d3 = this.A.columns();
                return 2.0 * d2 * d3 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funSetQuick() {
        return new Double2DProcedure(){
            private int current;
            private double density;

            public String toString() {
                return "xxxxxxx";
            }

            public void init() {
                this.A.assign(0.0);
                int n = 123456;
                this.current = 4 * n + 1;
                this.density = (double)this.A.cardinality() / (double)this.A.size();
            }

            public void apply(Timer timer) {
                int n = this.B.rows();
                int n2 = this.B.columns();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        this.current *= 663608941;
                        double d2 = (double)((long)this.current & 0xFFFFFFFFL) * 2.3283064365386963E-10;
                        if (d2 < this.density) {
                            this.A.setQuick(i, j, d2);
                            continue;
                        }
                        this.A.setQuick(i, j, 0.0);
                    }
                }
            }
        };
    }

    protected static Double2DProcedure funSOR5() {
        return new Double2DProcedure(){
            double value = 2.0;
            double omega = 1.25;
            final double alpha = this.omega * 0.25;
            final double beta = 1.0 - this.omega;
            Double9Function function = new Double9Function(this){
                private final /* synthetic */ 18 this$0;
                {
                    this.this$0 = var1_1;
                }

                public final double apply(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
                    return this.this$0.alpha * d6 + this.this$0.beta * (d3 + d5 + d7 + d9);
                }
            };

            public String toString() {
                return "A.zAssign8Neighbors(5 point function) [Mflops/sec]";
            }

            public void init() {
                this.B.assign(this.D);
            }

            public void apply(Timer timer) {
                this.A.zAssign8Neighbors(this.B, this.function);
            }

            public double operations() {
                double d2 = this.A.columns();
                double d3 = this.A.rows();
                return 6.0 * d3 * d2 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funSOR8() {
        return new Double2DProcedure(){
            double value = 2.0;
            double omega = 1.25;
            final double alpha = this.omega * 0.25;
            final double beta = 1.0 - this.omega;
            Double9Function function = new Double9Function(this){
                private final /* synthetic */ 20 this$0;
                {
                    this.this$0 = var1_1;
                }

                public final double apply(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
                    return this.this$0.alpha * d6 + this.this$0.beta * (d2 + d5 + d8 + d3 + d9 + d4 + d7 + d10);
                }
            };

            public String toString() {
                return "A.zAssign8Neighbors(9 point function) [Mflops/sec]";
            }

            public void init() {
                this.B.assign(this.D);
            }

            public void apply(Timer timer) {
                this.A.zAssign8Neighbors(this.B, this.function);
            }

            public double operations() {
                double d2 = this.A.columns();
                double d3 = this.A.rows();
                return 10.0 * d3 * d2 / 1000000.0;
            }
        };
    }

    protected static Double2DProcedure funSort() {
        return new Double2DProcedure(){

            public String toString() {
                return "xxxxxxx";
            }

            public void init() {
                this.A.assign(this.C);
            }

            public void apply(Timer timer) {
                this.A.viewSorted(0);
            }
        };
    }

    protected static DoubleFactory2D getFactory(String string) {
        if (string.equals("dense")) {
            return DoubleFactory2D.dense;
        }
        if (string.equals("sparse")) {
            return DoubleFactory2D.sparse;
        }
        if (string.equals("rowCompressed")) {
            return DoubleFactory2D.rowCompressed;
        }
        String string2 = "type=" + string + " is unknown. Use one of {dense,sparse,rowCompressed}";
        throw new IllegalArgumentException(string2);
    }

    protected static Double2DProcedure getGenericFunction(String string) {
        if (string.equals("dgemm")) {
            return BenchmarkMatrix.fun_dgemm(false, false);
        }
        if (string.equals("dgemv")) {
            return BenchmarkMatrix.fun_dgemv(false);
        }
        if (string.equals("pow")) {
            return BenchmarkMatrix.fun_pow(2);
        }
        if (string.equals("assign")) {
            return BenchmarkMatrix.funAssign();
        }
        if (string.equals("assignGetSet")) {
            return BenchmarkMatrix.funAssignGetSet();
        }
        if (string.equals("assignGetSetQuick")) {
            return BenchmarkMatrix.funAssignGetSetQuick();
        }
        if (string.equals("elementwiseMult")) {
            return BenchmarkMatrix.funElementwiseMult();
        }
        if (string.equals("elementwiseMultB")) {
            return BenchmarkMatrix.funElementwiseMultB();
        }
        if (string.equals("SOR5")) {
            return BenchmarkMatrix.funSOR5();
        }
        if (string.equals("SOR8")) {
            return BenchmarkMatrix.funSOR8();
        }
        if (string.equals("LUDecompose")) {
            return BenchmarkMatrix.funLUDecompose();
        }
        if (string.equals("LUSolve")) {
            return BenchmarkMatrix.funLUSolve();
        }
        if (string.equals("assignLog")) {
            return BenchmarkMatrix.funAssignLog();
        }
        if (string.equals("assignPlusMult")) {
            return BenchmarkMatrix.funAssignPlusMult();
        }
        return null;
    }

    protected static boolean handle(String[] stringArray) {
        boolean bl = true;
        String string = stringArray[0];
        if (string.equals("dgemm")) {
            BenchmarkMatrix.bench_dgemm(stringArray);
        } else if (string.equals("dgemv")) {
            BenchmarkMatrix.bench_dgemv(stringArray);
        } else if (string.equals("pow")) {
            BenchmarkMatrix.bench_pow(stringArray);
        } else {
            Double2DProcedure double2DProcedure = BenchmarkMatrix.getGenericFunction(string);
            if (double2DProcedure != null) {
                BenchmarkMatrix.benchGeneric(double2DProcedure, stringArray);
            } else {
                bl = false;
                String string2 = "Command=" + stringArray[0] + " is illegal or unknown. Should be one of " + BenchmarkMatrix.commands() + "followed by appropriate parameters.\n" + BenchmarkMatrix.usage() + "\nIgnoring this line.\n";
                System.out.println(string2);
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0 || n <= 1 && stringArray[0].equals("-help")) {
            System.out.println(BenchmarkMatrix.usage());
            return;
        }
        if (stringArray[0].equals("-help")) {
            if (BenchmarkMatrix.commands().indexOf(stringArray[1]) < 0) {
                System.out.println(stringArray[1] + ": no such command available.\n" + BenchmarkMatrix.usage());
            } else {
                System.out.println(BenchmarkMatrix.usage(stringArray[1]));
            }
            return;
        }
        System.out.println("Colt Matrix benchmark running on\n");
        System.out.println(BenchmarkKernel.systemInfo() + "\n");
        System.out.println("Colt Version is " + Version.asString() + "\n");
        Timer timer = new Timer().start();
        if (!stringArray[0].equals("-file")) {
            System.out.println("\n\nExecuting command = " + new ObjectArrayList(stringArray) + " ...");
            BenchmarkMatrix.handle(stringArray);
        } else {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(stringArray[1]));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.slashSlashComments(true);
            streamTokenizer.slashStarComments(true);
            try {
                Object object;
                ObjectArrayList objectArrayList = new ObjectArrayList();
                while (true) {
                    int n2 = streamTokenizer.nextToken();
                    if (n2 == -1) break;
                    if (n2 == 10) {
                        if (objectArrayList.size() > 0) {
                            object = new String[objectArrayList.size()];
                            for (int i = 0; i < objectArrayList.size(); ++i) {
                                object[i] = (String)objectArrayList.get(i);
                            }
                            System.out.println("\n\nExecuting command = " + objectArrayList + " ...");
                            BenchmarkMatrix.handle(object);
                        }
                        objectArrayList.clear();
                        continue;
                    }
                    Former former = new FormerFactory().create("%G");
                    object = n2 == -2 ? former.form(streamTokenizer.nval) : streamTokenizer.sval;
                    if (object == null) continue;
                    objectArrayList.add(object);
                }
                bufferedReader.close();
                System.out.println("\nCommand file name used: " + stringArray[1] + "\nTo reproduce and compare results, here it's contents:");
                try {
                    bufferedReader = new BufferedReader(new FileReader(stringArray[1]));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage());
                }
                while ((object = bufferedReader.readLine()) != null) {
                    System.out.println((String)object);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
        System.out.println("\nProgram execution took a total of " + timer.minutes() + " minutes.");
        System.out.println("Good bye.");
    }

    protected static void run(double d2, String string, Double2DProcedure double2DProcedure, String[] stringArray, int[] nArray, double[] dArray) {
        Object object;
        DoubleMatrix3D doubleMatrix3D = DoubleFactory3D.dense.make(stringArray.length, nArray.length, dArray.length);
        Timer timer = new Timer().start();
        for (int i = 0; i < stringArray.length; ++i) {
            object = BenchmarkMatrix.getFactory(stringArray[i]);
            System.out.print("\n@");
            for (int j = 0; j < nArray.length; ++j) {
                int n = nArray[j];
                System.out.print("x");
                for (int k = 0; k < dArray.length; ++k) {
                    float f2;
                    double d3 = dArray[k];
                    System.out.print(".");
                    if (i <= 0 || !(d3 >= 0.1) || n < 500) {
                        double d4 = 0.5;
                        double2DProcedure.A = null;
                        double2DProcedure.B = null;
                        double2DProcedure.C = null;
                        double2DProcedure.D = null;
                        DoubleMatrix2D doubleMatrix2D = ((DoubleFactory2D)object).sample(n, n, d4, d3);
                        DoubleMatrix2D doubleMatrix2D2 = ((DoubleFactory2D)object).sample(n, n, d4, d3);
                        double2DProcedure.setParameters(doubleMatrix2D, doubleMatrix2D2);
                        doubleMatrix2D = null;
                        doubleMatrix2D2 = null;
                        double d5 = double2DProcedure.operations();
                        double d6 = BenchmarkKernel.run(d2, double2DProcedure);
                        f2 = (float)(d5 / d6);
                    } else {
                        f2 = Float.NaN;
                    }
                    doubleMatrix3D.set(i, j, k, f2);
                }
            }
        }
        timer.stop();
        String string2 = "type";
        object = "size";
        Object object2 = "d";
        String[] stringArray2 = stringArray;
        BinFunctions1D binFunctions1D = BinFunctions1D.functions;
        BinFunction1D[] binFunction1DArray = null;
        String[] stringArray3 = new String[nArray.length];
        String[] stringArray4 = new String[dArray.length];
        int n = nArray.length;
        while (--n >= 0) {
            stringArray3[n] = Integer.toString(nArray[n]);
        }
        n = dArray.length;
        while (--n >= 0) {
            stringArray4[n] = Double.toString(dArray[n]);
        }
        System.out.println("*");
        Object object3 = object;
        object = object2;
        object2 = object3;
        String[] stringArray5 = stringArray3;
        stringArray3 = stringArray4;
        stringArray4 = stringArray5;
        doubleMatrix3D = doubleMatrix3D.viewDice(0, 2, 1);
        System.out.println(new Formatter("%1.3G").toTitleString(doubleMatrix3D, stringArray2, stringArray3, stringArray4, string2, (String)object, (String)object2, "Performance of " + string, binFunction1DArray));
        System.out.println("Run took a total of " + timer + ". End of run.");
    }

    protected static void runSpecial(double d2, String string, Double2DProcedure double2DProcedure) {
        DoubleFactory2D doubleFactory2D;
        int[] nArray = new int[]{10000};
        double[] dArray = new double[]{1.0E-5};
        boolean[] blArray = new boolean[]{true};
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(nArray.length, 4);
        Timer timer = new Timer().start();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            double d3 = dArray[i];
            boolean bl = blArray[i];
            doubleFactory2D = bl ? DoubleFactory2D.sparse : DoubleFactory2D.dense;
            System.out.print("\n@");
            System.out.print("x");
            double d4 = 0.5;
            double2DProcedure.A = null;
            double2DProcedure.B = null;
            double2DProcedure.C = null;
            double2DProcedure.D = null;
            DoubleMatrix2D doubleMatrix2D2 = doubleFactory2D.sample(n, n, d4, d3);
            DoubleMatrix2D doubleMatrix2D3 = doubleFactory2D.sample(n, n, d4, d3);
            double2DProcedure.setParameters(doubleMatrix2D2, doubleMatrix2D3);
            doubleMatrix2D2 = null;
            doubleMatrix2D3 = null;
            float f2 = BenchmarkKernel.run(d2, double2DProcedure);
            double d5 = double2DProcedure.operations();
            float f3 = (float)(d5 / (double)f2);
            doubleMatrix2D.viewRow(i).set(0, bl ? 0.0 : 1.0);
            doubleMatrix2D.viewRow(i).set(1, n);
            doubleMatrix2D.viewRow(i).set(2, d3);
            doubleMatrix2D.viewRow(i).set(3, f3);
        }
        timer.stop();
        BinFunctions1D binFunctions1D = BinFunctions1D.functions;
        BinFunction1D[] binFunction1DArray = null;
        String[] stringArray = null;
        String[] stringArray2 = new String[]{"dense (y=1,n=0)", "size", "density", "flops/sec"};
        String string2 = null;
        doubleFactory2D = null;
        System.out.println("*");
        System.out.println(new Formatter("%1.3G").toTitleString(doubleMatrix2D, stringArray, stringArray2, string2, (String)((Object)doubleFactory2D), string, binFunction1DArray));
        System.out.println("Run took a total of " + timer + ". End of run.");
    }

    protected static String usage() {
        String string = "\nUsage (help): To get this help, type java cern.colt.matrix.bench.BenchmarkMatrix -help\nTo get help on a command's args, omit args and type java cern.colt.matrix.bench.BenchmarkMatrix -help <command>\nAvailable commands: " + BenchmarkMatrix.commands() + "\n\n" + "Usage (direct): java cern.colt.matrix.bench.BenchmarkMatrix command {args}\n" + "Example: dgemm dense 2 2.0 0.999 false true 5 10 25 50 100 250 500\n\n" + "Usage (batch mode): java cern.colt.matrix.bench.BenchmarkMatrix -file <file>\nwhere <file> is a text file with each line holding a command followed by appropriate args (comments and empty lines ignored).\n\n" + "Example file's content:\n" + "dgemm dense 1 2.0 0.999 false true 5 10 25 50 100 250 500\n" + "dgemm dense 2 2.0 0.999 false true 5 10 25 50 100 250 500\n\n" + "/*\n" + "Java like comments in file are ignored\n" + "dgemv dense 1 2.0 0.001 false 5 10 25 50 100 250 500 1000\n" + "dgemv sparse 1 2.0 0.001 false 5 10 25 50 100 250 500 1000\n" + "dgemv rowCompressed 1 2.0 0.001 false 5 10 25 50 100 250 500 1000\n" + "*/\n" + "// more comments ignored\n";
        return string;
    }

    protected static String usage(String string) {
        String string2 = string + " description: " + BenchmarkMatrix.getGenericFunction(string).toString() + "\nArguments to be supplied:\n" + "\t<operation> <type> <cpus> <minSecs> <density>";
        if (string.equals("dgemv")) {
            string2 = string2 + " <transposeA>";
        }
        if (string.equals("dgemm")) {
            string2 = string2 + " <transposeA> <transposeB>";
        }
        if (string.equals("pow")) {
            string2 = string2 + " <exponent>";
        }
        string2 = string2 + " {sizes}\n" + "where\n" + "\toperation = the operation to benchmark; in this case: " + string + "\n" + "\ttype = matrix type to be used; e.g. dense, sparse or rowCompressed\n" + "\tcpus = #cpus available; e.g. 1 or 2 or ...\n" + "\tminSecs = #seconds each operation shall at least run; e.g. 2.0 is a good number giving realistic timings\n" + "\tdensity = the density of the matrices to be benchmarked; e.g. 0.999 is very dense, 0.001 is very sparse\n";
        if (string.equals("dgemv")) {
            string2 = string2 + "\ttransposeA = false or true\n";
        }
        if (string.equals("dgemm")) {
            string2 = string2 + "\ttransposeA = false or true\n\ttransposeB = false or true\n";
        }
        if (string.equals("pow")) {
            string2 = string2 + "\texponent = the number of times to multiply; e.g. 1000\n";
        }
        string2 = string2 + "\tsizes = a list of problem sizes; e.g. 100 200 benchmarks squared 100x100 and 200x200 matrices";
        return string2;
    }
}

