/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.GenericPermuting;
import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.bitvector.QuickBitVector;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.IntComparator;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Blas;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.Diagonal;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import cern.colt.matrix.linalg.LUDecomposition;
import cern.colt.matrix.linalg.Property;
import cern.colt.matrix.linalg.QRDecomposition;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.colt.matrix.linalg.SmpBlas;
import cern.jet.math.Functions;

public class Algebra
extends PersistentObject {
    public static final Algebra DEFAULT = new Algebra();
    public static final Algebra ZERO;
    protected Property property;

    public Algebra() {
        this(Property.DEFAULT.tolerance());
    }

    public Algebra(double d2) {
        this.setProperty(new Property(d2));
    }

    private CholeskyDecomposition chol(DoubleMatrix2D doubleMatrix2D) {
        return new CholeskyDecomposition(doubleMatrix2D);
    }

    public Object clone() {
        return new Algebra(this.property.tolerance());
    }

    public double cond(DoubleMatrix2D doubleMatrix2D) {
        return this.svd(doubleMatrix2D).cond();
    }

    public double det(DoubleMatrix2D doubleMatrix2D) {
        return this.lu(doubleMatrix2D).det();
    }

    private EigenvalueDecomposition eig(DoubleMatrix2D doubleMatrix2D) {
        return new EigenvalueDecomposition(doubleMatrix2D);
    }

    protected static double hypot(double d2, double d3) {
        double d4;
        if (Math.abs(d2) > Math.abs(d3)) {
            d4 = d3 / d2;
            d4 = Math.abs(d2) * Math.sqrt(1.0 + d4 * d4);
        } else if (d3 != 0.0) {
            d4 = d2 / d3;
            d4 = Math.abs(d3) * Math.sqrt(1.0 + d4 * d4);
        } else {
            d4 = 0.0;
        }
        return d4;
    }

    protected static DoubleDoubleFunction hypotFunction() {
        return new DoubleDoubleFunction(){

            public final double apply(double d2, double d3) {
                return Algebra.hypot(d2, d3);
            }
        };
    }

    public DoubleMatrix2D inverse(DoubleMatrix2D doubleMatrix2D) {
        if (this.property.isSquare(doubleMatrix2D) && this.property.isDiagonal(doubleMatrix2D)) {
            DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
            boolean bl = Diagonal.inverse(doubleMatrix2D2);
            if (!bl) {
                throw new IllegalArgumentException("A is singular.");
            }
            return doubleMatrix2D2;
        }
        return this.solve(doubleMatrix2D, DoubleFactory2D.dense.identity(doubleMatrix2D.rows()));
    }

    private LUDecomposition lu(DoubleMatrix2D doubleMatrix2D) {
        return new LUDecomposition(doubleMatrix2D);
    }

    public double mult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        return doubleMatrix1D.zDotProduct(doubleMatrix1D2);
    }

    public DoubleMatrix1D mult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        return doubleMatrix2D.zMult(doubleMatrix1D, null);
    }

    public DoubleMatrix2D mult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return doubleMatrix2D.zMult(doubleMatrix2D2, null);
    }

    public DoubleMatrix2D multOuter(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix1D.size();
        int n2 = doubleMatrix1D2.size();
        if (doubleMatrix2D == null) {
            doubleMatrix2D = doubleMatrix1D.like2D(n, n2);
        }
        if (doubleMatrix2D.rows() != n || doubleMatrix2D.columns() != n2) {
            throw new IllegalArgumentException();
        }
        int n3 = n;
        while (--n3 >= 0) {
            doubleMatrix2D.viewRow(n3).assign(doubleMatrix1D2);
        }
        n3 = n2;
        while (--n3 >= 0) {
            doubleMatrix2D.viewColumn(n3).assign(doubleMatrix1D, Functions.mult);
        }
        return doubleMatrix2D;
    }

    public double norm1(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() == 0) {
            return 0.0;
        }
        return doubleMatrix1D.aggregate(Functions.plus, Functions.abs);
    }

    public double norm1(DoubleMatrix2D doubleMatrix2D) {
        double d2 = 0.0;
        int n = doubleMatrix2D.columns();
        while (--n >= 0) {
            d2 = Math.max(d2, this.norm1(doubleMatrix2D.viewColumn(n)));
        }
        return d2;
    }

    public double norm2(DoubleMatrix1D doubleMatrix1D) {
        return this.mult(doubleMatrix1D, doubleMatrix1D);
    }

    public double norm2(DoubleMatrix2D doubleMatrix2D) {
        return this.svd(doubleMatrix2D).norm2();
    }

    public double normF(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.size() == 0) {
            return 0.0;
        }
        return doubleMatrix2D.aggregate(Algebra.hypotFunction(), Functions.identity);
    }

    public double normInfinity(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() == 0) {
            return 0.0;
        }
        return doubleMatrix1D.aggregate(Functions.max, Functions.abs);
    }

    public double normInfinity(DoubleMatrix2D doubleMatrix2D) {
        double d2 = 0.0;
        int n = doubleMatrix2D.rows();
        while (--n >= 0) {
            d2 = Math.max(d2, this.norm1(doubleMatrix2D.viewRow(n)));
        }
        return d2;
    }

    public DoubleMatrix1D permute(DoubleMatrix1D doubleMatrix1D, int[] nArray, double[] dArray) {
        int n = doubleMatrix1D.size();
        if (nArray.length != n) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        if (dArray == null || n > dArray.length) {
            dArray = doubleMatrix1D.toArray();
        } else {
            doubleMatrix1D.toArray(dArray);
        }
        int n2 = n;
        while (--n2 >= 0) {
            doubleMatrix1D.setQuick(n2, dArray[nArray[n2]]);
        }
        return doubleMatrix1D;
    }

    public DoubleMatrix2D permute(DoubleMatrix2D doubleMatrix2D, int[] nArray, int[] nArray2) {
        return doubleMatrix2D.viewSelection(nArray, nArray2);
    }

    public DoubleMatrix2D permuteColumns(DoubleMatrix2D doubleMatrix2D, int[] nArray, int[] nArray2) {
        return this.permuteRows(doubleMatrix2D.viewDice(), nArray, nArray2);
    }

    public DoubleMatrix2D permuteRows(final DoubleMatrix2D doubleMatrix2D, int[] nArray, int[] nArray2) {
        int n = doubleMatrix2D.rows();
        if (nArray.length != n) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        int n2 = doubleMatrix2D.columns();
        if (n2 < n / 10) {
            double[] dArray = new double[n];
            int n3 = doubleMatrix2D.columns();
            while (--n3 >= 0) {
                this.permute(doubleMatrix2D.viewColumn(n3), nArray, dArray);
            }
            return doubleMatrix2D;
        }
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                doubleMatrix2D.viewRow(n).swap(doubleMatrix2D.viewRow(n2));
            }
        };
        GenericPermuting.permute(nArray, swapper, nArray2, null);
        return doubleMatrix2D;
    }

    public DoubleMatrix2D pow(DoubleMatrix2D doubleMatrix2D, int n) {
        DoubleMatrix2D doubleMatrix2D2;
        int n2;
        Blas blas = SmpBlas.smpBlas;
        Property.DEFAULT.checkSquare(doubleMatrix2D);
        if (n < 0) {
            doubleMatrix2D = this.inverse(doubleMatrix2D);
            n = -n;
        }
        if (n == 0) {
            return DoubleFactory2D.dense.identity(doubleMatrix2D.rows());
        }
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D.like();
        if (n == 1) {
            return doubleMatrix2D3.assign(doubleMatrix2D);
        }
        if (n == 2) {
            blas.dgemm(false, false, 1.0, doubleMatrix2D, doubleMatrix2D, 0.0, doubleMatrix2D3);
            return doubleMatrix2D3;
        }
        int n3 = QuickBitVector.mostSignificantBit(n);
        for (n2 = 0; n2 <= n3 && (n & 1 << n2) == 0; ++n2) {
            blas.dgemm(false, false, 1.0, doubleMatrix2D, doubleMatrix2D, 0.0, doubleMatrix2D3);
            doubleMatrix2D2 = doubleMatrix2D;
            doubleMatrix2D = doubleMatrix2D3;
            doubleMatrix2D3 = doubleMatrix2D2;
        }
        doubleMatrix2D2 = doubleMatrix2D.copy();
        ++n2;
        while (n2 <= n3) {
            blas.dgemm(false, false, 1.0, doubleMatrix2D, doubleMatrix2D, 0.0, doubleMatrix2D3);
            DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D;
            doubleMatrix2D = doubleMatrix2D3;
            doubleMatrix2D3 = doubleMatrix2D4;
            if ((n & 1 << n2) != 0) {
                blas.dgemm(false, false, 1.0, doubleMatrix2D2, doubleMatrix2D, 0.0, doubleMatrix2D3);
                doubleMatrix2D4 = doubleMatrix2D2;
                doubleMatrix2D2 = doubleMatrix2D3;
                doubleMatrix2D3 = doubleMatrix2D4;
            }
            ++n2;
        }
        return doubleMatrix2D2;
    }

    public Property property() {
        return this.property;
    }

    private QRDecomposition qr(DoubleMatrix2D doubleMatrix2D) {
        return new QRDecomposition(doubleMatrix2D);
    }

    public int rank(DoubleMatrix2D doubleMatrix2D) {
        return this.svd(doubleMatrix2D).rank();
    }

    public void setProperty(Property property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return doubleMatrix2D.rows() == doubleMatrix2D.columns() ? this.lu(doubleMatrix2D).solve(doubleMatrix2D2) : this.qr(doubleMatrix2D).solve(doubleMatrix2D2);
    }

    public DoubleMatrix2D solveTranspose(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return this.solve(this.transpose(doubleMatrix2D), this.transpose(doubleMatrix2D2));
    }

    private DoubleMatrix2D subMatrix(DoubleMatrix2D doubleMatrix2D, int[] nArray, int n, int n2) {
        int n3 = n2 - n + 1;
        int n4 = doubleMatrix2D.rows();
        doubleMatrix2D = doubleMatrix2D.viewPart(0, n, n4, n3);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like(nArray.length, n3);
        int n5 = nArray.length;
        while (--n5 >= 0) {
            int n6 = nArray[n5];
            if (n6 < 0 || n6 >= n4) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            doubleMatrix2D2.viewRow(n5).assign(doubleMatrix2D.viewRow(n6));
        }
        return doubleMatrix2D2;
    }

    private DoubleMatrix2D subMatrix(DoubleMatrix2D doubleMatrix2D, int n, int n2, int[] nArray) {
        if (n2 - n >= doubleMatrix2D.rows()) {
            throw new IndexOutOfBoundsException("Too many rows");
        }
        int n3 = n2 - n + 1;
        int n4 = doubleMatrix2D.columns();
        doubleMatrix2D = doubleMatrix2D.viewPart(n, 0, n3, n4);
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like(n3, nArray.length);
        int n5 = nArray.length;
        while (--n5 >= 0) {
            int n6 = nArray[n5];
            if (n6 < 0 || n6 >= n4) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            doubleMatrix2D2.viewColumn(n5).assign(doubleMatrix2D.viewColumn(n6));
        }
        return doubleMatrix2D2;
    }

    public DoubleMatrix2D subMatrix(DoubleMatrix2D doubleMatrix2D, int n, int n2, int n3, int n4) {
        return doubleMatrix2D.viewPart(n, n3, n2 - n + 1, n4 - n3 + 1);
    }

    private SingularValueDecomposition svd(DoubleMatrix2D doubleMatrix2D) {
        return new SingularValueDecomposition(doubleMatrix2D);
    }

    public String toString(DoubleMatrix2D doubleMatrix2D) {
        int n;
        final ObjectArrayList objectArrayList = new ObjectArrayList();
        final ObjectArrayList objectArrayList2 = new ObjectArrayList();
        String string = "Illegal operation or error: ";
        objectArrayList.add("cond");
        try {
            objectArrayList2.add(String.valueOf(this.cond(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("det");
        try {
            objectArrayList2.add(String.valueOf(this.det(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("norm1");
        try {
            objectArrayList2.add(String.valueOf(this.norm1(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("norm2");
        try {
            objectArrayList2.add(String.valueOf(this.norm2(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("normF");
        try {
            objectArrayList2.add(String.valueOf(this.normF(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("normInfinity");
        try {
            objectArrayList2.add(String.valueOf(this.normInfinity(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("rank");
        try {
            objectArrayList2.add(String.valueOf(this.rank(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("trace");
        try {
            objectArrayList2.add(String.valueOf(this.trace(doubleMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return Property.get(objectArrayList, n).compareTo(Property.get(objectArrayList, n2));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArrayList.get(n);
                objectArrayList.set(n, objectArrayList.get(n2));
                objectArrayList.set(n2, object);
                object = objectArrayList2.get(n);
                objectArrayList2.set(n, objectArrayList2.get(n2));
                objectArrayList2.set(n2, object);
            }
        };
        GenericSorting.quickSort(0, objectArrayList.size(), intComparator, swapper);
        int n2 = 0;
        for (int i = 0; i < objectArrayList.size(); ++i) {
            n = ((String)objectArrayList.get(i)).length();
            n2 = Math.max(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < objectArrayList.size(); ++n) {
            String string2 = (String)objectArrayList.get(n);
            stringBuffer.append(string2);
            stringBuffer.append(Property.blanks(n2 - string2.length()));
            stringBuffer.append(" : ");
            stringBuffer.append(objectArrayList2.get(n));
            if (n >= objectArrayList.size() - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String toVerboseString(DoubleMatrix2D doubleMatrix2D) {
        String string = "Illegal operation or error upon construction of ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("A = ");
        stringBuffer.append(doubleMatrix2D);
        stringBuffer.append("\n\n" + this.toString(doubleMatrix2D));
        stringBuffer.append("\n\n" + Property.DEFAULT.toString(doubleMatrix2D));
        LUDecomposition lUDecomposition = null;
        try {
            lUDecomposition = new LUDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " LUDecomposition: " + illegalArgumentException.getMessage());
        }
        if (lUDecomposition != null) {
            stringBuffer.append("\n\n" + lUDecomposition.toString());
        }
        QRDecomposition qRDecomposition = null;
        try {
            qRDecomposition = new QRDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " QRDecomposition: " + illegalArgumentException.getMessage());
        }
        if (qRDecomposition != null) {
            stringBuffer.append("\n\n" + qRDecomposition.toString());
        }
        CholeskyDecomposition choleskyDecomposition = null;
        try {
            choleskyDecomposition = new CholeskyDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " CholeskyDecomposition: " + illegalArgumentException.getMessage());
        }
        if (choleskyDecomposition != null) {
            stringBuffer.append("\n\n" + choleskyDecomposition.toString());
        }
        EigenvalueDecomposition eigenvalueDecomposition = null;
        try {
            eigenvalueDecomposition = new EigenvalueDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " EigenvalueDecomposition: " + illegalArgumentException.getMessage());
        }
        if (eigenvalueDecomposition != null) {
            stringBuffer.append("\n\n" + eigenvalueDecomposition.toString());
        }
        SingularValueDecomposition singularValueDecomposition = null;
        try {
            singularValueDecomposition = new SingularValueDecomposition(doubleMatrix2D);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("\n\n" + string + " SingularValueDecomposition: " + illegalArgumentException.getMessage());
        }
        if (singularValueDecomposition != null) {
            stringBuffer.append("\n\n" + singularValueDecomposition.toString());
        }
        return stringBuffer.toString();
    }

    public double trace(DoubleMatrix2D doubleMatrix2D) {
        double d2 = 0.0;
        int n = Math.min(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        while (--n >= 0) {
            d2 += doubleMatrix2D.getQuick(n, n);
        }
        return d2;
    }

    public DoubleMatrix2D transpose(DoubleMatrix2D doubleMatrix2D) {
        return doubleMatrix2D.viewDice();
    }

    protected DoubleMatrix2D trapezoidalLower(DoubleMatrix2D doubleMatrix2D) {
        int n = doubleMatrix2D.rows();
        int n2 = doubleMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 >= n4) continue;
                doubleMatrix2D.setQuick(n3, n4, 0.0);
            }
        }
        return doubleMatrix2D;
    }

    private DoubleMatrix2D xmultOuter(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        DoubleMatrix2D doubleMatrix2D = doubleMatrix1D.like2D(doubleMatrix1D.size(), doubleMatrix1D2.size());
        this.multOuter(doubleMatrix1D, doubleMatrix1D2, doubleMatrix2D);
        return doubleMatrix2D;
    }

    private DoubleMatrix2D xpowSlow(DoubleMatrix2D doubleMatrix2D, int n) {
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
        for (int i = 0; i < n - 1; ++i) {
            doubleMatrix2D2 = this.mult(doubleMatrix2D2, doubleMatrix2D);
        }
        return doubleMatrix2D2;
    }

    static {
        Algebra.DEFAULT.property = Property.DEFAULT;
        ZERO = new Algebra();
        Algebra.ZERO.property = Property.ZERO;
    }
}

