/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Blas;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import cern.jet.math.PlusMult;

public class SeqBlas
implements Blas {
    public static final Blas seqBlas = new SeqBlas();
    private static final Functions F = Functions.functions;

    protected SeqBlas() {
    }

    public void assign(DoubleMatrix2D doubleMatrix2D, DoubleFunction doubleFunction) {
        doubleMatrix2D.assign(doubleFunction);
    }

    public void assign(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleDoubleFunction doubleDoubleFunction) {
        doubleMatrix2D.assign(doubleMatrix2D2, doubleDoubleFunction);
    }

    public double dasum(DoubleMatrix1D doubleMatrix1D) {
        return doubleMatrix1D.aggregate(Functions.plus, Functions.abs);
    }

    public void daxpy(double d2, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D, Functions.plusMult(d2));
    }

    public void daxpy(double d2, DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        doubleMatrix2D2.assign(doubleMatrix2D, Functions.plusMult(d2));
    }

    public void dcopy(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.assign(doubleMatrix1D);
    }

    public void dcopy(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        doubleMatrix2D2.assign(doubleMatrix2D);
    }

    public double ddot(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        return doubleMatrix1D.zDotProduct(doubleMatrix1D2);
    }

    public void dgemm(boolean bl, boolean bl2, double d2, DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d3, DoubleMatrix2D doubleMatrix2D3) {
        doubleMatrix2D.zMult(doubleMatrix2D2, doubleMatrix2D3, d2, d3, bl, bl2);
    }

    public void dgemv(boolean bl, double d2, DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, double d3, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix2D.zMult(doubleMatrix1D, doubleMatrix1D2, d2, d3, bl);
    }

    public void dger(double d2, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, DoubleMatrix2D doubleMatrix2D) {
        PlusMult plusMult = PlusMult.plusMult(0.0);
        int n = doubleMatrix2D.rows();
        while (--n >= 0) {
            plusMult.multiplicator = d2 * doubleMatrix1D.getQuick(n);
            doubleMatrix2D.viewRow(n).assign(doubleMatrix1D2, plusMult);
        }
    }

    public double dnrm2(DoubleMatrix1D doubleMatrix1D) {
        return Math.sqrt(Algebra.DEFAULT.norm2(doubleMatrix1D));
    }

    public void drot(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d2, double d3) {
        doubleMatrix1D.checkSize(doubleMatrix1D2);
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D.copy();
        doubleMatrix1D.assign(Functions.mult(d2));
        doubleMatrix1D.assign(doubleMatrix1D2, Functions.plusMult(d3));
        doubleMatrix1D2.assign(Functions.mult(d2));
        doubleMatrix1D2.assign(doubleMatrix1D3, Functions.minusMult(d3));
    }

    public void drotg(double d2, double d3, double[] dArray) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = d3;
        if (Math.abs(d2) > Math.abs(d3)) {
            d9 = d2;
        }
        if ((d8 = Math.abs(d2) + Math.abs(d3)) != 0.0) {
            double d10 = d2 / d8;
            double d11 = d3 / d8;
            d7 = d8 * Math.sqrt(d10 * d10 + d11 * d11);
            d7 = this.sign(1.0, d9) * d7;
            d6 = d2 / d7;
            d5 = d3 / d7;
            d4 = 1.0;
            if (Math.abs(d2) > Math.abs(d3)) {
                d4 = d5;
            }
            if (Math.abs(d3) >= Math.abs(d2) && d6 != 0.0) {
                d4 = 1.0 / d6;
            }
        } else {
            d6 = 1.0;
            d5 = 0.0;
            d7 = 0.0;
            d4 = 0.0;
        }
        d2 = d7;
        d3 = d4;
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d6;
        dArray[3] = d5;
    }

    public void dscal(double d2, DoubleMatrix1D doubleMatrix1D) {
        doubleMatrix1D.assign(Functions.mult(d2));
    }

    public void dscal(double d2, DoubleMatrix2D doubleMatrix2D) {
        doubleMatrix2D.assign(Functions.mult(d2));
    }

    public void dswap(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        doubleMatrix1D2.swap(doubleMatrix1D);
    }

    public void dswap(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        doubleMatrix2D.checkShape(doubleMatrix2D2);
        int n = doubleMatrix2D.rows();
        while (--n >= 0) {
            doubleMatrix2D.viewRow(n).swap(doubleMatrix2D2.viewRow(n));
        }
    }

    public void dsymv(boolean bl, double d2, DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, double d3, DoubleMatrix1D doubleMatrix1D2) {
        if (bl) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
        }
        Property.DEFAULT.checkSquare(doubleMatrix2D);
        int n = doubleMatrix2D.rows();
        if (n != doubleMatrix1D.size() || n != doubleMatrix1D2.size()) {
            throw new IllegalArgumentException(doubleMatrix2D.toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D.like();
        for (int i = 0; i < n; ++i) {
            int n2;
            double d4 = 0.0;
            for (n2 = 0; n2 <= i; ++n2) {
                d4 += doubleMatrix2D.getQuick(i, n2) * doubleMatrix1D.getQuick(n2);
            }
            for (n2 = i + 1; n2 < n; ++n2) {
                d4 += doubleMatrix2D.getQuick(n2, i) * doubleMatrix1D.getQuick(n2);
            }
            doubleMatrix1D3.setQuick(i, d2 * d4 + d3 * doubleMatrix1D2.getQuick(i));
        }
        doubleMatrix1D2.assign(doubleMatrix1D3);
    }

    public void dtrmv(boolean bl, boolean bl2, boolean bl3, DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D) {
        int n;
        if (bl2) {
            doubleMatrix2D = doubleMatrix2D.viewDice();
            bl = !bl;
        }
        Property.DEFAULT.checkSquare(doubleMatrix2D);
        int n2 = doubleMatrix2D.rows();
        if (n2 != doubleMatrix1D.size()) {
            throw new IllegalArgumentException(doubleMatrix2D.toStringShort() + ", " + doubleMatrix1D.toStringShort());
        }
        DoubleMatrix1D doubleMatrix1D2 = doubleMatrix1D.like();
        DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D.like();
        if (bl3) {
            doubleMatrix1D3.assign(1.0);
        } else {
            for (n = 0; n < n2; ++n) {
                doubleMatrix1D3.setQuick(n, doubleMatrix2D.getQuick(n, n));
            }
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            double d2 = 0.0;
            if (!bl) {
                for (n3 = 0; n3 < n; ++n3) {
                    d2 += doubleMatrix2D.getQuick(n, n3) * doubleMatrix1D.getQuick(n3);
                }
                d2 += doubleMatrix1D3.getQuick(n) * doubleMatrix1D.getQuick(n);
            } else {
                d2 += doubleMatrix1D3.getQuick(n) * doubleMatrix1D.getQuick(n);
                for (n3 = n + 1; n3 < n2; ++n3) {
                    d2 += doubleMatrix2D.getQuick(n, n3) * doubleMatrix1D.getQuick(n3);
                }
            }
            doubleMatrix1D2.setQuick(n, d2);
        }
        doubleMatrix1D.assign(doubleMatrix1D2);
    }

    public int idamax(DoubleMatrix1D doubleMatrix1D) {
        int n = -1;
        double d2 = Double.MIN_VALUE;
        int n2 = doubleMatrix1D.size();
        while (--n2 >= 0) {
            double d3 = Math.abs(doubleMatrix1D.getQuick(n2));
            if (!(d3 > d2)) continue;
            d2 = d3;
            n = n2;
        }
        return n;
    }

    private double sign(double d2, double d3) {
        if (d3 < 0.0) {
            return -Math.abs(d2);
        }
        return Math.abs(d2);
    }
}

