/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.BreitWigner;
import cern.jet.random.Uniform;
import cern.jet.random.engine.RandomEngine;

public class BreitWignerMeanSquare
extends BreitWigner {
    protected Uniform uniform;
    protected static BreitWigner shared = new BreitWignerMeanSquare(1.0, 0.2, 1.0, BreitWignerMeanSquare.makeDefaultGenerator());

    public BreitWignerMeanSquare(double d2, double d3, double d4, RandomEngine randomEngine) {
        super(d2, d3, d4, randomEngine);
        this.uniform = new Uniform(randomEngine);
    }

    public Object clone() {
        BreitWignerMeanSquare breitWignerMeanSquare = (BreitWignerMeanSquare)super.clone();
        if (this.uniform != null) {
            breitWignerMeanSquare.uniform = new Uniform(breitWignerMeanSquare.randomGenerator);
        }
        return breitWignerMeanSquare;
    }

    public double nextDouble(double d2, double d3, double d4) {
        if (d3 == 0.0) {
            return d2;
        }
        if (d4 == Double.NEGATIVE_INFINITY) {
            double d5 = Math.atan(-d2 / d3);
            double d6 = this.uniform.nextDoubleFromTo(d5, 1.5707963267948966);
            double d7 = d3 * Math.tan(d6);
            return Math.sqrt(d2 * d2 + d2 * d7);
        }
        double d8 = Math.max(0.0, d2 - d4);
        double d9 = Math.atan((d8 * d8 - d2 * d2) / (d2 * d3));
        double d10 = Math.atan(((d2 + d4) * (d2 + d4) - d2 * d2) / (d2 * d3));
        double d11 = this.uniform.nextDoubleFromTo(d9, d10);
        double d12 = d3 * Math.tan(d11);
        return Math.sqrt(Math.max(0.0, d2 * d2 + d2 * d12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d2, double d3, double d4) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            return shared.nextDouble(d2, d3, d4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

