/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.math.Arithmetic;
import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.Gamma;
import cern.jet.random.Poisson;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class NegativeBinomial
extends AbstractDiscreteDistribution {
    protected int n;
    protected double p;
    protected Gamma gamma;
    protected Poisson poisson;
    protected static NegativeBinomial shared = new NegativeBinomial(1, 0.5, NegativeBinomial.makeDefaultGenerator());

    public NegativeBinomial(int n, double d2, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setNandP(n, d2);
        this.gamma = new Gamma(n, 1.0, randomEngine);
        this.poisson = new Poisson(0.0, randomEngine);
    }

    public double cdf(int n) {
        return Probability.negativeBinomial(n, this.n, this.p);
    }

    public Object clone() {
        NegativeBinomial negativeBinomial = (NegativeBinomial)super.clone();
        if (this.poisson != null) {
            negativeBinomial.poisson = (Poisson)this.poisson.clone();
        }
        negativeBinomial.poisson.setRandomGenerator(negativeBinomial.getRandomGenerator());
        if (this.gamma != null) {
            negativeBinomial.gamma = (Gamma)this.gamma.clone();
        }
        negativeBinomial.gamma.setRandomGenerator(negativeBinomial.getRandomGenerator());
        return negativeBinomial;
    }

    public int nextInt() {
        return this.nextInt(this.n, this.p);
    }

    public int nextInt(int n, double d2) {
        double d3 = d2 / (1.0 - d2);
        double d4 = d2;
        double d5 = d3 * this.gamma.nextDouble(n, 1.0);
        return this.poisson.nextInt(d5);
    }

    public double pdf(int n) {
        if (n > this.n) {
            throw new IllegalArgumentException();
        }
        return Arithmetic.binomial(this.n, (long)n) * Math.pow(this.p, n) * Math.pow(1.0 - this.p, this.n - n);
    }

    public void setNandP(int n, double d2) {
        this.n = n;
        this.p = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(int n, double d2) {
        NegativeBinomial negativeBinomial = shared;
        synchronized (negativeBinomial) {
            return shared.nextInt(n, d2);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.n + "," + this.p + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        NegativeBinomial negativeBinomial = shared;
        synchronized (negativeBinomial) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

