/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class Normal
extends AbstractContinousDistribution {
    protected double mean;
    protected double variance;
    protected double standardDeviation;
    protected double cache;
    protected boolean cacheFilled;
    protected double SQRT_INV;
    protected static Normal shared = new Normal(0.0, 1.0, Normal.makeDefaultGenerator());

    public Normal(double d2, double d3, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d2, d3);
    }

    public double cdf(double d2) {
        return Probability.normal(this.mean, this.variance, d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.mean, this.standardDeviation);
    }

    public double nextDouble(double d2, double d3) {
        double d4;
        double d5;
        double d6;
        if (this.cacheFilled && this.mean == d2 && this.standardDeviation == d3) {
            this.cacheFilled = false;
            return this.cache;
        }
        while ((d6 = (d5 = 2.0 * this.randomGenerator.raw() - 1.0) * d5 + (d4 = 2.0 * this.randomGenerator.raw() - 1.0) * d4) >= 1.0) {
        }
        double d7 = Math.sqrt(-2.0 * Math.log(d6) / d6);
        this.cache = d2 + d3 * d5 * d7;
        this.cacheFilled = true;
        return d2 + d3 * d4 * d7;
    }

    public double pdf(double d2) {
        double d3 = d2 - this.mean;
        return this.SQRT_INV * Math.exp(-(d3 * d3) / (2.0 * this.variance));
    }

    protected void setRandomGenerator(RandomEngine randomEngine) {
        super.setRandomGenerator(randomEngine);
        this.cacheFilled = false;
    }

    public void setState(double d2, double d3) {
        if (d2 != this.mean || d3 != this.standardDeviation) {
            this.mean = d2;
            this.standardDeviation = d3;
            this.variance = d3 * d3;
            this.cacheFilled = false;
            this.SQRT_INV = 1.0 / Math.sqrt(Math.PI * 2 * this.variance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d2, double d3) {
        Normal normal = shared;
        synchronized (normal) {
            return shared.nextDouble(d2, d3);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + "," + this.standardDeviation + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        Normal normal = shared;
        synchronized (normal) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

