/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.engine.RandomEngine;

public class PoissonSlow
extends AbstractDiscreteDistribution {
    protected double mean;
    protected double cached_sq;
    protected double cached_alxm;
    protected double cached_g;
    protected static final double MEAN_MAX = 2.147483647E9;
    protected static final double SWITCH_MEAN = 12.0;
    protected static final double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    protected static PoissonSlow shared = new PoissonSlow(0.0, PoissonSlow.makeDefaultGenerator());

    public PoissonSlow(double d2, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setMean(d2);
    }

    public static double logGamma(double d2) {
        double d3 = d2 - 1.0;
        double d4 = d3 + 5.5;
        d4 -= (d3 + 0.5) * Math.log(d4);
        double d5 = 1.000000000190015;
        double[] dArray = cof;
        for (int i = 0; i <= 5; ++i) {
            d5 += dArray[i] / (d3 += 1.0);
        }
        return -d4 + Math.log(2.5066282746310007 * d5);
    }

    public int nextInt() {
        return this.nextInt(this.mean);
    }

    private int nextInt(double d2) {
        double d3 = d2;
        double d4 = this.cached_g;
        if (d3 == -1.0) {
            return 0;
        }
        if (d3 < 12.0) {
            int n = -1;
            double d5 = 1.0;
            do {
                ++n;
            } while ((d5 *= this.randomGenerator.raw()) >= d4);
            return n;
        }
        if (d3 < 2.147483647E9) {
            double d6;
            double d7 = this.cached_sq;
            double d8 = this.cached_alxm;
            RandomEngine randomEngine = this.randomGenerator;
            while (true) {
                double d9;
                if ((d6 = d7 * (d9 = Math.tan(Math.PI * randomEngine.raw())) + d3) < 0.0) {
                    continue;
                }
                d6 = (int)d6;
                double d10 = 0.9 * (1.0 + d9 * d9) * Math.exp(d6 * d8 - PoissonSlow.logGamma(d6 + 1.0) - d4);
                if (!(randomEngine.raw() > d10)) break;
            }
            return (int)d6;
        }
        return (int)d3;
    }

    protected int nextIntSlow() {
        double d2 = Math.exp(-this.mean);
        int n = 0;
        double d3 = 1.0;
        while (d3 >= d2 && d3 > 0.0) {
            d3 *= this.randomGenerator.raw();
            ++n;
        }
        if (d3 <= 0.0 && d2 > 0.0) {
            return (int)Math.round(this.mean);
        }
        return n - 1;
    }

    public void setMean(double d2) {
        if (d2 != this.mean) {
            this.mean = d2;
            if (d2 == -1.0) {
                return;
            }
            if (d2 < 12.0) {
                this.cached_g = Math.exp(-d2);
            } else {
                this.cached_sq = Math.sqrt(2.0 * d2);
                this.cached_alxm = Math.log(d2);
                this.cached_g = d2 * this.cached_alxm - PoissonSlow.logGamma(d2 + 1.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(double d2) {
        PoissonSlow poissonSlow = shared;
        synchronized (poissonSlow) {
            shared.setMean(d2);
            return shared.nextInt();
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        PoissonSlow poissonSlow = shared;
        synchronized (poissonSlow) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

