/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.Fun;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class StudentT
extends AbstractContinousDistribution {
    protected double freedom;
    protected double TERM;
    protected static StudentT shared = new StudentT(1.0, StudentT.makeDefaultGenerator());

    public StudentT(double d2, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d2);
    }

    public double cdf(double d2) {
        return Probability.studentT(this.freedom, d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.freedom);
    }

    public double nextDouble(double d2) {
        double d3;
        double d4;
        double d5;
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        while ((d5 = (d4 = 2.0 * this.randomGenerator.raw() - 1.0) * d4 + (d3 = 2.0 * this.randomGenerator.raw() - 1.0) * d3) > 1.0) {
        }
        return d4 * Math.sqrt(d2 * (Math.exp(-2.0 / d2 * Math.log(d5)) - 1.0) / d5);
    }

    public double pdf(double d2) {
        return this.TERM * Math.pow(1.0 + d2 * d2 / this.freedom, -(this.freedom + 1.0) * 0.5);
    }

    public void setState(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.freedom = d2;
        double d3 = Fun.logGamma((d2 + 1.0) / 2.0) - Fun.logGamma(d2 / 2.0);
        this.TERM = Math.exp(d3) / Math.sqrt(Math.PI * d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d2) {
        StudentT studentT = shared;
        synchronized (studentT) {
            return shared.nextDouble(d2);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.freedom + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        StudentT studentT = shared;
        synchronized (studentT) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

