/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.jet.math.Arithmetic;
import cern.jet.stat.Gamma;

public class Descriptive {
    protected Descriptive() {
    }

    public static double autoCorrelation(DoubleArrayList doubleArrayList, int n, double d2, double d3) {
        int n2 = doubleArrayList.size();
        if (n >= n2) {
            throw new IllegalArgumentException("Lag is too large");
        }
        double[] dArray = doubleArrayList.elements();
        double d4 = 0.0;
        for (int i = n; i < n2; ++i) {
            d4 += (dArray[i] - d2) * (dArray[i - n] - d2);
        }
        return d4 / (double)(n2 - n) / d3;
    }

    protected static void checkRangeFromTo(int n, int n2, int n3) {
        if (n2 == n - 1) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= n3) {
            throw new IndexOutOfBoundsException("from: " + n + ", to: " + n2 + ", size=" + n3);
        }
    }

    public static double correlation(DoubleArrayList doubleArrayList, double d2, DoubleArrayList doubleArrayList2, double d3) {
        return Descriptive.covariance(doubleArrayList, doubleArrayList2) / (d2 * d3);
    }

    public static double covariance(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList.size();
        if (n != doubleArrayList2.size() || n == 0) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        double[] dArray2 = doubleArrayList2.elements();
        double d2 = dArray[0];
        double d3 = dArray2[0];
        double d4 = 0.0;
        for (int i = 1; i < n; ++i) {
            double d5 = dArray[i];
            double d6 = dArray2[i];
            d4 += (d5 - (d2 += d5) / (double)(i + 1)) * (d6 - d3 / (double)i);
            d3 += d6;
        }
        return d4 / (double)(n - 1);
    }

    private static double covariance2(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList.size();
        double d2 = Descriptive.mean(doubleArrayList);
        double d3 = Descriptive.mean(doubleArrayList2);
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = doubleArrayList.get(i);
            double d6 = doubleArrayList2.get(i);
            d4 += (d5 - d2) * (d6 - d3);
        }
        return d4 / (double)(n - 1);
    }

    public static double durbinWatson(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        if (n < 2) {
            throw new IllegalArgumentException("data sequence must contain at least two values.");
        }
        double[] dArray = doubleArrayList.elements();
        double d2 = 0.0;
        double d3 = 0.0;
        d3 = dArray[0] * dArray[0];
        for (int i = 1; i < n; ++i) {
            double d4 = dArray[i] - dArray[i - 1];
            d2 += d4 * d4;
            d3 += dArray[i] * dArray[i];
        }
        return d2 / d3;
    }

    public static void frequencies(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2, IntArrayList intArrayList) {
        doubleArrayList2.clear();
        if (intArrayList != null) {
            intArrayList.clear();
        }
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        int n2 = 0;
        while (n2 < n) {
            double d2 = dArray[n2];
            int n3 = n2;
            while (++n2 < n && dArray[n2] == d2) {
            }
            int n4 = n2 - n3;
            doubleArrayList2.add(d2);
            if (intArrayList == null) continue;
            intArrayList.add(n4);
        }
    }

    public static double geometricMean(int n, double d2) {
        return Math.exp(d2 / (double)n);
    }

    public static double geometricMean(DoubleArrayList doubleArrayList) {
        return Descriptive.geometricMean(doubleArrayList.size(), Descriptive.sumOfLogarithms(doubleArrayList, 0, doubleArrayList.size() - 1));
    }

    public static double harmonicMean(int n, double d2) {
        return (double)n / d2;
    }

    public static void incrementalUpdate(DoubleArrayList doubleArrayList, int n, int n2, double[] dArray) {
        Descriptive.checkRangeFromTo(n, n2, doubleArrayList.size());
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double[] dArray2 = doubleArrayList.elements();
        while (n <= n2) {
            double d6 = dArray2[n];
            d4 += d6;
            d5 += d6 * d6;
            if (d6 < d2) {
                d2 = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            ++n;
        }
        dArray[0] = d2;
        dArray[1] = d3;
        dArray[2] = d4;
        dArray[3] = d5;
    }

    public static void incrementalUpdateSumsOfPowers(DoubleArrayList doubleArrayList, int n, int n2, int n3, int n4, double[] dArray) {
        int n5 = doubleArrayList.size();
        int n6 = n4 - n3;
        if (n > n5 || n6 + 1 > dArray.length) {
            throw new IllegalArgumentException();
        }
        if (n3 == 1) {
            if (n4 == 2) {
                double[] dArray2 = doubleArrayList.elements();
                double d2 = dArray[0];
                double d3 = dArray[1];
                int n7 = n - 1;
                while (++n7 <= n2) {
                    double d4 = dArray2[n7];
                    d2 += d4;
                    d3 += d4 * d4;
                }
                dArray[0] = dArray[0] + d2;
                dArray[1] = dArray[1] + d3;
                return;
            }
            if (n4 == 3) {
                double[] dArray3 = doubleArrayList.elements();
                double d5 = dArray[0];
                double d6 = dArray[1];
                double d7 = dArray[2];
                int n8 = n - 1;
                while (++n8 <= n2) {
                    double d8 = dArray3[n8];
                    d5 += d8;
                    d6 += d8 * d8;
                    d7 += d8 * d8 * d8;
                }
                dArray[0] = dArray[0] + d5;
                dArray[1] = dArray[1] + d6;
                dArray[2] = dArray[2] + d7;
                return;
            }
            if (n4 == 4) {
                double[] dArray4 = doubleArrayList.elements();
                double d9 = dArray[0];
                double d10 = dArray[1];
                double d11 = dArray[2];
                double d12 = dArray[3];
                int n9 = n - 1;
                while (++n9 <= n2) {
                    double d13 = dArray4[n9];
                    d9 += d13;
                    d10 += d13 * d13;
                    d11 += d13 * d13 * d13;
                    d12 += d13 * d13 * d13 * d13;
                }
                dArray[0] = dArray[0] + d9;
                dArray[1] = dArray[1] + d10;
                dArray[2] = dArray[2] + d11;
                dArray[3] = dArray[3] + d12;
                return;
            }
        }
        if (n3 == n4 || n3 >= -1 && n4 <= 5) {
            for (int i = n3; i <= n4; ++i) {
                int n10 = i - n3;
                dArray[n10] = dArray[n10] + Descriptive.sumOfPowerDeviations(doubleArrayList, i, 0.0, n, n2);
            }
            return;
        }
        double[] dArray5 = doubleArrayList.elements();
        int n11 = n - 1;
        while (++n11 <= n2) {
            double d14 = dArray5[n11];
            double d15 = Math.pow(d14, n3);
            int n12 = 0;
            int n13 = n6;
            while (--n13 >= 0) {
                int n14 = n12++;
                dArray[n14] = dArray[n14] + d15;
                d15 *= d14;
            }
            int n15 = n12;
            dArray[n15] = dArray[n15] + d15;
        }
    }

    public static void incrementalWeightedUpdate(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2, int n, int n2, double[] dArray) {
        int n3 = doubleArrayList.size();
        Descriptive.checkRangeFromTo(n, n2, n3);
        if (n3 != doubleArrayList2.size()) {
            throw new IllegalArgumentException("from=" + n + ", to=" + n2 + ", data.size()=" + n3 + ", weights.size()=" + doubleArrayList2.size());
        }
        double d2 = dArray[0];
        double d3 = dArray[1];
        double[] dArray2 = doubleArrayList.elements();
        double[] dArray3 = doubleArrayList2.elements();
        int n4 = n - 1;
        while (++n4 <= n2) {
            double d4 = dArray2[n4];
            double d5 = dArray3[n4];
            double d6 = d4 * d5;
            d2 += d6;
            d3 += d4 * d6;
        }
        dArray[0] = d2;
        dArray[1] = d3;
    }

    public static double kurtosis(double d2, double d3) {
        return -3.0 + d2 / (d3 * d3 * d3 * d3);
    }

    public static double kurtosis(DoubleArrayList doubleArrayList, double d2, double d3) {
        return Descriptive.kurtosis(Descriptive.moment(doubleArrayList, 4, d2), d3);
    }

    public static double lag1(DoubleArrayList doubleArrayList, double d2) {
        int n = doubleArrayList.size();
        double[] dArray = doubleArrayList.elements();
        double d3 = 0.0;
        double d4 = (dArray[0] - d2) * (dArray[0] - d2);
        for (int i = 1; i < n; ++i) {
            double d5 = dArray[i - 1] - d2;
            double d6 = dArray[i] - d2;
            d3 += (d5 * d6 - d3) / (double)(i + 1);
            d4 += (d6 * d6 - d4) / (double)(i + 1);
        }
        double d7 = d3 / d4;
        return d7;
    }

    public static double max(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        double d2 = dArray[n - 1];
        int n2 = n - 1;
        while (--n2 >= 0) {
            if (!(dArray[n2] > d2)) continue;
            d2 = dArray[n2];
        }
        return d2;
    }

    public static double mean(DoubleArrayList doubleArrayList) {
        return Descriptive.sum(doubleArrayList) / (double)doubleArrayList.size();
    }

    public static double meanDeviation(DoubleArrayList doubleArrayList, double d2) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double d3 = 0.0;
        int n2 = n;
        while (--n2 >= 0) {
            d3 += Math.abs(dArray[n2] - d2);
        }
        return d3 / (double)n;
    }

    public static double median(DoubleArrayList doubleArrayList) {
        return Descriptive.quantile(doubleArrayList, 0.5);
    }

    public static double min(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        double d2 = dArray[n - 1];
        int n2 = n - 1;
        while (--n2 >= 0) {
            if (!(dArray[n2] < d2)) continue;
            d2 = dArray[n2];
        }
        return d2;
    }

    public static double moment(int n, double d2, int n2, double[] dArray) {
        double d3 = 0.0;
        int n3 = 1;
        for (int i = 0; i <= n; ++i) {
            double d4 = i == 0 ? 1.0 : (i == 1 ? d2 : (i == 2 ? d2 * d2 : (i == 3 ? d2 * d2 * d2 : Math.pow(d2, i))));
            d3 += (double)n3 * Arithmetic.binomial(n, (long)i) * d4 * dArray[n - i];
            n3 = -n3;
        }
        return d3 / (double)n2;
    }

    public static double moment(DoubleArrayList doubleArrayList, int n, double d2) {
        return Descriptive.sumOfPowerDeviations(doubleArrayList, n, d2) / (double)doubleArrayList.size();
    }

    public static double pooledMean(int n, double d2, int n2, double d3) {
        return ((double)n * d2 + (double)n2 * d3) / (double)(n + n2);
    }

    public static double pooledVariance(int n, double d2, int n2, double d3) {
        return ((double)n * d2 + (double)n2 * d3) / (double)(n + n2);
    }

    public static double product(int n, double d2) {
        return Math.pow(Math.exp(d2 / (double)n), n);
    }

    public static double product(DoubleArrayList doubleArrayList) {
        int n = doubleArrayList.size();
        double[] dArray = doubleArrayList.elements();
        double d2 = 1.0;
        int n2 = n;
        while (--n2 >= 0) {
            d2 *= dArray[n2];
        }
        return d2;
    }

    public static double quantile(DoubleArrayList doubleArrayList, double d2) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double d3 = d2 * (double)(n - 1);
        int n2 = (int)d3;
        double d4 = d3 - (double)n2;
        if (n == 0) {
            return 0.0;
        }
        double d5 = n2 == n - 1 ? dArray[n2] : (1.0 - d4) * dArray[n2] + d4 * dArray[n2 + 1];
        return d5;
    }

    public static double quantileInverse(DoubleArrayList doubleArrayList, double d2) {
        return Descriptive.rankInterpolated(doubleArrayList, d2) / (double)doubleArrayList.size();
    }

    public static DoubleArrayList quantiles(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList2.size();
        DoubleArrayList doubleArrayList3 = new DoubleArrayList(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayList3.add(Descriptive.quantile(doubleArrayList, doubleArrayList2.get(i)));
        }
        return doubleArrayList3;
    }

    public static double rankInterpolated(DoubleArrayList doubleArrayList, double d2) {
        int n = doubleArrayList.binarySearch(d2);
        if (n >= 0) {
            int n2;
            int n3 = doubleArrayList.size();
            for (n2 = n + 1; n2 < n3 && doubleArrayList.get(n2) == d2; ++n2) {
            }
            return n2;
        }
        int n4 = -n - 1;
        if (n4 == 0 || n4 == doubleArrayList.size()) {
            return n4;
        }
        double d3 = doubleArrayList.get(n4 - 1);
        double d4 = doubleArrayList.get(n4);
        double d5 = (d2 - d3) / (d4 - d3);
        return (double)n4 + d5;
    }

    public static double rms(int n, double d2) {
        return Math.sqrt(d2 / (double)n);
    }

    public static double sampleKurtosis(int n, double d2, double d3) {
        int n2 = n;
        double d4 = d3;
        double d5 = d2 * (double)n2;
        return d5 * (double)n2 * (double)(n2 + 1) / ((double)((n2 - 1) * (n2 - 2) * (n2 - 3)) * d4 * d4) - 3.0 * (double)(n2 - 1) * (double)(n2 - 1) / (double)((n2 - 2) * (n2 - 3));
    }

    public static double sampleKurtosis(DoubleArrayList doubleArrayList, double d2, double d3) {
        return Descriptive.sampleKurtosis(doubleArrayList.size(), Descriptive.moment(doubleArrayList, 4, d2), d3);
    }

    public static double sampleKurtosisStandardError(int n) {
        int n2 = n;
        return Math.sqrt(24.0 * (double)n2 * (double)(n2 - 1) * (double)(n2 - 1) / (double)((n2 - 3) * (n2 - 2) * (n2 + 3) * (n2 + 5)));
    }

    public static double sampleSkew(int n, double d2, double d3) {
        int n2 = n;
        double d4 = Math.sqrt(d3);
        double d5 = d2 * (double)n2;
        return (double)n2 * d5 / ((double)((n2 - 1) * (n2 - 2)) * d4 * d4 * d4);
    }

    public static double sampleSkew(DoubleArrayList doubleArrayList, double d2, double d3) {
        return Descriptive.sampleSkew(doubleArrayList.size(), Descriptive.moment(doubleArrayList, 3, d2), d3);
    }

    public static double sampleSkewStandardError(int n) {
        int n2 = n;
        return Math.sqrt(6.0 * (double)n2 * (double)(n2 - 1) / (double)((n2 - 2) * (n2 + 1) * (n2 + 3)));
    }

    public static double sampleStandardDeviation(int n, double d2) {
        int n2 = n;
        double d3 = Math.sqrt(d2);
        double d4 = n2 > 30 ? 1.0 + 1.0 / (double)(4 * (n2 - 1)) : Math.sqrt((double)(n2 - 1) * 0.5) * Gamma.gamma((double)(n2 - 1) * 0.5) / Gamma.gamma((double)n2 * 0.5);
        return d4 * d3;
    }

    public static double sampleVariance(int n, double d2, double d3) {
        double d4 = d2 / (double)n;
        return (d3 - d4 * d2) / (double)(n - 1);
    }

    public static double sampleVariance(DoubleArrayList doubleArrayList, double d2) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double d3 = 0.0;
        int n2 = n;
        while (--n2 >= 0) {
            double d4 = dArray[n2] - d2;
            d3 += d4 * d4;
        }
        return d3 / (double)(n - 1);
    }

    public static double sampleWeightedVariance(double d2, double d3, double d4) {
        return (d4 - d3 * d3 / d2) / (d2 - 1.0);
    }

    public static double skew(double d2, double d3) {
        return d2 / (d3 * d3 * d3);
    }

    public static double skew(DoubleArrayList doubleArrayList, double d2, double d3) {
        return Descriptive.skew(Descriptive.moment(doubleArrayList, 3, d2), d3);
    }

    public static DoubleArrayList[] split(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList2.size() + 1;
        DoubleArrayList[] doubleArrayListArray = new DoubleArrayList[n];
        int n2 = n;
        while (--n2 >= 0) {
            doubleArrayListArray[n2] = new DoubleArrayList();
        }
        n2 = doubleArrayList.size();
        int n3 = 0;
        for (int i = 0; n3 < n2 && i < n - 1; ++i) {
            double d2 = doubleArrayList2.get(i);
            int n4 = doubleArrayList.binarySearch(d2);
            if (n4 < 0) {
                int n5 = -n4 - 1;
                doubleArrayListArray[i].addAllOfFromTo(doubleArrayList, n3, n5 - 1);
                n3 = n5;
                continue;
            }
            while (--n4 >= 0 && doubleArrayList.get(n4) == d2) {
            }
            doubleArrayListArray[i].addAllOfFromTo(doubleArrayList, n3, n4);
            n3 = n4 + 1;
        }
        doubleArrayListArray[n - 1].addAllOfFromTo(doubleArrayList, n3, doubleArrayList.size() - 1);
        return doubleArrayListArray;
    }

    public static double standardDeviation(double d2) {
        return Math.sqrt(d2);
    }

    public static double standardError(int n, double d2) {
        return Math.sqrt(d2 / (double)n);
    }

    public static void standardize(DoubleArrayList doubleArrayList, double d2, double d3) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        while (--n >= 0) {
            dArray[n] = (dArray[n] - d2) / d3;
        }
    }

    public static double sum(DoubleArrayList doubleArrayList) {
        return Descriptive.sumOfPowerDeviations(doubleArrayList, 1, 0.0);
    }

    public static double sumOfInversions(DoubleArrayList doubleArrayList, int n, int n2) {
        return Descriptive.sumOfPowerDeviations(doubleArrayList, -1, 0.0, n, n2);
    }

    public static double sumOfLogarithms(DoubleArrayList doubleArrayList, int n, int n2) {
        double[] dArray = doubleArrayList.elements();
        double d2 = 0.0;
        int n3 = n - 1;
        while (++n3 <= n2) {
            d2 += Math.log(dArray[n3]);
        }
        return d2;
    }

    public static double sumOfPowerDeviations(DoubleArrayList doubleArrayList, int n, double d2) {
        return Descriptive.sumOfPowerDeviations(doubleArrayList, n, d2, 0, doubleArrayList.size() - 1);
    }

    public static double sumOfPowerDeviations(DoubleArrayList doubleArrayList, int n, double d2, int n2, int n3) {
        double[] dArray = doubleArrayList.elements();
        double d3 = 0.0;
        switch (n) {
            case -2: {
                if (d2 == 0.0) {
                    int n4 = n2 - 1;
                    while (++n4 <= n3) {
                        double d4 = dArray[n4];
                        d3 += 1.0 / (d4 * d4);
                    }
                } else {
                    int n5 = n2 - 1;
                    while (++n5 <= n3) {
                        double d5 = dArray[n5] - d2;
                        d3 += 1.0 / (d5 * d5);
                    }
                }
                break;
            }
            case -1: {
                if (d2 == 0.0) {
                    int n6 = n2 - 1;
                    while (++n6 <= n3) {
                        d3 += 1.0 / dArray[n6];
                    }
                } else {
                    int n7 = n2 - 1;
                    while (++n7 <= n3) {
                        d3 += 1.0 / (dArray[n7] - d2);
                    }
                }
                break;
            }
            case 0: {
                d3 += (double)(n3 - n2 + 1);
                break;
            }
            case 1: {
                if (d2 == 0.0) {
                    int n8 = n2 - 1;
                    while (++n8 <= n3) {
                        d3 += dArray[n8];
                    }
                } else {
                    int n9 = n2 - 1;
                    while (++n9 <= n3) {
                        d3 += dArray[n9] - d2;
                    }
                }
                break;
            }
            case 2: {
                if (d2 == 0.0) {
                    int n10 = n2 - 1;
                    while (++n10 <= n3) {
                        double d6 = dArray[n10];
                        d3 += d6 * d6;
                    }
                } else {
                    int n11 = n2 - 1;
                    while (++n11 <= n3) {
                        double d7 = dArray[n11] - d2;
                        d3 += d7 * d7;
                    }
                }
                break;
            }
            case 3: {
                if (d2 == 0.0) {
                    int n12 = n2 - 1;
                    while (++n12 <= n3) {
                        double d8 = dArray[n12];
                        d3 += d8 * d8 * d8;
                    }
                } else {
                    int n13 = n2 - 1;
                    while (++n13 <= n3) {
                        double d9 = dArray[n13] - d2;
                        d3 += d9 * d9 * d9;
                    }
                }
                break;
            }
            case 4: {
                if (d2 == 0.0) {
                    int n14 = n2 - 1;
                    while (++n14 <= n3) {
                        double d10 = dArray[n14];
                        d3 += d10 * d10 * d10 * d10;
                    }
                } else {
                    int n15 = n2 - 1;
                    while (++n15 <= n3) {
                        double d11 = dArray[n15] - d2;
                        d3 += d11 * d11 * d11 * d11;
                    }
                }
                break;
            }
            case 5: {
                if (d2 == 0.0) {
                    int n16 = n2 - 1;
                    while (++n16 <= n3) {
                        double d12 = dArray[n16];
                        d3 += d12 * d12 * d12 * d12 * d12;
                    }
                } else {
                    int n17 = n2 - 1;
                    while (++n17 <= n3) {
                        double d13 = dArray[n17] - d2;
                        d3 += d13 * d13 * d13 * d13 * d13;
                    }
                }
                break;
            }
            default: {
                int n18 = n2 - 1;
                while (++n18 <= n3) {
                    d3 += Math.pow(dArray[n18] - d2, n);
                }
                break block0;
            }
        }
        return d3;
    }

    public static double sumOfPowers(DoubleArrayList doubleArrayList, int n) {
        return Descriptive.sumOfPowerDeviations(doubleArrayList, n, 0.0);
    }

    public static double sumOfSquaredDeviations(int n, double d2) {
        return d2 * (double)(n - 1);
    }

    public static double sumOfSquares(DoubleArrayList doubleArrayList) {
        return Descriptive.sumOfPowerDeviations(doubleArrayList, 2, 0.0);
    }

    public static double trimmedMean(DoubleArrayList doubleArrayList, double d2, int n, int n2) {
        int n3;
        int n4 = doubleArrayList.size();
        if (n4 == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (n + n2 >= n4) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double[] dArray = doubleArrayList.elements();
        int n5 = n4;
        for (n3 = 0; n3 < n; ++n3) {
            d2 += (d2 - dArray[n3]) / (double)(--n4);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            d2 += (d2 - dArray[n5 - 1 - n3]) / (double)(--n4);
        }
        return d2;
    }

    public static double variance(double d2) {
        return d2 * d2;
    }

    public static double variance(int n, double d2, double d3) {
        double d4 = d2 / (double)n;
        return (d3 - d4 * d2) / (double)n;
    }

    public static double weightedMean(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n = doubleArrayList.size();
        if (n != doubleArrayList2.size() || n == 0) {
            throw new IllegalArgumentException();
        }
        double[] dArray = doubleArrayList.elements();
        double[] dArray2 = doubleArrayList2.elements();
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = n;
        while (--n2 >= 0) {
            double d4 = dArray2[n2];
            d2 += dArray[n2] * d4;
            d3 += d4;
        }
        return d2 / d3;
    }

    public static double weightedRMS(double d2, double d3) {
        return d2 / d3;
    }

    public static double winsorizedMean(DoubleArrayList doubleArrayList, double d2, int n, int n2) {
        int n3 = doubleArrayList.size();
        if (n3 == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (n + n2 >= n3) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double[] dArray = doubleArrayList.elements();
        double d3 = dArray[n];
        for (int i = 0; i < n; ++i) {
            d2 += (d3 - dArray[i]) / (double)n3;
        }
        double d4 = dArray[n3 - 1 - n2];
        for (int i = 0; i < n2; ++i) {
            d2 += (d4 - dArray[n3 - 1 - i]) / (double)n3;
        }
        return d2;
    }
}

