/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.PersistentObject;
import java.util.Arrays;

public class EquiDepthHistogram
extends PersistentObject {
    protected float[] binBoundaries;

    public EquiDepthHistogram(float[] fArray) {
        this.binBoundaries = fArray;
    }

    public int binOfElement(float f2) {
        int n = Arrays.binarySearch(this.binBoundaries, f2);
        if (n >= 0) {
            if (n == this.binBoundaries.length - 1) {
                --n;
            }
        } else {
            if (++n == 0 || n == this.binBoundaries.length) {
                throw new IllegalArgumentException("Element=" + f2 + " not contained in any bin.");
            }
            --n;
        }
        return n;
    }

    public int bins() {
        return this.binBoundaries.length - 1;
    }

    public float endOfBin(int n) {
        return this.binBoundaries[n + 1];
    }

    public double percentFromTo(float f2, float f3) {
        return this.phi(f3) - this.phi(f2);
    }

    public double phi(float f2) {
        int n = this.binBoundaries.length;
        if (f2 <= this.binBoundaries[0]) {
            return 0.0;
        }
        if (f2 >= this.binBoundaries[n - 1]) {
            return 1.0;
        }
        double d2 = 1.0 / (double)(n - 1);
        int n2 = Arrays.binarySearch(this.binBoundaries, f2);
        if (n2 >= 0) {
            return d2 * (double)n2;
        }
        int n3 = -n2 - 1;
        double d3 = this.binBoundaries[n3 - 1];
        double d4 = (double)this.binBoundaries[n3] - d3;
        double d5 = ((double)f2 - d3) / d4;
        return d2 * (d5 + (double)(n3 - 1));
    }

    public int size() {
        return this.binBoundaries.length;
    }

    public float startOfBin(int n) {
        return this.binBoundaries[n];
    }

    public static void test(float f2) {
        float[] fArray = new float[]{50.0f, 100.0f, 200.0f, 300.0f, 1400.0f, 1500.0f, 1600.0f, 1700.0f, 1800.0f, 1900.0f, 2000.0f};
        EquiDepthHistogram equiDepthHistogram = new EquiDepthHistogram(fArray);
        System.out.println("elem=" + f2 + ", phi=" + equiDepthHistogram.phi(f2));
    }
}

