/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.bin;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import hep.aida.bin.AbstractBin1D;
import hep.aida.bin.StaticBin1D;

public class MightyStaticBin1D
extends StaticBin1D {
    protected boolean hasSumOfLogarithms = false;
    protected double sumOfLogarithms = 0.0;
    protected boolean hasSumOfInversions = false;
    protected double sumOfInversions = 0.0;
    protected double[] sumOfPowers = null;

    public MightyStaticBin1D() {
        this(false, false, 4);
    }

    public MightyStaticBin1D(boolean bl, boolean bl2, int n) {
        this.setMaxOrderForSumOfPowers(n);
        this.hasSumOfLogarithms = bl;
        this.hasSumOfInversions = bl2;
        this.clear();
    }

    public synchronized void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        super.addAllOfFromTo(doubleArrayList, n, n2);
        if (this.sumOfPowers != null) {
            Descriptive.incrementalUpdateSumsOfPowers(doubleArrayList, n, n2, 3, this.getMaxOrderForSumOfPowers(), this.sumOfPowers);
        }
        if (this.hasSumOfInversions) {
            this.sumOfInversions += Descriptive.sumOfInversions(doubleArrayList, n, n2);
        }
        if (this.hasSumOfLogarithms) {
            this.sumOfLogarithms += Descriptive.sumOfLogarithms(doubleArrayList, n, n2);
        }
    }

    protected void clearAllMeasures() {
        super.clearAllMeasures();
        this.sumOfLogarithms = 0.0;
        this.sumOfInversions = 0.0;
        if (this.sumOfPowers != null) {
            int n = this.sumOfPowers.length;
            while (--n >= 0) {
                this.sumOfPowers[n] = 0.0;
            }
        }
    }

    public synchronized Object clone() {
        MightyStaticBin1D mightyStaticBin1D = (MightyStaticBin1D)super.clone();
        if (this.sumOfPowers != null) {
            mightyStaticBin1D.sumOfPowers = (double[])mightyStaticBin1D.sumOfPowers.clone();
        }
        return mightyStaticBin1D;
    }

    public String compareWith(AbstractBin1D abstractBin1D) {
        StringBuffer stringBuffer = new StringBuffer(super.compareWith(abstractBin1D));
        if (abstractBin1D instanceof MightyStaticBin1D) {
            MightyStaticBin1D mightyStaticBin1D = (MightyStaticBin1D)abstractBin1D;
            if (this.hasSumOfLogarithms() && mightyStaticBin1D.hasSumOfLogarithms()) {
                stringBuffer.append("geometric mean: " + this.relError(this.geometricMean(), mightyStaticBin1D.geometricMean()) + " %\n");
            }
            if (this.hasSumOfInversions() && mightyStaticBin1D.hasSumOfInversions()) {
                stringBuffer.append("harmonic mean: " + this.relError(this.harmonicMean(), mightyStaticBin1D.harmonicMean()) + " %\n");
            }
            if (this.hasSumOfPowers(3) && mightyStaticBin1D.hasSumOfPowers(3)) {
                stringBuffer.append("skew: " + this.relError(this.skew(), mightyStaticBin1D.skew()) + " %\n");
            }
            if (this.hasSumOfPowers(4) && mightyStaticBin1D.hasSumOfPowers(4)) {
                stringBuffer.append("kurtosis: " + this.relError(this.kurtosis(), mightyStaticBin1D.kurtosis()) + " %\n");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public synchronized double geometricMean() {
        return Descriptive.geometricMean(this.size(), this.sumOfLogarithms());
    }

    public synchronized int getMaxOrderForSumOfPowers() {
        if (this.sumOfPowers == null) {
            return 2;
        }
        return 2 + this.sumOfPowers.length;
    }

    public synchronized int getMinOrderForSumOfPowers() {
        int n = 0;
        if (this.hasSumOfInversions()) {
            n = -1;
        }
        return n;
    }

    public synchronized double harmonicMean() {
        return Descriptive.harmonicMean(this.size(), this.sumOfInversions());
    }

    public boolean hasSumOfInversions() {
        return this.hasSumOfInversions;
    }

    public boolean hasSumOfLogarithms() {
        return this.hasSumOfLogarithms;
    }

    public boolean hasSumOfPowers(int n) {
        return this.getMinOrderForSumOfPowers() <= n && n <= this.getMaxOrderForSumOfPowers();
    }

    public synchronized double kurtosis() {
        return Descriptive.kurtosis(this.moment(4, this.mean()), this.standardDeviation());
    }

    public synchronized double moment(int n, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("k must be >= 0");
        }
        if (!this.hasSumOfPowers(n)) {
            return Double.NaN;
        }
        int n2 = Math.min(n, this.getMaxOrderForSumOfPowers());
        DoubleArrayList doubleArrayList = new DoubleArrayList(n2 + 1);
        doubleArrayList.add(this.size());
        doubleArrayList.add(this.sum());
        doubleArrayList.add(this.sumOfSquares());
        for (int i = 3; i <= n2; ++i) {
            doubleArrayList.add(this.sumOfPowers(i));
        }
        return Descriptive.moment(n, d2, this.size(), doubleArrayList.elements());
    }

    public double product() {
        return Descriptive.product(this.size(), this.sumOfLogarithms());
    }

    protected void setMaxOrderForSumOfPowers(int n) {
        this.sumOfPowers = (double[])(n <= 2 ? null : new double[n - 2]);
    }

    public synchronized double skew() {
        return Descriptive.skew(this.moment(3, this.mean()), this.standardDeviation());
    }

    public double sumOfInversions() {
        if (!this.hasSumOfInversions) {
            return Double.NaN;
        }
        return this.sumOfInversions;
    }

    public synchronized double sumOfLogarithms() {
        if (!this.hasSumOfLogarithms) {
            return Double.NaN;
        }
        return this.sumOfLogarithms;
    }

    public synchronized double sumOfPowers(int n) {
        if (!this.hasSumOfPowers(n)) {
            return Double.NaN;
        }
        if (n == -1) {
            return this.sumOfInversions();
        }
        if (n == 0) {
            return this.size();
        }
        if (n == 1) {
            return this.sum();
        }
        if (n == 2) {
            return this.sumOfSquares();
        }
        return this.sumOfPowers[n - 3];
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.hasSumOfLogarithms()) {
            stringBuffer.append("Geometric mean: " + this.geometricMean());
            stringBuffer.append("\nProduct: " + this.product() + "\n");
        }
        if (this.hasSumOfInversions()) {
            stringBuffer.append("Harmonic mean: " + this.harmonicMean());
            stringBuffer.append("\nSum of inversions: " + this.sumOfInversions() + "\n");
        }
        int n = this.getMaxOrderForSumOfPowers();
        int n2 = Math.min(6, n);
        if (n > 2) {
            int n3;
            if (n >= 3) {
                stringBuffer.append("Skew: " + this.skew() + "\n");
            }
            if (n >= 4) {
                stringBuffer.append("Kurtosis: " + this.kurtosis() + "\n");
            }
            for (n3 = 3; n3 <= n2; ++n3) {
                stringBuffer.append("Sum of powers(" + n3 + "): " + this.sumOfPowers(n3) + "\n");
            }
            for (n3 = 0; n3 <= n2; ++n3) {
                stringBuffer.append("Moment(" + n3 + ",0): " + this.moment(n3, 0.0) + "\n");
            }
            for (n3 = 0; n3 <= n2; ++n3) {
                stringBuffer.append("Moment(" + n3 + ",mean()): " + this.moment(n3, this.mean()) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    protected void xcheckOrder(int n) {
    }

    protected boolean xequals(Object object) {
        if (!(object instanceof MightyStaticBin1D)) {
            return false;
        }
        MightyStaticBin1D mightyStaticBin1D = (MightyStaticBin1D)object;
        return super.equals(mightyStaticBin1D) && this.sumOfInversions() == mightyStaticBin1D.sumOfInversions() && this.sumOfLogarithms() == mightyStaticBin1D.sumOfLogarithms();
    }

    protected boolean xhasSumOfPowers(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("fromK must be less or equal to toK");
        }
        return this.getMinOrderForSumOfPowers() <= n && n2 <= this.getMaxOrderForSumOfPowers();
    }

    protected synchronized boolean xisLegalOrder(int n) {
        return this.getMinOrderForSumOfPowers() <= n && n <= this.getMaxOrderForSumOfPowers();
    }
}

