/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.ref.Histogram;

abstract class AbstractHistogram1D
extends Histogram
implements IHistogram1D {
    protected IAxis xAxis;

    AbstractHistogram1D(String string) {
        super(string);
    }

    public int allEntries() {
        return this.entries() + this.extraEntries();
    }

    public int dimensions() {
        return 1;
    }

    public int entries() {
        int n = 0;
        int n2 = this.xAxis.bins();
        while (--n2 >= 0) {
            n += this.binEntries(n2);
        }
        return n;
    }

    public int extraEntries() {
        return this.binEntries(-2) + this.binEntries(-1);
    }

    int map(int n) {
        int n2 = this.xAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    public int[] minMaxBins() {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = this.xAxis.bins();
        while (--n3 >= 0) {
            double d4 = this.binHeight(n3);
            if (d4 < d2) {
                d2 = d4;
                n = n3;
            }
            if (!(d4 > d3)) continue;
            d3 = d4;
            n2 = n3;
        }
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    public double sumAllBinHeights() {
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    public double sumBinHeights() {
        double d2 = 0.0;
        int n = this.xAxis.bins();
        while (--n >= 0) {
            d2 += this.binHeight(n);
        }
        return d2;
    }

    public double sumExtraBinHeights() {
        return this.binHeight(-2) + this.binHeight(-1);
    }

    public IAxis xAxis() {
        return this.xAxis;
    }
}

