/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.pi;

import cern.colt.list.DoubleArrayList;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.cobi.pi.Constants;
import org.cobi.pi.GlobalManager;
import org.cobi.pi.a;
import org.cobi.pi.b;
import org.cobi.pi.c;
import org.cobi.pi.controller.GenotypeQC;
import org.cobi.pi.controller.ImputeTask;
import org.cobi.pi.controller.MetaTask;
import org.cobi.pi.controller.PValueReader;
import org.cobi.pi.controller.QCTask;
import org.cobi.pi.controller.Task;
import org.cobi.pi.d;
import org.cobi.pi.entity.Options;
import org.cobi.pi.entity.SNP;
import org.cobi.util.math.StatTest;
import org.cobi.util.net.NetUtils;
import org.cobi.util.plot.PValuePainter;

public class PI
implements Constants {
    Options a;
    String b = "./tmp/";
    PValuePainter c = new PValuePainter(400, 400);
    List d = new ArrayList();
    List e = new ArrayList();

    public PI(Options options) {
        this.a = options;
    }

    public static void main(String[] stringArray) {
        String string = "0.01";
        String string2 = " ";
        String string3 = "06/Mar./2016";
        long l = System.currentTimeMillis();
        String string4 = "@----------------------------------------------------------@\n|        FAPI!       |     v" + string + string2 + "     |   " + string3 + "     |\n" + "|----------------------------------------------------------|\n" + "|      (C) 2013 Miaoxin Li,  limx54@yahoo.com              |\n" + "|----------------------------------------------------------|\n" + "|  For documentation, citation & bug-report instructions:  |\n" + "|            http://grass.cgs.hku.hk/limx/fapi             |\n" + "@----------------------------------------------------------@";
        System.out.println(string4);
        Options options = new Options();
        try {
            Object object;
            if (stringArray.length == 1) {
                options.readOptions(stringArray[0]);
            } else if (stringArray.length > 1) {
                options.readOptions(stringArray);
            } else {
                System.err.println("Usage: java -Xmx1g -jar fapi.jar param.txt\n Or:  java -Xmx1g -jar fapi.jar [options] ...");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            options.getResourceFolder(stringBuilder);
            GlobalManager.initialVariables(options.resourceFolder);
            boolean bl = options.noWebCheck();
            if (bl) {
                bl = true;
            } else {
                object = "To disable web checking, use --no-web";
                System.out.println((String)object);
            }
            if (!bl) {
                if (!NetUtils.isConnected()) {
                    object = "Sorry, I cannot connect to website to check the latest version!\n Please check your local network configurations!";
                    System.err.println((String)object);
                } else if (NetUtils.needUpdate()) {
                    NetUtils.checkLibFileVersion();
                    return;
                }
            }
            options.parseOptions(stringBuilder);
            object = new PI(options);
            if (!options.downloadList.isEmpty()) {
                if (!NetUtils.isConnected()) {
                    String string5 = "Sorry, I cannot connect to website to dwonload the resource!\n Please check your local network configurations!";
                    System.err.println(string5);
                    return;
                }
                NetUtils.downloadResource(options.downloadList);
            }
            if (options.pImpute) {
                ((PI)object).pValueImpute();
            } else if (options.pQC) {
                PValueReader pValueReader = new PValueReader((String)options.pvalueFileNameList.get(0), options.chromIndex, options.markerIDIndex, options.markerPositionIndex, (Integer)options.pvalueIndexList.get(0), options.missingPValueLabel);
                List list = pValueReader.readMarkerPValuesSingleTestPerColumn();
                File file = new File((String)options.resultFileNameList.get(0) + ".unmapped.txt");
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                ((PI)object).pValueQC(pValueReader.getHeadLine(), list, bufferedWriter);
                bufferedWriter.close();
                System.out.println("The detailed information of SNP without registration in reference panel is stored in" + file.getCanonicalPath());
            } else if (options.pMeta) {
                File file = new File((String)options.resultFileNameList.get(0) + ".unmapped.txt");
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                ((PI)object).pValueMeta(bufferedWriter);
                bufferedWriter.close();
                System.out.println("The detailed information of SNP without registration in reference panel is stored in" + file.getCanonicalPath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("The time used is " + (System.currentTimeMillis() - l) / 1000L + " seconds.");
    }

    public void generatDistInput(List list) {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("dist.txt"));
        bufferedWriter.write("rsid chr bp a1 a2 z\n");
        for (int i = 0; i < CHROM_NAMES.length - 1; ++i) {
            Map map;
            String string = CHROM_NAMES[i];
            int[] nArray = (int[])this.a.regions.get(string);
            if (nArray == null || !string.equals("1") || (map = (Map)list.get(i)) == null || map.isEmpty()) continue;
            for (Map.Entry entry : map.entrySet()) {
                if (Double.isNaN(((SNP)entry.getValue()).getpValue())) continue;
                bufferedWriter.write(((SNP)entry.getValue()).getRsID() + " " + string + " " + ((SNP)entry.getValue()).getPhysicalPosition() + " " + "A" + " " + "G" + " " + StatTest.zScoreOneSided(((SNP)entry.getValue()).getpValue()) + "\n");
            }
        }
        bufferedWriter.close();
    }

    public void pValueImpute() {
        Object object;
        File file;
        Object object2;
        Object object3;
        for (int i = 0; i < this.a.pvalueFileNameList.size(); ++i) {
            Object object4;
            Object object5;
            int n;
            object3 = new PValueReader((String)this.a.pvalueFileNameList.get(i), this.a.chromIndex, this.a.markerIDIndex, this.a.markerPositionIndex, (Integer)this.a.pvalueIndexList.get(i), this.a.missingPValueLabel);
            object2 = ((PValueReader)object3).readMarkerPValuesSingleTestPerColumn();
            file = new File((String)this.a.resultFileNameList.get(i) + ".impute.txt");
            object = new BufferedWriter(new FileWriter(file));
            System.out.println("Impute the p-values of SNPs in reference panel...");
            ((Writer)object).append("Chrom\tID\tStartPos\tType\tConfidence\tP\n");
            File file2 = new File((String)this.a.resultFileNameList.get(i) + ".unmapped.txt");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            int n2 = 0;
            ExecutorService executorService = Executors.newFixedThreadPool(this.a.threadNum);
            ExecutorCompletionService executorCompletionService = new ExecutorCompletionService(executorService);
            boolean bl = false;
            if (this.a.varianceFilter < 1.0) {
                // empty if block
            }
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            DoubleArrayList doubleArrayList2 = new DoubleArrayList();
            int[] nArray = new int[3];
            Arrays.fill(nArray, 0);
            for (n = 0; n < CHROM_NAMES.length - 1; ++n) {
                Map map;
                object5 = CHROM_NAMES[n];
                object4 = (int[])this.a.regions.get(object5);
                if (object4 == null || (map = (Map)object2.get(n)) == null || map.isEmpty()) continue;
                ArrayList arrayList = new ArrayList();
                ImputeTask imputeTask = new ImputeTask(0, (String)object5, this.a, map, arrayList, bufferedWriter);
                imputeTask.addTaskListener(new a(this, arrayList, nArray, doubleArrayList, doubleArrayList2, (BufferedWriter)object, (String)object5));
                executorCompletionService.submit(imputeTask);
                ++n2;
            }
            for (n = 0; n < n2; ++n) {
                object5 = executorCompletionService.take();
                object4 = (String)object5.get();
                System.out.println((String)object4);
            }
            executorService.shutdown();
            ((BufferedWriter)object).close();
            doubleArrayList.quickSort();
            doubleArrayList2.quickSort();
            System.out.println("#Input p values: " + nArray[0] + "; #Imputed p values: " + (nArray[1] + nArray[2]) + "; #Imputed p values with confidence score >=" + (1.0 - this.a.varianceFilter) + ": " + nArray[1]);
            System.out.println("The imputed p values are saved in " + file.getCanonicalPath());
            File file3 = new File((String)this.a.resultFileNameList.get(i));
            this.d.add("Imputed");
            doubleArrayList.quickSort();
            this.e.add(doubleArrayList);
            doubleArrayList2.quickSort();
            this.d.add("Actual");
            this.e.add(doubleArrayList2);
            bufferedWriter.close();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss");
        object3 = new Date();
        object2 = simpleDateFormat.format((Date)object3);
        file = new File((String)object2 + ".QQplot.png");
        this.c.drawMultipleQQPlot(this.e, this.d, null, file.getCanonicalPath(), 1.0E-10);
        object = "The QQ plot saved in " + file.getCanonicalPath();
        System.out.println((String)object);
        this.showPlots(new File[]{file});
    }

    public void showPlots(File[] fileArray) {
        if (!GraphicsEnvironment.isHeadless()) {
            EventQueue.invokeLater(new b(this, fileArray));
        } else {
            String string = "But no avaible graphics environment to present the figure(s) here!";
            System.out.println(string);
        }
    }

    public void pValueMeta(BufferedWriter bufferedWriter) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        int n2;
        File file = this.a.noimpute ? new File((String)this.a.resultFileNameList.get(0) + ".noimpute.meta.txt") : new File((String)this.a.resultFileNameList.get(0) + ".meta.txt");
        BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file));
        System.out.println("Meta analysis of p-values...");
        bufferedWriter2.append("Chrom\tID\tStartPos\t");
        int n3 = 1;
        int n4 = 1;
        int n5 = this.a.pvalueFileNameList.size();
        DoubleArrayList[] doubleArrayListArray = new DoubleArrayList[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            object4 = new File((String)this.a.pvalueFileNameList.get(n2));
            bufferedWriter2.append(((File)object4).getName() + ".Type\t");
            bufferedWriter2.append(((File)object4).getName() + ".TConfidence\t");
            bufferedWriter2.append(((File)object4).getName() + ".TP\t");
            doubleArrayListArray[n2] = new DoubleArrayList();
        }
        bufferedWriter2.append("MetaP\tQ\tI\n");
        if (!this.a.sameGenotypeFile) {
            if (n5 >= this.a.threadNum) {
                n3 = this.a.threadNum;
            } else {
                n3 = n5;
                n4 = this.a.threadNum / n5;
            }
        } else {
            n4 = this.a.threadNum;
        }
        n2 = 0;
        object4 = Executors.newFixedThreadPool(n4);
        ExecutorCompletionService executorCompletionService = new ExecutorCompletionService((Executor)object4);
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        boolean bl = true;
        for (n = 0; n < CHROM_NAMES.length - 1; ++n) {
            object3 = CHROM_NAMES[n];
            object2 = new ArrayList();
            object = new MetaTask(n3, (String)object3, n, this.a, (List)object2, bufferedWriter);
            ((Task)object).addTaskListener(new c(this, bufferedWriter2, (List)object2, (String)object3, n5, doubleArrayListArray, doubleArrayList));
            executorCompletionService.submit(object);
            ++n2;
        }
        for (n = 0; n < n2; ++n) {
            object3 = executorCompletionService.take();
            object2 = (String)object3.get();
            System.out.println((String)object2);
        }
        object4.shutdown();
        bufferedWriter2.close();
        System.out.println("The meta anlaysis p values are saved in " + file.getCanonicalPath());
        for (n = 0; n < n5; ++n) {
            object3 = new File((String)this.a.pvalueFileNameList.get(n));
            this.d.add(((File)object3).getName());
            doubleArrayListArray[n].quickSort();
            this.e.add(doubleArrayListArray[n]);
        }
        doubleArrayList.quickSort();
        this.d.add("Meta-P");
        this.e.add(doubleArrayList);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss");
        object3 = new Date();
        object2 = simpleDateFormat.format((Date)object3);
        object = new File((String)object2 + ".QQplot.png");
        this.c.drawMultipleQQPlot(this.e, this.d, null, ((File)object).getCanonicalPath(), 1.0E-10);
        String string = "The QQ plot saved in " + ((File)object).getCanonicalPath();
        System.out.println(string);
        this.showPlots(new File[]{object});
    }

    public void pValueQC(String string, List list, BufferedWriter bufferedWriter) {
        Object object;
        Object object2;
        int n;
        File file = new File((String)this.a.resultFileNameList.get(0) + ".QC.txt");
        BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file));
        GenotypeQC genotypeQC = new GenotypeQC();
        System.out.println("Assess the quality of input p-values ...");
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            bufferedWriter2.write(stringTokenizer.nextToken());
            bufferedWriter2.write("\t");
        }
        bufferedWriter2.write("ImputePValue\tConfidence\tProbC\n");
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        ExecutorService executorService = Executors.newFixedThreadPool(this.a.threadNum);
        ExecutorCompletionService executorCompletionService = new ExecutorCompletionService(executorService);
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        for (n = 0; n < CHROM_NAMES.length - 1; ++n) {
            Map map;
            object2 = CHROM_NAMES[n];
            object = (int[])this.a.regions.get(object2);
            if (object == null || (map = (Map)list.get(n)) == null || map.isEmpty()) continue;
            ArrayList arrayList = new ArrayList();
            QCTask qCTask = new QCTask(0, CHROM_NAMES[n], this.a, map, arrayList, bufferedWriter);
            qCTask.addTaskListener(new d(this, bufferedWriter2, arrayList));
            executorCompletionService.submit(qCTask);
            ++n2;
        }
        for (n = 0; n < n2; ++n) {
            object2 = executorCompletionService.take();
            object = (String)object2.get();
            System.out.println((String)object);
        }
        executorService.shutdown();
        bufferedWriter2.close();
        System.out.println("The impuated p values are saved in " + file.getCanonicalPath());
    }
}

