/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.pi.entity;

import cern.colt.list.ByteArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.cobi.pi.entity.LDSparseMatrix;

public class CorrelationBasedByteLDSparseMatrix
extends LDSparseMatrix {
    List a = new ArrayList();
    OpenIntIntHashMap b = new OpenIntIntHashMap();
    OpenIntIntHashMap c = null;
    int d = 0;
    boolean e = false;
    double f = 0.003937008;

    public CorrelationBasedByteLDSparseMatrix(OpenIntIntHashMap openIntIntHashMap) {
        this.c = openIntIntHashMap;
    }

    @Override
    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public int size() {
        return this.d;
    }

    @Override
    public Set getAllUniqueIndexes() {
        return null;
    }

    public boolean addLDAt(int n, int n2, double d2) {
        if (!this.c.containsKey(n) || !this.c.containsKey(n2)) {
            System.err.println("No registered SNP position to store LD for " + n + " " + n2 + " " + d2);
            return false;
        }
        int n3 = this.c.get(n);
        int n4 = this.c.get(n2);
        int n5 = -1;
        if (n3 < n4) {
            if (this.b.containsKey(n3)) {
                n5 = this.b.get(n3);
            } else {
                n5 = this.a.size();
                this.b.put(n3, n5);
                this.a.add(new ByteArrayList());
            }
            int n6 = n4 - n3;
            ByteArrayList byteArrayList = (ByteArrayList)this.a.get(n5);
            if (byteArrayList == null) {
                byteArrayList = new ByteArrayList();
            }
            for (int i = byteArrayList.size(); i < n6; ++i) {
                byteArrayList.add((byte)-127);
            }
            byteArrayList.setQuick(--n6, (byte)(d2 / this.f - 127.0));
            ++this.d;
        } else if (n3 > n4) {
            if (this.b.containsKey(n3)) {
                n5 = this.b.get(n4);
            } else {
                n5 = this.a.size();
                this.b.put(n4, n5);
                this.a.add(new ByteArrayList());
            }
            int n7 = n3 - n4;
            ByteArrayList byteArrayList = (ByteArrayList)this.a.get(n5);
            if (byteArrayList == null) {
                byteArrayList = new ByteArrayList();
            }
            for (int i = byteArrayList.size(); i < n7; ++i) {
                byteArrayList.add((byte)-127);
            }
            byteArrayList.setQuick(--n7, (byte)(d2 / this.f - 127.0));
            ++this.d;
        } else {
            System.err.println("No need to store this LD for " + n + " " + n2 + " " + d2);
            return false;
        }
        return true;
    }

    @Override
    public DoubleMatrix2D subDenseLDMatrix(IntArrayList intArrayList) {
        int n = intArrayList.size();
        intArrayList.quickSort();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(i, i, 1.0);
            for (int j = i + 1; j < n; ++j) {
                d2 = this.getLDAt(intArrayList.getQuick(i), intArrayList.getQuick(j));
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(i, j, d2);
                ((DoubleMatrix2D)denseDoubleMatrix2D).setQuick(j, i, d2);
            }
        }
        return denseDoubleMatrix2D;
    }

    @Override
    public void releaseLDData() {
        this.a.clear();
        this.b.clear();
        this.c.clear();
        System.gc();
    }

    @Override
    public float getLDAt(int n, int n2) {
        if (!this.c.containsKey(n)) {
            return 0.0f;
        }
        if (!this.c.containsKey(n2)) {
            return 0.0f;
        }
        int n3 = this.c.get(n);
        int n4 = this.c.get(n2);
        int n5 = -1;
        if (n3 < n4) {
            byte by;
            if (!this.b.containsKey(n3)) {
                return 0.0f;
            }
            n5 = this.b.get(n3);
            ByteArrayList byteArrayList = (ByteArrayList)this.a.get(n5);
            if (byteArrayList == null) {
                return 0.0f;
            }
            int n6 = n4 - n3;
            if (n6 > byteArrayList.size()) {
                return 0.0f;
            }
            if ((by = byteArrayList.get(--n6)) == -127) {
                return 0.0f;
            }
            if (by == 127) {
                return 1.0f;
            }
            return (float)((double)(by + 127) * this.f);
        }
        if (n3 > n4) {
            byte by;
            if (!this.b.containsKey(n4)) {
                return 0.0f;
            }
            n5 = this.b.get(n4);
            ByteArrayList byteArrayList = (ByteArrayList)this.a.get(n5);
            if (byteArrayList == null) {
                return 0.0f;
            }
            int n7 = n3 - n4;
            if (n7 > byteArrayList.size()) {
                return 0.0f;
            }
            if ((by = byteArrayList.get(--n7)) == -127) {
                return 0.0f;
            }
            if (by == 127) {
                return 1.0f;
            }
            return (float)((double)(by + 127) * this.f);
        }
        return 1.0f;
    }
}

