/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.util.plot;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.cobi.util.plot.BasicPainter$CoordinateTransformer;
import org.cobi.util.text.LocalString;

public class BasicPainter {
    protected int canvasWidth = 650;
    protected int canvasHeight = 400;
    protected int dataPlottingOffsetLeft = 50;
    protected int dataPlottingOffsetTop = 10;
    protected int dataPlottingOffsetBottom = 40;
    protected int dataPlottingOffsetRight = 20;
    protected Rectangle dataPlottingArea;
    protected Color canvasBackgroundColor = Color.WHITE;
    protected Color axesColor = Color.DARK_GRAY;
    protected Color nonplotBackgroundColor = Color.LIGHT_GRAY;
    protected Font titleFont = new Font("SansSerif", 1, 16);
    protected Font numFont = new Font("SansSerif", 1, 12);
    protected int titleLineHeight = 30;
    protected int yScalDecimal = 2;

    public int getDataPlottingOffsetBottom() {
        return this.dataPlottingOffsetBottom;
    }

    public void setDataPlottingOffsetBottom(int n) {
        this.dataPlottingOffsetBottom = n;
    }

    public int getDataPlottingOffsetLeft() {
        return this.dataPlottingOffsetLeft;
    }

    public void setDataPlottingOffsetLeft(int n) {
        this.dataPlottingOffsetLeft = n;
    }

    public int getDataPlottingOffsetRight() {
        return this.dataPlottingOffsetRight;
    }

    public void setDataPlottingOffsetRight(int n) {
        this.dataPlottingOffsetRight = n;
    }

    public int getDataPlottingOffsetTop() {
        return this.dataPlottingOffsetTop;
    }

    public void setDataPlottingOffsetTop(int n) {
        this.dataPlottingOffsetTop = n;
    }

    public BasicPainter(int n, int n2) {
        this.canvasWidth = n;
        this.canvasHeight = n2;
    }

    protected void plotTriangle(Graphics2D graphics2D, int n, int n2, int n3) {
        Point point = new Point(n, n2);
        Point point2 = new Point(n - n3 / 2, n2 + n3);
        Point point3 = new Point(n + n3 / 2, n2 + n3);
        Polygon polygon = new Polygon();
        polygon.addPoint(point.x, point.y);
        polygon.addPoint(point2.x, point2.y);
        polygon.addPoint(point3.x, point3.y);
        graphics2D.fillPolygon(polygon);
    }

    protected void calculateDataPlottingArea(boolean bl, int n) {
        this.dataPlottingArea = bl ? new Rectangle(this.dataPlottingOffsetLeft, this.dataPlottingOffsetTop, this.canvasWidth - this.dataPlottingOffsetRight - this.dataPlottingOffsetLeft - n, this.canvasHeight - this.dataPlottingOffsetBottom - this.dataPlottingOffsetTop - this.titleLineHeight) : new Rectangle(this.dataPlottingOffsetLeft, this.dataPlottingOffsetTop, this.canvasWidth - this.dataPlottingOffsetRight - this.dataPlottingOffsetLeft - n, this.canvasHeight - this.dataPlottingOffsetBottom - this.dataPlottingOffsetTop);
    }

    protected void calculateDataPlottingArea(boolean bl) {
        this.dataPlottingArea = bl ? new Rectangle(this.dataPlottingOffsetLeft, this.dataPlottingOffsetTop, this.canvasWidth - this.dataPlottingOffsetRight - this.dataPlottingOffsetLeft, this.canvasHeight - this.dataPlottingOffsetBottom - this.dataPlottingOffsetTop - this.titleLineHeight) : new Rectangle(this.dataPlottingOffsetLeft, this.dataPlottingOffsetTop, this.canvasWidth - this.dataPlottingOffsetRight - this.dataPlottingOffsetLeft, this.canvasHeight - this.dataPlottingOffsetBottom - this.dataPlottingOffsetTop);
    }

    public static void outputJPEGFile(BufferedImage bufferedImage, String string) {
        ImageWriter imageWriter = null;
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
        Iterator<ImageWriter> iterator = ImageIO.getImageWriters(imageTypeSpecifier, "jpg");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (imageWriter == null) {
            return;
        }
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(1.0f);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string));
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, iIOImage, imageWriteParam);
        imageOutputStream.flush();
        imageOutputStream.close();
        imageWriter.dispose();
    }

    public static void outputPNGFile(BufferedImage bufferedImage, String string) {
        ImageWriter imageWriter = null;
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
        Iterator<ImageWriter> iterator = ImageIO.getImageWriters(imageTypeSpecifier, "png");
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (imageWriter == null) {
            return;
        }
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string));
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, iIOImage, imageWriteParam);
        imageOutputStream.flush();
        imageOutputStream.close();
        imageWriter.dispose();
    }

    public void paintCanvas(Graphics2D graphics2D) {
        graphics2D.clipRect(0, 0, this.canvasWidth, this.canvasHeight);
        graphics2D.setColor(this.canvasBackgroundColor);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.canvasWidth, this.canvasHeight);
        graphics2D.fill(double_);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.WHITE, 100.0f, 45.0f, Color.GREEN);
        graphics2D.setPaint(gradientPaint);
    }

    protected void drawAxes(Graphics2D graphics2D, String string, String string2, String string3, int n) {
        int n2;
        graphics2D.setColor(this.axesColor.darker());
        Line2D.Double double_ = new Line2D.Double(this.dataPlottingArea.getX(), this.dataPlottingArea.getY(), this.dataPlottingArea.getX(), this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight());
        graphics2D.draw(double_);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.numFont);
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuilder.append('0');
        }
        n2 = graphics2D.getFontMetrics().stringWidth(stringBuilder.toString());
        int n3 = graphics2D.getFontMetrics().stringWidth(string3);
        int n4 = graphics2D.getFontMetrics().getAscent();
        if (n3 > this.dataPlottingOffsetLeft) {
            n3 = this.dataPlottingOffsetLeft;
        }
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.drawString(string3, -(this.dataPlottingArea.height + n3) / 2 - this.dataPlottingArea.y, this.dataPlottingArea.x - n2);
        graphics2D.rotate(1.5707963267948966);
        double_ = new Line2D.Double(this.dataPlottingArea.getX(), this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight(), this.dataPlottingArea.getX() + this.dataPlottingArea.getWidth(), this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight());
        graphics2D.draw(double_);
        n3 = graphics2D.getFontMetrics().stringWidth(string2);
        graphics2D.drawString(string2, (float)(this.dataPlottingArea.x + this.dataPlottingArea.width / 2 - n3 / 2), (float)(this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight() + (double)(this.dataPlottingOffsetBottom * 2 / 3)));
        if (string != null && string.length() > 0) {
            this.drawTitle(graphics2D, string);
        }
        graphics2D.setFont(font);
    }

    protected void drawTitle(Graphics2D graphics2D, String string) {
        graphics2D.setColor(this.axesColor.darker());
        Font font = graphics2D.getFont();
        if (string != null && string.length() > 0) {
            graphics2D.setFont(this.titleFont);
            int n = graphics2D.getFontMetrics().stringWidth(string);
            graphics2D.drawString(string, (float)(this.dataPlottingArea.x + this.dataPlottingArea.width / 2 - n / 2), (float)(this.dataPlottingArea.getY() + this.dataPlottingArea.getHeight() + (double)this.dataPlottingOffsetBottom + (double)(this.titleLineHeight / 2)));
        }
        graphics2D.setFont(font);
    }

    protected int drawAxesSciScale(Graphics2D graphics2D, BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer, boolean bl, boolean bl2) {
        String string;
        Cloneable cloneable;
        Point2D point2D;
        int n;
        graphics2D.setColor(this.axesColor.darker());
        int n2 = 3;
        int n3 = 10;
        double d2 = basicPainter$CoordinateTransformer.getDataVerticalMin();
        double d3 = basicPainter$CoordinateTransformer.getDataVerticalMax();
        double d4 = basicPainter$CoordinateTransformer.getDataHorizontalMin();
        double d5 = basicPainter$CoordinateTransformer.getDataHorizontalMax();
        double d6 = (d3 - d2) / (double)n3;
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.numFont);
        int n4 = 0;
        int n5 = graphics2D.getFontMetrics().getAscent();
        for (n = 1; n <= n3; ++n) {
            Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(d4, d2 + (double)n * d6);
            point2D = new Point2D.Double(((Point2D)point).getX() + (double)n2, ((Point2D)point).getY());
            cloneable = new Line2D.Double(point, point2D);
            graphics2D.draw((Shape)((Object)cloneable));
            string = bl2 ? LocalString.formatPValue(d2 + (double)n * d6) : LocalString.doubleToString(d2 + (double)n * d6, 5, this.yScalDecimal);
            if (n4 < string.length()) {
                n4 = string.length();
            }
            int n6 = graphics2D.getFontMetrics().stringWidth(string);
            graphics2D.drawString(string, (float)((Point2D)point).getX() - (float)n6, (float)(((Point2D)point).getY() + (double)(n5 / 2)));
        }
        n = 10;
        d6 = (d5 - d4) / (double)n;
        for (int i = 1; i <= n; ++i) {
            point2D = basicPainter$CoordinateTransformer.data2ScreenPoint(d4 + (double)i * d6, d2);
            cloneable = new Point2D.Double(point2D.getX(), point2D.getY() - (double)n2);
            Line2D.Double double_ = new Line2D.Double(point2D, (Point2D)cloneable);
            graphics2D.draw(double_);
            string = bl ? LocalString.formatPValue(d4 + (double)i * d6) : LocalString.doubleToString(d4 + (double)i * d6, 5, 2);
            int n7 = graphics2D.getFontMetrics().stringWidth(string);
            graphics2D.drawString(string, (float)point2D.getX() - (float)(n7 / 2), (float)(point2D.getY() + (double)n5));
        }
        graphics2D.setFont(font);
        return n4;
    }

    protected int drawAxesScale(Graphics2D graphics2D, BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer) {
        String string;
        Cloneable cloneable;
        Point2D point2D;
        int n;
        graphics2D.setColor(this.axesColor.darker());
        int n2 = 3;
        int n3 = 10;
        double d2 = basicPainter$CoordinateTransformer.getDataVerticalMin();
        double d3 = basicPainter$CoordinateTransformer.getDataVerticalMax();
        double d4 = basicPainter$CoordinateTransformer.getDataHorizontalMin();
        double d5 = basicPainter$CoordinateTransformer.getDataHorizontalMax();
        double d6 = (d3 - d2) / (double)n3;
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.numFont);
        int n4 = 0;
        int n5 = graphics2D.getFontMetrics().getAscent();
        for (n = 1; n <= n3; ++n) {
            Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(d4, d2 + (double)n * d6);
            point2D = new Point2D.Double(((Point2D)point).getX() + (double)n2, ((Point2D)point).getY());
            cloneable = new Line2D.Double(point, point2D);
            graphics2D.draw((Shape)((Object)cloneable));
            string = LocalString.doubleToString(d2 + (double)n * d6, 5, this.yScalDecimal);
            if (n4 < string.length()) {
                n4 = string.length();
            }
            int n6 = graphics2D.getFontMetrics().stringWidth(string);
            graphics2D.drawString(string, (float)((Point2D)point).getX() - (float)n6, (float)(((Point2D)point).getY() + (double)(n5 / 2)));
        }
        n = 10;
        d6 = (d5 - d4) / (double)n;
        for (int i = 1; i <= n; ++i) {
            point2D = basicPainter$CoordinateTransformer.data2ScreenPoint(d4 + (double)i * d6, d2);
            cloneable = new Point2D.Double(point2D.getX(), point2D.getY() - (double)n2);
            Line2D.Double double_ = new Line2D.Double(point2D, (Point2D)cloneable);
            graphics2D.draw(double_);
            string = LocalString.doubleToString(d4 + (double)i * d6, 5, 2);
            int n7 = graphics2D.getFontMetrics().stringWidth(string);
            graphics2D.drawString(string, (float)point2D.getX() - (float)(n7 * 1 / 2), (float)(point2D.getY() + (double)n5));
        }
        graphics2D.setFont(font);
        return n4;
    }
}

