/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.util.plot;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.FloatArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.stat.Descriptive;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Date;
import org.cobi.util.plot.BasicPainter;
import org.cobi.util.plot.BasicPainter$CoordinateTransformer;
import org.cobi.util.plot.Gradient;

public class HistogramPainter
extends BasicPainter {
    public HistogramPainter(int n, int n2) {
        super(n, n2);
    }

    public void drawHistogramPlot(FloatArrayList floatArrayList, double[][] dArray, String string, String string2, String string3) {
        if (floatArrayList == null || floatArrayList.size() == 0) {
            System.err.println("Null p-value list");
            return;
        }
        if (string != null && string.length() > 0) {
            this.calculateDataPlottingArea(true);
        } else {
            this.calculateDataPlottingArea(false);
        }
        FloatArrayList floatArrayList2 = floatArrayList.copy();
        BufferedImage bufferedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(graphics2D);
        this.yScalDecimal = 3;
        int n = floatArrayList2.size();
        floatArrayList2.quickSort();
        int n2 = dArray.length;
        int n3 = 0;
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d3 = 0.0;
            while (n3 < n && (double)floatArrayList2.getQuick(n3) >= dArray[i][0] && (double)floatArrayList2.getQuick(n3) < dArray[i][1]) {
                d3 += 1.0;
                ++n3;
            }
            if (i == n2 - 1) {
                d3 += (double)(n - n3);
            }
            doubleArrayList.add(d3 / (double)n);
            d2 += doubleArrayList.getQuick(i);
        }
        double d4 = Descriptive.max(doubleArrayList) + 0.005;
        double d5 = 0.0;
        double d6 = dArray[0][0];
        double d7 = dArray[dArray.length - 1][1];
        BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer = new BasicPainter$CoordinateTransformer(this);
        basicPainter$CoordinateTransformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, d6, d7, d5, d4);
        int n4 = this.drawAxesScale(graphics2D, basicPainter$CoordinateTransformer);
        this.drawAxes(graphics2D, string, string2, "Proportion", n4);
        n = doubleArrayList.size();
        Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(d6, d5);
        Point point2 = basicPainter$CoordinateTransformer.data2ScreenPoint(d6, d5);
        double d8 = (d7 - d6) / (double)n;
        for (int i = 0; i < n; ++i) {
            double d9 = d6 + (double)i * d8;
            double d10 = doubleArrayList.getQuick(i);
            basicPainter$CoordinateTransformer.data2ScreenPoint(point, d9, d10);
            d9 = d6 + (double)(i + 1) * d8;
            basicPainter$CoordinateTransformer.data2ScreenPoint(point2, d9, d6);
            graphics2D.drawRect(point.x + 1, point.y, point2.x - point.x, point2.y - point.y);
        }
        graphics2D.dispose();
        HistogramPainter.outputPNGFile(bufferedImage, string3);
    }

    public void drawColorfulHistogramPlot(FloatArrayList floatArrayList, double[][] dArray, String string, String string2, String string3) {
        if (floatArrayList == null || floatArrayList.size() == 0) {
            System.err.println("Null p-value list");
            return;
        }
        if (string != null && string.length() > 0) {
            this.calculateDataPlottingArea(true);
        } else {
            this.calculateDataPlottingArea(false);
        }
        FloatArrayList floatArrayList2 = floatArrayList.copy();
        BufferedImage bufferedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(graphics2D);
        this.yScalDecimal = 3;
        int n = floatArrayList2.size();
        floatArrayList2.quickSort();
        int n2 = dArray.length;
        int n3 = 0;
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d3 = 0.0;
            while (n3 < n && (double)floatArrayList2.getQuick(n3) >= dArray[i][0] && (double)floatArrayList2.getQuick(n3) < dArray[i][1]) {
                d3 += 1.0;
                ++n3;
            }
            if (i == n2 - 1) {
                d3 += (double)(n - n3);
            }
            doubleArrayList.add(d3 / (double)n);
            d2 += doubleArrayList.getQuick(i);
        }
        double d4 = Descriptive.max(doubleArrayList) + 0.005;
        double d5 = 0.0;
        double d6 = dArray[0][0];
        double d7 = dArray[dArray.length - 1][1];
        BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer = new BasicPainter$CoordinateTransformer(this);
        basicPainter$CoordinateTransformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, d6, d7, d5, d4);
        int n4 = this.drawAxesScale(graphics2D, basicPainter$CoordinateTransformer);
        this.drawAxes(graphics2D, string, string2, "Proportion", n4);
        n = doubleArrayList.size();
        n = doubleArrayList.size();
        Color[] colorArray = new Color[]{Color.GREEN, Color.RED};
        Color[] colorArray2 = Gradient.createMultiGradient(colorArray, n);
        Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(d6, d5);
        Point point2 = basicPainter$CoordinateTransformer.data2ScreenPoint(d6, d5);
        double d8 = (d7 - d6) / (double)n;
        for (int i = 0; i < n; ++i) {
            double d9 = d6 + (double)i * d8;
            double d10 = doubleArrayList.getQuick(i);
            basicPainter$CoordinateTransformer.data2ScreenPoint(point, d9, d10);
            d9 = d6 + (double)(i + 1) * d8;
            basicPainter$CoordinateTransformer.data2ScreenPoint(point2, d9, d6);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(point.x + 1, point.y, point2.x - point.x, point2.y - point.y);
            graphics2D.setColor(colorArray2[i]);
            graphics2D.fillRect(point.x + 2, point.y + 1, point2.x - point.x - 1, point2.y - point.y - 1);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.dispose();
        HistogramPainter.outputPNGFile(bufferedImage, string3);
    }

    public void drawHistogramPlot(DoubleArrayList doubleArrayList, int n, String string, String string2, String string3) {
        int n2;
        if (doubleArrayList == null || doubleArrayList.size() == 0) {
            System.err.println("Null p-value list");
            return;
        }
        if (string != null && string.length() > 0) {
            this.calculateDataPlottingArea(true);
        } else {
            this.calculateDataPlottingArea(false);
        }
        double[][] dArray = new double[n][2];
        DoubleArrayList doubleArrayList2 = doubleArrayList.copy();
        BufferedImage bufferedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(graphics2D);
        this.yScalDecimal = 3;
        int n3 = doubleArrayList2.size();
        doubleArrayList2.quickSort();
        double d2 = Descriptive.min(doubleArrayList2);
        double d3 = Descriptive.max(doubleArrayList2);
        double d4 = (d3 - d2) / (double)n;
        dArray[0][0] = d2;
        --n;
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2][1] = d2 + d4 * (double)(n2 + 1);
            dArray[n2 + 1][0] = dArray[n2][1];
        }
        dArray[n][1] = d3;
        ++n;
        n2 = dArray.length;
        int n4 = 0;
        DoubleArrayList doubleArrayList3 = new DoubleArrayList();
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d6 = 0.0;
            while (n4 < n3 && doubleArrayList2.getQuick(n4) >= dArray[i][0] && doubleArrayList2.getQuick(n4) < dArray[i][1]) {
                d6 += 1.0;
                ++n4;
            }
            if (i == n2 - 1) {
                d6 += (double)(n3 - n4);
            }
            doubleArrayList3.add(d6 / (double)n3);
            d5 += doubleArrayList3.getQuick(i);
        }
        double d7 = Descriptive.max(doubleArrayList3);
        double d8 = 0.0;
        BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer = new BasicPainter$CoordinateTransformer(this);
        basicPainter$CoordinateTransformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, d2, d3, d8, d7);
        int n5 = this.drawAxesScale(graphics2D, basicPainter$CoordinateTransformer);
        this.drawAxes(graphics2D, string, string2, "Proportion", n5);
        n3 = doubleArrayList3.size();
        Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(d2, d8);
        Point point2 = basicPainter$CoordinateTransformer.data2ScreenPoint(d2, d8);
        double d9 = (d3 - d2) / (double)n3;
        for (int i = 0; i < n3; ++i) {
            double d10 = d2 + (double)i * d9;
            double d11 = doubleArrayList3.getQuick(i);
            basicPainter$CoordinateTransformer.data2ScreenPoint(point, d10, d11);
            d10 = d2 + (double)(i + 1) * d9;
            basicPainter$CoordinateTransformer.data2ScreenPoint(point2, d10, d8);
            graphics2D.drawRect(point.x + 1, point.y, point2.x - point.x, point2.y - point.y);
        }
        graphics2D.dispose();
        HistogramPainter.outputPNGFile(bufferedImage, string3);
    }

    public void drawColorfulHistogramPlot(DoubleArrayList doubleArrayList, int n, String string, String string2, boolean bl, boolean bl2, String string3) {
        int n2;
        if (doubleArrayList == null || doubleArrayList.size() == 0) {
            System.err.println("Null p-value list");
            return;
        }
        this.dataPlottingOffsetRight = 30;
        if (string != null && string.length() > 0) {
            this.calculateDataPlottingArea(true);
        } else {
            this.calculateDataPlottingArea(false);
        }
        double[][] dArray = new double[n][2];
        DoubleArrayList doubleArrayList2 = doubleArrayList.copy();
        BufferedImage bufferedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(graphics2D);
        int n3 = doubleArrayList2.size();
        doubleArrayList2.quickSort();
        double d2 = Descriptive.min(doubleArrayList2);
        double d3 = Descriptive.max(doubleArrayList2);
        double d4 = (d3 - d2) / (double)n;
        dArray[0][0] = d2;
        --n;
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2][1] = d2 + d4 * (double)(n2 + 1);
            dArray[n2 + 1][0] = dArray[n2][1];
        }
        dArray[n][1] = d3;
        ++n;
        n2 = dArray.length;
        int n4 = 0;
        DoubleArrayList doubleArrayList3 = new DoubleArrayList();
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d6 = 0.0;
            while (n4 < n3 && doubleArrayList2.getQuick(n4) >= dArray[i][0] && doubleArrayList2.getQuick(n4) < dArray[i][1]) {
                d6 += 1.0;
                ++n4;
            }
            if (i == n2 - 1) {
                d6 += (double)(n3 - n4);
            }
            if (bl2) {
                doubleArrayList3.add(d6 / (double)n3);
            } else {
                doubleArrayList3.add(d6);
            }
            System.out.println(dArray[i][0] + "-" + dArray[i][1] + ":" + d6);
        }
        double d7 = Descriptive.max(doubleArrayList3);
        double d8 = 0.0;
        this.yScalDecimal = bl2 ? 3 : 0;
        BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer = new BasicPainter$CoordinateTransformer(this);
        basicPainter$CoordinateTransformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, d2, d3, d8, d7);
        int n5 = 0;
        n5 = bl ? this.drawAxesSciScale(graphics2D, basicPainter$CoordinateTransformer, true, false) : this.drawAxesScale(graphics2D, basicPainter$CoordinateTransformer);
        if (bl2) {
            this.drawAxes(graphics2D, string, string2, "Proportion", n5);
        } else {
            this.drawAxes(graphics2D, string, string2, "Count", n5);
        }
        n3 = doubleArrayList3.size();
        Color[] colorArray = new Color[]{Color.GREEN, Color.red};
        Color[] colorArray2 = Gradient.createMultiGradient(colorArray, n3);
        Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(d2, d8);
        Point point2 = basicPainter$CoordinateTransformer.data2ScreenPoint(d2, d8);
        double d9 = (d3 - d2) / (double)n3;
        for (int i = 0; i < n3; ++i) {
            double d10 = d2 + (double)i * d9;
            double d11 = doubleArrayList3.getQuick(i);
            basicPainter$CoordinateTransformer.data2ScreenPoint(point, d10, d11);
            d10 = d2 + (double)(i + 1) * d9;
            basicPainter$CoordinateTransformer.data2ScreenPoint(point2, d10, d8);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawRect(point.x + 1, point.y, point2.x - point.x, point2.y - point.y);
            graphics2D.setColor(colorArray2[i]);
            graphics2D.fillRect(point.x + 2, point.y + 1, point2.x - point.x - 1, point2.y - point.y - 1);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.dispose();
        HistogramPainter.outputPNGFile(bufferedImage, string3);
    }

    public static void main(String[] stringArray) {
        try {
            Uniform uniform = new Uniform(new MersenneTwister(new Date()));
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            int n = 10000;
            for (int i = 0; i < n; ++i) {
                doubleArrayList.add(uniform.nextDouble());
            }
            HistogramPainter histogramPainter = new HistogramPainter(800, 600);
            histogramPainter.drawColorfulHistogramPlot(doubleArrayList, 10, null, "Proportion", true, true, "test.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

