/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import java.util.Arrays;
import umontreal.iro.lecuyer.charts.XYLineChart;
import umontreal.iro.lecuyer.charts.XYListSeriesCollection;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class QQPlot
extends XYLineChart {
    private double[][] Q;
    private double[][] Lin;

    private void initLinear(double a2, double b2) {
        int m = 100;
        double h = (b2 - a2) / (double)m;
        this.Lin = new double[2][m + 1];
        for (int i = 0; i <= m; ++i) {
            double d2 = a2 + h * (double)i;
            this.Lin[1][i] = d2;
            this.Lin[0][i] = d2;
        }
    }

    private void initPoints(ContinuousDistribution dist, double[] data, int numPoints) {
        int i;
        this.Q = new double[2][numPoints];
        for (i = 0; i < numPoints; ++i) {
            this.Q[1][i] = data[i];
        }
        Arrays.sort(this.Q[1]);
        for (i = 0; i < numPoints; ++i) {
            double p = ((double)i + 0.5) / (double)numPoints;
            this.Q[0][i] = dist.inverseF(p);
        }
    }

    public QQPlot(String title, String XLabel, String YLabel, ContinuousDistribution dist, double[] X) {
        this(title, XLabel, YLabel, dist, X, X.length);
    }

    public QQPlot(String title, String XLabel, String YLabel, ContinuousDistribution dist, double[] X, int numPoints) {
        this.initPoints(dist, X, numPoints);
        this.initLinear(this.Q[1][0], this.Q[1][numPoints - 1]);
        this.dataset = new XYListSeriesCollection(this.Q, this.Lin);
        ((XYListSeriesCollection)this.dataset).setDashPattern(1, "dashed");
        this.init(title, XLabel, YLabel);
    }

    public QQPlot(String title, String XLabel, String YLabel, ContinuousDistribution dist, double[][] data, int r) {
        this(title, XLabel, YLabel, dist, data[r], data[r].length);
    }
}

