/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import cern.colt.list.AbstractList;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.ObjectArrayList;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.PrintfFormat;

public abstract class CycleBasedPointSet
extends PointSet {
    protected int numCycles = 0;
    private double[] shift;
    protected ObjectArrayList cycles = new ObjectArrayList();

    public double getCoordinate(int i, int j) {
        int l = 0;
        int n = 0;
        int k = 0;
        while (n <= i) {
            l = ((AbstractList)this.cycles.get(k)).size();
            n += l;
            ++k;
        }
        AbstractList curCycle = (AbstractList)this.cycles.get(k - 1);
        int coordinate = (i - n + l + j) % curCycle.size();
        double x = ((DoubleArrayList)curCycle).get(coordinate);
        return x;
    }

    public void addRandomShift(int d1, int d2, RandomStream stream) {
        if (null == stream) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   Calling addRandomShift with null stream");
        }
        if (0 == d2) {
            d2 = Math.max(this.dim, 1);
        }
        if (this.shift == null) {
            this.shift = new double[d2];
            this.capacityShift = d2;
        } else if (d2 > this.capacityShift) {
            int d3;
            for (d3 = Math.max(4, this.capacityShift); d2 > d3; d3 *= 2) {
            }
            double[] temp = new double[d3];
            this.capacityShift = d3;
            for (int i = 0; i < d1; ++i) {
                temp[i] = this.shift[i];
            }
            this.shift = temp;
        }
        this.dimShift = d2;
        for (int i = d1; i < d2; ++i) {
            this.shift[i] = stream.nextDouble();
        }
        this.shiftStream = stream;
    }

    public void clearRandomShift() {
        super.clearRandomShift();
        this.shift = null;
    }

    protected void addCycle(AbstractList c2) {
        this.cycles.add(c2);
        ++this.numCycles;
        this.numPoints += c2.size();
    }

    public int getDimension() {
        return Integer.MAX_VALUE;
    }

    public PointSetIterator iterator() {
        return new CycleBasedPointSetIterator();
    }

    public String toString() {
        String s = super.toString();
        return s + PrintfFormat.NEWLINE + "Number of cycles: " + this.numCycles;
    }

    public String formatPoints() {
        StringBuffer sb = new StringBuffer(this.toString());
        for (int c2 = 0; c2 < this.numCycles; ++c2) {
            AbstractList curCycle = (AbstractList)this.cycles.get(c2);
            double[] cycle = ((DoubleArrayList)curCycle).elements();
            sb.append(PrintfFormat.NEWLINE + "Cycle " + c2 + ": (");
            boolean first = true;
            for (int e2 = 0; e2 < curCycle.size(); ++e2) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(cycle[e2]);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public class CycleBasedPointSetIterator
    extends PointSet.DefaultPointSetIterator {
        protected int startPointInCycle;
        protected int curCoordInCycle;
        protected int curCycleIndex;
        protected AbstractList curCycle;
        protected double[] curCycleD;

        public CycleBasedPointSetIterator() {
            super(CycleBasedPointSet.this);
            this.startPointInCycle = 0;
            this.curCoordInCycle = 0;
            this.curCycleIndex = 0;
            this.init();
        }

        protected void init() {
            this.resetCurCycle(0);
        }

        public void resetCurCycle(int index) {
            this.curCycleIndex = index;
            this.curCycle = (AbstractList)CycleBasedPointSet.this.cycles.get(index);
            this.curCycleD = ((DoubleArrayList)this.curCycle).elements();
        }

        public void setCurCoordIndex(int i) {
            this.curCoordIndex = i;
            this.curCoordInCycle = (i + this.startPointInCycle) % this.curCycle.size();
        }

        public void resetCurCoordIndex() {
            this.curCoordIndex = 0;
            this.curCoordInCycle = this.startPointInCycle;
        }

        public boolean hasNextCoordinate() {
            return true;
        }

        public double nextDouble() {
            return this.nextCoordinate() + this.EpsilonHalf;
        }

        public double nextCoordinate() {
            if (this.getCurPointIndex() >= CycleBasedPointSet.this.getNumPoints()) {
                this.outOfBounds();
            }
            double x = this.curCycleD[this.curCoordInCycle];
            if (CycleBasedPointSet.this.shift != null) {
                if (this.curCoordIndex >= CycleBasedPointSet.this.dimShift) {
                    CycleBasedPointSet.this.addRandomShift(CycleBasedPointSet.this.dimShift, this.curCoordIndex + 1, CycleBasedPointSet.this.shiftStream);
                }
                if ((x += CycleBasedPointSet.this.shift[this.curCoordIndex]) >= 1.0) {
                    x -= 1.0;
                }
                if (x <= 0.0) {
                    x = this.EpsilonHalf;
                }
            }
            ++this.curCoordIndex;
            ++this.curCoordInCycle;
            if (this.curCoordInCycle >= this.curCycle.size()) {
                this.curCoordInCycle = 0;
            }
            return x;
        }

        public void nextCoordinates(double[] p, int dim) {
            if (this.getCurPointIndex() >= CycleBasedPointSet.this.getNumPoints()) {
                this.outOfBounds();
            }
            if (this.curCoordIndex + dim >= CycleBasedPointSet.this.dimShift) {
                CycleBasedPointSet.this.addRandomShift(CycleBasedPointSet.this.dimShift, this.curCoordIndex + dim + 1, CycleBasedPointSet.this.shiftStream);
            }
            int j = this.curCoordInCycle;
            int maxj = this.curCycle.size();
            for (int i = 0; i < dim; ++i) {
                double x = this.curCycleD[this.curCoordInCycle++];
                if (this.curCoordInCycle >= maxj) {
                    this.curCoordInCycle = 0;
                }
                if (CycleBasedPointSet.this.shift != null) {
                    if ((x += CycleBasedPointSet.this.shift[this.curCoordIndex + i]) >= 1.0) {
                        x -= 1.0;
                    }
                    if (x <= 0.0) {
                        x = this.EpsilonHalf;
                    }
                }
                p[i] = x;
            }
            this.curCoordIndex += dim;
        }

        public void setCurPointIndex(int i) {
            int l = 0;
            int n = 0;
            int j = 0;
            while (n <= i) {
                l = ((AbstractList)CycleBasedPointSet.this.cycles.get(j)).size();
                n += l;
                ++j;
            }
            this.resetCurCycle(j - 1);
            this.startPointInCycle = i - n + l;
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            this.curCoordInCycle = this.startPointInCycle;
        }

        public void resetCurPointIndex() {
            this.resetCurCycle(0);
            this.startPointInCycle = 0;
            this.curPointIndex = 0;
            this.curCoordIndex = 0;
            this.curCoordInCycle = 0;
        }

        public int resetToNextPoint() {
            ++this.curPointIndex;
            ++this.startPointInCycle;
            if (this.startPointInCycle >= this.curCycle.size()) {
                this.startPointInCycle = 0;
                if (this.curCycleIndex < CycleBasedPointSet.this.numCycles - 1) {
                    this.resetCurCycle(this.curCycleIndex + 1);
                }
            }
            this.curCoordIndex = 0;
            this.curCoordInCycle = this.startPointInCycle;
            return this.curPointIndex;
        }

        public int nextPoint(double[] p, int dim) {
            if (this.getCurPointIndex() >= CycleBasedPointSet.this.getNumPoints()) {
                this.outOfBounds();
            }
            int j = this.startPointInCycle;
            int maxj = this.curCycle.size() - 1;
            for (int i = 0; i < dim; ++i) {
                p[i] = this.curCycleD[j];
                if (j < maxj) {
                    ++j;
                    continue;
                }
                j = 0;
            }
            this.resetToNextPoint();
            return this.curPointIndex;
        }

        public String formatState() {
            return super.formatState() + PrintfFormat.NEWLINE + "Current cycle: " + this.curCycleIndex;
        }
    }
}

