/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.Rank1Lattice;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class KorobovLattice
extends Rank1Lattice {
    protected int genA;

    public KorobovLattice(int n, int a2, int s) {
        super(n, null, 0);
        if (a2 < 1 || a2 >= n) {
            throw new IllegalArgumentException("KorobovLattice must have 1 <= a < n");
        }
        this.genA = a2;
        this.dim = s;
        this.v = new double[s];
        long[] B = new long[this.dim];
        B[0] = 1L;
        this.v[0] = this.normFactor;
        for (int j = 1; j < this.dim; ++j) {
            B[j] = (long)a2 * B[j - 1] % (long)n;
            this.v[j] = this.normFactor * (double)B[j];
        }
    }

    public KorobovLattice(int n, int a2, int s, int t) {
        super(n, null, 0);
        int j;
        if (a2 < 1 || a2 >= n) {
            throw new IllegalArgumentException("KorobovLattice must have 1 <= a < n");
        }
        if (t < 1) {
            throw new IllegalArgumentException("KorobovLattice: must have 0 < t");
        }
        this.dim = s;
        this.genA = a2;
        this.v = new double[s];
        long[] B = new long[this.dim];
        B[0] = a2;
        for (j = 1; j < t; ++j) {
            B[0] = B[0] * (long)a2;
        }
        this.v[0] = (double)B[0] * this.normFactor;
        for (j = 1; j < this.dim; ++j) {
            B[j] = (long)a2 * B[j - 1] % (long)n;
            this.v[j] = this.normFactor * (double)B[j];
        }
    }

    public int getA() {
        return this.genA;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("KorobovLattice:" + PrintfFormat.NEWLINE);
        sb.append("Multiplier a: " + this.genA + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        return sb.toString();
    }
}

