/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;

public class ChiSquareDist
extends ContinuousDistribution {
    protected int n;
    protected double C1;

    public ChiSquareDist(int n) {
        this.setN(n);
    }

    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp(((double)this.n / 2.0 - 1.0) * Math.log(x) - x / 2.0 - this.C1);
    }

    public double cdf(double x) {
        return ChiSquareDist.cdf(this.n, this.decPrec, x);
    }

    public double barF(double x) {
        return ChiSquareDist.barF(this.n, this.decPrec, x);
    }

    public double inverseF(double u) {
        return ChiSquareDist.inverseF(this.n, u);
    }

    public double getMean() {
        return ChiSquareDist.getMean(this.n);
    }

    public double getVariance() {
        return ChiSquareDist.getVariance(this.n);
    }

    public double getStandardDeviation() {
        return ChiSquareDist.getStandardDeviation(this.n);
    }

    public static double density(int n, double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp(((double)n / 2.0 - 1.0) * Math.log(x) - x / 2.0 - (double)n / 2.0 * 0.6931471805599453 - Num.lnGamma((double)n / 2.0));
    }

    public static double cdf(int n, int d2, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 100.0 * (double)n) {
            return 1.0;
        }
        return GammaDist.cdf((double)n / 2.0, d2, x / 2.0);
    }

    public static double barF(int n, int d2, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        return GammaDist.barF((double)n / 2.0, d2, x / 2.0);
    }

    public static double inverseF(int n, double u) {
        double CH;
        double Q;
        double P1;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (u == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u == 0.0) {
            return 0.0;
        }
        double E = 5.0E-6;
        double AA = 0.6931471805;
        if (u < 1.0E-5 || u > 0.99999) {
            return 2.0 * GammaDist.inverseF((double)n / 2.0, 7, u);
        }
        if (u >= 1.0) {
            return (double)n * 100.0;
        }
        if (u >= 0.999998) {
            return (double)n + 4.0 * Math.sqrt(2.0 * (double)n);
        }
        double G = Num.lnGamma((double)n / 2.0);
        double XX = 0.5 * (double)n;
        double C = XX - 1.0;
        if ((double)n >= -1.24 * Math.log(u)) {
            double X = NormalDist.inverseF01(u);
            Q = X * Math.sqrt(P1 = 0.222222 / (double)n) + 1.0 - P1;
            CH = (double)n * Q * Q * Q;
            if (CH > 2.2 * (double)n + 6.0) {
                CH = -2.0 * (Math.log1p(-u) - C * Math.log(0.5 * CH) + G);
            }
        } else {
            CH = Math.pow(u * XX * Math.exp(G + XX * 0.6931471805), 1.0 / XX);
            if (CH - 5.0E-6 < 0.0) {
                return CH;
            }
        }
        Q = CH;
        P1 = 0.5 * CH;
        double P2 = u - GammaDist.cdf(XX, 5, P1);
        if (GammaDist.cdf(XX, 5, P1) == -1.0) {
            throw new IllegalArgumentException("RESULT = -1");
        }
        double T = P2 * Math.exp(XX * 0.6931471805 + G + P1 - C * Math.log(CH));
        double B = T / CH;
        double A = 0.5 * T - B * C;
        double S1 = (210.0 + A * (140.0 + A * (105.0 + A * (84.0 + A * (70.0 + 60.0 * A))))) / 420.0;
        double S2 = (420.0 + A * (735.0 + A * (966.0 + A * (1141.0 + 1278.0 * A)))) / 2520.0;
        double S3 = (210.0 + A * (462.0 + A * (707.0 + 932.0 * A))) / 2520.0;
        double S4 = (252.0 + A * (672.0 + 1182.0 * A) + C * (294.0 + A * (889.0 + 1740.0 * A))) / 5040.0;
        double S5 = (84.0 + 264.0 * A + C * (175.0 + 606.0 * A)) / 2520.0;
        double S6 = (120.0 + C * (346.0 + 127.0 * C)) / 5040.0;
        CH += T * (1.0 + 0.5 * T * S1 - B * C * (S1 - B * (S2 - B * (S3 - B * (S4 - B * (S5 - B * S6))))));
        while (Math.abs(Q / CH - 1.0) > 5.0E-6) {
            Q = CH;
            P1 = 0.5 * CH;
            double temp = GammaDist.cdf(XX, 6, P1);
            P2 = u - temp;
            if (temp == -1.0) {
                return -1.0;
            }
            T = P2 * Math.exp(XX * 0.6931471805 + G + P1 - C * Math.log(CH));
            B = T / CH;
            A = 0.5 * T - B * C;
            S1 = (210.0 + A * (140.0 + A * (105.0 + A * (84.0 + A * (70.0 + 60.0 * A))))) / 420.0;
            S2 = (420.0 + A * (735.0 + A * (966.0 + A * (1141.0 + 1278.0 * A)))) / 2520.0;
            S3 = (210.0 + A * (462.0 + A * (707.0 + 932.0 * A))) / 2520.0;
            S4 = (252.0 + A * (672.0 + 1182.0 * A) + C * (294.0 + A * (889.0 + 1740.0 * A))) / 5040.0;
            S5 = (84.0 + 264.0 * A + C * (175.0 + 606.0 * A)) / 2520.0;
            S6 = (120.0 + C * (346.0 + 127.0 * C)) / 5040.0;
            CH += T * (1.0 + 0.5 * T * S1 - B * C * (S1 - B * (S2 - B * (S3 - B * (S4 - B * (S5 - B * S6))))));
        }
        return CH;
    }

    public static double[] getMLE(double[] x, int m) {
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        double[] parameters = ChiSquareDist.getMomentsEstimate(x, m);
        double k = (double)Math.round(parameters[0]) - 5.0;
        if (k < 1.0) {
            k = 1.0;
        }
        double sum = 0.0;
        for (int i = 0; i < m; ++i) {
            if (x[i] > 0.0) {
                sum += 0.5 * Math.log(x[i]);
                continue;
            }
            sum -= 709.0;
        }
        Function f2 = new Function(sum, m);
        while (f2.evaluate(k) > 0.0) {
            k += 1.0;
        }
        parameters[0] = k;
        return parameters;
    }

    public static ChiSquareDist getInstanceFromMLE(double[] x, int m) {
        double[] parameters = ChiSquareDist.getMLE(x, m);
        return new ChiSquareDist((int)parameters[0]);
    }

    public static double getMean(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("degrees of freedom must be non-null and positive.");
        }
        return n;
    }

    public static double[] getMomentsEstimate(double[] x, int m) {
        double[] parameters = new double[1];
        double sum = 0.0;
        for (int i = 0; i < m; ++i) {
            sum += x[i];
        }
        parameters[0] = sum / (double)m;
        return parameters;
    }

    public static double getVariance(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("degrees of freedom must be non-null and positive.");
        }
        return 2 * n;
    }

    public static double getStandardDeviation(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("degrees of freedom must be non-null and positive.");
        }
        return Math.sqrt(2 * n);
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("degrees of freedom must be non-null and positive.");
        }
        this.n = n;
        this.supportA = 0.0;
        this.C1 = 0.5 * (double)n * 0.6931471805599453 + Num.lnGamma((double)n / 2.0);
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.n;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double sumLog;

        public Function(double s, int n) {
            this.n = n;
            this.sumLog = s;
        }

        public double evaluate(double k) {
            if (k < 1.0) {
                return 1.0E200;
            }
            return this.sumLog + (double)this.n * (Num.lnGamma(k / 2.0) - 0.34657359027997264 - Num.lnGamma((k + 1.0) / 2.0));
        }
    }
}

