/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.RootFinder;

@Deprecated
public class ExtremeValueDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;

    public ExtremeValueDist() {
        this.setParams(0.0, 1.0);
    }

    public ExtremeValueDist(double alpha, double lambda) {
        this.setParams(alpha, lambda);
    }

    public double density(double x) {
        return ExtremeValueDist.density(this.alpha, this.lambda, x);
    }

    public double cdf(double x) {
        return ExtremeValueDist.cdf(this.alpha, this.lambda, x);
    }

    public double barF(double x) {
        return ExtremeValueDist.barF(this.alpha, this.lambda, x);
    }

    public double inverseF(double u) {
        return ExtremeValueDist.inverseF(this.alpha, this.lambda, u);
    }

    public double getMean() {
        return ExtremeValueDist.getMean(this.alpha, this.lambda);
    }

    public double getVariance() {
        return ExtremeValueDist.getVariance(this.alpha, this.lambda);
    }

    public double getStandardDeviation() {
        return ExtremeValueDist.getStandardDeviation(this.alpha, this.lambda);
    }

    public static double density(double alpha, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        double z = lambda * (x - alpha);
        if (z <= -10.0) {
            return 0.0;
        }
        double t = Math.exp(-z);
        return lambda * t * Math.exp(-t);
    }

    public static double cdf(double alpha, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        double z = lambda * (x - alpha);
        if (z <= -10.0) {
            return 0.0;
        }
        if (z >= 100.0) {
            return 1.0;
        }
        return Math.exp(-Math.exp(-z));
    }

    public static double barF(double alpha, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        double z = lambda * (x - alpha);
        if (z <= -10.0) {
            return 1.0;
        }
        if (z >= 1000.0) {
            return 0.0;
        }
        return -Math.expm1(-Math.exp(-z));
    }

    public static double inverseF(double alpha, double lambda, double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -Math.log(-Math.log(u)) / lambda + alpha;
    }

    public static double[] getMLE(double[] x, int n) {
        double d2;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[2];
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += x[i];
        }
        double mean = sum / (double)n;
        sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += (x[i] - mean) * (x[i] - mean);
        }
        double variance = sum / ((double)n - 1.0);
        double lambda0 = Math.PI / Math.sqrt(6.0 * variance);
        Function f2 = new Function(x, n, mean);
        double a2 = lambda0 - 10.0;
        if (d2 < 0.0) {
            a2 = 1.0E-15;
        }
        parameters[1] = RootFinder.brentDekker(a2, lambda0 + 10.0, f2, 1.0E-7);
        double sumExp = 0.0;
        for (int i = 0; i < n; ++i) {
            sumExp += Math.exp(-x[i] * parameters[1]);
        }
        parameters[0] = -Math.log(sumExp / (double)n) / parameters[1];
        return parameters;
    }

    @Deprecated
    public static double[] getMaximumLikelihoodEstimate(double[] x, int n) {
        return ExtremeValueDist.getMLE(x, n);
    }

    public static ExtremeValueDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = ExtremeValueDist.getMLE(x, n);
        return new ExtremeValueDist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return alpha + 0.5772156649015329 / lambda;
    }

    public static double getVariance(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 1.6449340668482262 * (1.0 / (lambda * lambda));
    }

    public static double getStandardDeviation(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return Math.sqrt(0.16666666666666666) * Math.PI / lambda;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = alpha;
        this.lambda = lambda;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : alpha = " + this.alpha + ", lambda = " + this.lambda;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double mean;
        protected double[] x;

        public Function(double[] x, int n, double mean) {
            this.n = n;
            this.mean = mean;
            this.x = new double[n];
            System.arraycopy(x, 0, this.x, 0, n);
        }

        public double evaluate(double lambda) {
            if (lambda <= 0.0) {
                return 1.0E200;
            }
            double exp = 0.0;
            double sumXiExp = 0.0;
            double sumExp = 0.0;
            for (int i = 0; i < this.n; ++i) {
                exp = Math.exp(-this.x[i] * lambda);
                sumExp += exp;
                sumXiExp += this.x[i] * exp;
            }
            return (this.mean - 1.0 / lambda) * sumExp - sumXiExp;
        }
    }
}

