/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.util.Num;

public class StudentDistQuick
extends StudentDist {
    private static final int STUDENT_N1 = 20;
    private static final double STUDENT_X1 = 8.01;
    private static final int STUDENT_KMAX = 200;
    private static final double STUDENT_EPS = 5.0E-17;

    public StudentDistQuick(int n) {
        super(n);
    }

    public double cdf(double x) {
        return StudentDistQuick.cdf(this.n, x);
    }

    public double barF(double x) {
        return StudentDistQuick.barF(this.n, x);
    }

    public double inverseF(double u) {
        return StudentDistQuick.inverseF(this.n, u);
    }

    public static double cdf(int n, double x) {
        int k;
        if (n <= 2) {
            return StudentDist.cdf(n, x);
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (n <= 20 && x <= 8.01) {
            double b2 = 1.0 + x * x / (double)n;
            double y = x / Math.sqrt(n);
            double z = 1.0;
            for (int k2 = n - 2; k2 >= 2; k2 -= 2) {
                z = 1.0 + z * (double)(k2 - 1) / ((double)k2 * b2);
            }
            double v = n % 2 == 0 ? (1.0 + z * y / Math.sqrt(b2)) / 2.0 : (y > -1.0 ? 0.5 + (Math.atan(y) + z * y / b2) / Math.PI : (Math.atan(-1.0 / y) + z * y / b2) / Math.PI);
            if (v > 1.0E-18) {
                return v;
            }
            return 0.0;
        }
        if (x < 8.01) {
            double a2 = (double)n - 0.5;
            double b3 = 48.0 * a2 * a2;
            double z2 = a2 * Math.log1p(x * x / (double)n);
            double z = Math.sqrt(z2);
            double y = (((((64.0 * z2 + 788.0) * z2 + 9801.0) * z2 + 89775.0) * z2 + 543375.0) * z2 + 1788885.0) * z / (210.0 * b3 * b3 * b3);
            y -= (((4.0 * z2 + 33.0) * z2 + 240.0) * z2 + 855.0) * z / (10.0 * b3 * b3);
            y += z + (z2 + 3.0) * z / b3;
            if (x >= 0.0) {
                return NormalDist.barF01(-y);
            }
            return NormalDist.barF01(y);
        }
        double b4 = 1.0 + x * x / (double)n;
        double y = Num.gammaRatioHalf((double)n / 2.0);
        y *= 1.0 / (Math.sqrt(Math.PI * (double)n) * Math.pow(b4, (double)(n + 1) / 2.0));
        double z = (y *= 2.0 * Math.sqrt((double)n * b4)) / (double)n;
        double prec = 10.0;
        double z2 = 10.0;
        for (k = 2; k < 200 && prec > 5.0E-17; k += 2) {
            prec = Math.abs((z += (y *= (double)(k - 1) / ((double)k * b4)) / (double)(n + k)) - z2);
            z2 = z;
        }
        if (k >= 200) {
            System.err.println("student: k >= STUDENT_KMAX");
        }
        if (x >= 0.0) {
            return 1.0 - z / 2.0;
        }
        return z / 2.0;
    }

    public static double barF(int n, double x) {
        if (n <= 2) {
            return StudentDist.barF(n, x);
        }
        return StudentDistQuick.cdf(n, -x);
    }

    public static double inverseF(int n, double u) {
        if (n <= 2) {
            return StudentDist.inverseF(n, u);
        }
        double PI2 = Math.PI;
        double e2 = n;
        double p = u > 0.5 ? 2.0 * (1.0 - u) : 2.0 * u;
        double a2 = 1.0 / (e2 - 0.5);
        double b2 = 48.0 / (a2 * a2);
        double c2 = ((20700.0 / b2 * a2 - 98.0) * a2 - 16.0) * a2 + 96.36;
        double d2 = e2 * Math.sqrt(a2 * Math.PI / 2.0) * ((94.5 / (b2 + c2) - 3.0) / b2 + 1.0);
        double y = Math.pow(d2 * p, 2.0 / e2);
        if (y > a2 + 0.05) {
            double x = p == 1.0 ? 0.0 : NormalDist.inverseF01(p * 0.5);
            y = x * x;
            if (n < 5) {
                c2 += 0.3 * (e2 - 4.5) * (x + 0.6);
            }
            c2 = (((0.05 * d2 * x - 5.0) * x - 7.0) * x - 2.0) * x + b2 + c2;
            y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c2 - y - 3.0) / b2 + 1.0) * x;
            y = a2 * (y * y);
            y = Math.expm1(y);
        } else {
            y = ((1.0 / (((e2 + 6.0) / (e2 * y) - 0.089 * d2 - 0.822) * (e2 + 2.0) * 3.0) + 0.5 / (e2 + 4.0)) * y - 1.0) * (e2 + 1.0) / (e2 + 2.0) + 1.0 / y;
        }
        double t = Math.sqrt(e2 * y);
        if (u < 0.5) {
            return -t;
        }
        return t;
    }
}

