/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class TruncatedDist
extends ContinuousDistribution {
    public static int NUMINTERVALS = 500;
    private ContinuousDistribution dist0;
    private double fa;
    private double fb;
    private double barfb;
    private double fbfa;
    private double a;
    private double b;
    private double approxMean;
    private double approxVariance;
    private double approxStandardDeviation;

    public TruncatedDist(ContinuousDistribution dist, double a2, double b2) {
        this.setParams(dist, a2, b2);
    }

    public double density(double x) {
        if (x < this.a || x > this.b) {
            return 0.0;
        }
        return this.dist0.density(x) / this.fbfa;
    }

    public double cdf(double x) {
        if (x <= this.a) {
            return 0.0;
        }
        if (x >= this.b) {
            return 1.0;
        }
        return (this.dist0.cdf(x) - this.fa) / this.fbfa;
    }

    public double barF(double x) {
        if (x <= this.a) {
            return 1.0;
        }
        if (x >= this.b) {
            return 0.0;
        }
        return (this.dist0.barF(x) - this.barfb) / this.fbfa;
    }

    public double inverseF(double u) {
        if (u == 0.0) {
            return this.a;
        }
        if (u == 1.0) {
            return this.b;
        }
        return this.dist0.inverseF(this.fa + this.fbfa * u);
    }

    public double getMean() {
        if (Double.isNaN(this.approxMean)) {
            throw new UnsupportedOperationException("Undefined mean");
        }
        return this.approxMean;
    }

    public double getVariance() {
        if (Double.isNaN(this.approxVariance)) {
            throw new UnsupportedOperationException("Unknown variance");
        }
        return this.approxVariance;
    }

    public double getStandardDeviation() {
        if (Double.isNaN(this.approxStandardDeviation)) {
            throw new UnsupportedOperationException("Unknown standard deviation");
        }
        return this.approxStandardDeviation;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getFa() {
        return this.fa;
    }

    public double getFb() {
        return this.fb;
    }

    public double getArea() {
        return this.fbfa;
    }

    public void setParams(ContinuousDistribution dist, double a2, double b2) {
        if (a2 >= b2) {
            throw new IllegalArgumentException("a must be smaller than b.");
        }
        this.dist0 = dist;
        if (a2 <= dist.getXinf()) {
            a2 = dist.getXinf();
        }
        if (b2 >= dist.getXsup()) {
            b2 = dist.getXsup();
        }
        this.supportA = this.a = a2;
        this.supportB = this.b = b2;
        this.fa = dist.cdf(a2);
        this.fb = dist.cdf(b2);
        this.fbfa = this.fb - this.fa;
        this.barfb = dist.barF(b2);
        if (a2 <= dist.getXinf() && b2 >= dist.getXsup() || a2 == Double.NEGATIVE_INFINITY && b2 == Double.POSITIVE_INFINITY) {
            this.approxMean = dist.getMean();
            this.approxVariance = dist.getVariance();
            this.approxStandardDeviation = dist.getStandardDeviation();
        } else {
            MomentFunction func1 = new MomentFunction(dist, 1);
            this.approxMean = MathFunctionUtil.simpsonIntegral(func1, a2, b2, NUMINTERVALS) / this.fbfa;
            MomentFunction func2 = new MomentFunction(dist, 2, this.approxMean);
            this.approxVariance = MathFunctionUtil.simpsonIntegral(func2, a2, b2, NUMINTERVALS) / this.fbfa;
            this.approxStandardDeviation = Math.sqrt(this.approxVariance);
        }
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.b, this.fa, this.fb, this.fbfa};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : a = " + this.a + ", b = " + this.b + ", F(a) = " + this.fa + ", F(b) = " + this.fb + ", F(b)-F(a) = " + this.fbfa;
    }

    private static class MomentFunction
    implements MathFunction {
        private ContinuousDistribution dist;
        private int moment;
        private double offset;

        public MomentFunction(ContinuousDistribution dist, int moment) {
            this.dist = dist;
            this.moment = moment;
            this.offset = 0.0;
        }

        public MomentFunction(ContinuousDistribution dist, int moment, double offset) {
            this(dist, moment);
            this.offset = offset;
        }

        public double evaluate(double x) {
            double res = this.dist.density(x);
            double offsetX = x - this.offset;
            for (int i = 0; i < this.moment; ++i) {
                res *= offsetX;
            }
            return res;
        }
    }
}

