/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class UniformDist
extends ContinuousDistribution {
    private double a;
    private double b;

    public UniformDist() {
        this.setParams(0.0, 1.0);
    }

    public UniformDist(double a2, double b2) {
        this.setParams(a2, b2);
    }

    public double density(double x) {
        return UniformDist.density(this.a, this.b, x);
    }

    public double cdf(double x) {
        return UniformDist.cdf(this.a, this.b, x);
    }

    public double barF(double x) {
        return UniformDist.barF(this.a, this.b, x);
    }

    public double inverseF(double u) {
        return UniformDist.inverseF(this.a, this.b, u);
    }

    public double getMean() {
        return UniformDist.getMean(this.a, this.b);
    }

    public double getVariance() {
        return UniformDist.getVariance(this.a, this.b);
    }

    public double getStandardDeviation() {
        return UniformDist.getStandardDeviation(this.a, this.b);
    }

    public static double density(double a2, double b2, double x) {
        if (b2 <= a2) {
            throw new IllegalArgumentException("b <= a");
        }
        if (x <= a2 || x >= b2) {
            return 0.0;
        }
        return 1.0 / (b2 - a2);
    }

    public static double cdf(double a2, double b2, double x) {
        if (b2 <= a2) {
            throw new IllegalArgumentException("b <= a");
        }
        if (x <= a2) {
            return 0.0;
        }
        if (x >= b2) {
            return 1.0;
        }
        return (x - a2) / (b2 - a2);
    }

    public static double barF(double a2, double b2, double x) {
        if (b2 <= a2) {
            throw new IllegalArgumentException("b <= a");
        }
        if (x <= a2) {
            return 1.0;
        }
        if (x >= b2) {
            return 0.0;
        }
        return (b2 - x) / (b2 - a2);
    }

    public static double inverseF(double a2, double b2, double u) {
        if (b2 <= a2) {
            throw new IllegalArgumentException("b <= a");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (u <= 0.0) {
            return a2;
        }
        if (u >= 1.0) {
            return b2;
        }
        return a2 + (b2 - a2) * u;
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < n; ++i) {
            if (x[i] < parameters[0]) {
                parameters[0] = x[i];
            }
            if (!(x[i] > parameters[1])) continue;
            parameters[1] = x[i];
        }
        return parameters;
    }

    public static UniformDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = UniformDist.getMLE(x, n);
        return new UniformDist(parameters[0], parameters[1]);
    }

    public static double getMean(double a2, double b2) {
        if (b2 <= a2) {
            throw new IllegalArgumentException("b <= a");
        }
        return (a2 + b2) / 2.0;
    }

    public static double getVariance(double a2, double b2) {
        if (b2 <= a2) {
            throw new IllegalArgumentException("b <= a");
        }
        return (b2 - a2) * (b2 - a2) / 12.0;
    }

    public static double getStandardDeviation(double a2, double b2) {
        return Math.sqrt(UniformDist.getVariance(a2, b2));
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public void setParams(double a2, double b2) {
        if (b2 <= a2) {
            throw new IllegalArgumentException("b <= a");
        }
        this.a = a2;
        this.b = b2;
        this.supportA = a2;
        this.supportB = b2;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.b};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : a = " + this.a + ", b = " + this.b;
    }
}

