/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import umontreal.iro.lecuyer.probdistmulti.ContinuousDistributionMulti;

public class MultiNormalDist
extends ContinuousDistributionMulti {
    protected int dim;
    protected double[] mu;
    protected DoubleMatrix2D sigma;
    protected DoubleMatrix2D invSigma;
    protected static Algebra algebra = new Algebra();

    public MultiNormalDist(double[] mu, double[][] sigma) {
        this.setParams(mu, sigma);
    }

    public double density(double[] x) {
        int i;
        double sum = 0.0;
        if (this.invSigma == null) {
            this.invSigma = algebra.inverse(this.sigma);
        }
        double[] temp = new double[this.mu.length];
        for (i = 0; i < this.mu.length; ++i) {
            sum = 0.0;
            for (int j = 0; j < this.mu.length; ++j) {
                sum += (x[j] - this.mu[j]) * this.invSigma.getQuick(j, i);
            }
            temp[i] = sum;
        }
        sum = 0.0;
        for (i = 0; i < this.mu.length; ++i) {
            sum += temp[i] * (x[i] - this.mu[i]);
        }
        return Math.exp(-0.5 * sum) / Math.sqrt(Math.pow(Math.PI * 2, this.mu.length) * algebra.det(this.sigma));
    }

    public double[] getMean() {
        return this.mu;
    }

    public double[][] getCovariance() {
        return this.sigma.toArray();
    }

    public double[][] getCorrelation() {
        return MultiNormalDist.getCorrelation_(this.mu, this.sigma.toArray());
    }

    public static double density(double[] mu, double[][] sigma, double[] x) {
        int i;
        double sum = 0.0;
        if (sigma.length != sigma[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (mu.length != sigma.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        DenseDoubleMatrix2D sig = new DenseDoubleMatrix2D(sigma);
        DoubleMatrix2D inv = algebra.inverse(sig);
        double[] temp = new double[mu.length];
        for (i = 0; i < mu.length; ++i) {
            sum = 0.0;
            for (int j = 0; j < mu.length; ++j) {
                sum += (x[j] - mu[j]) * inv.getQuick(j, i);
            }
            temp[i] = sum;
        }
        sum = 0.0;
        for (i = 0; i < mu.length; ++i) {
            sum += temp[i] * (x[i] - mu[i]);
        }
        return Math.exp(-0.5 * sum) / Math.sqrt(Math.pow(Math.PI * 2, mu.length) * algebra.det(sig));
    }

    public int getDimension() {
        return this.dim;
    }

    public static double[] getMean(double[] mu, double[][] sigma) {
        if (sigma.length != sigma[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (mu.length != sigma.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        return mu;
    }

    public static double[][] getCovariance(double[] mu, double[][] sigma) {
        if (sigma.length != sigma[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (mu.length != sigma.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        return sigma;
    }

    private static double[][] getCorrelation_(double[] mu, double[][] sigma) {
        double[][] corr = new double[mu.length][mu.length];
        for (int i = 0; i < mu.length; ++i) {
            for (int j = 0; j < mu.length; ++j) {
                corr[i][j] = -sigma[i][j] / Math.sqrt(sigma[i][i] * sigma[j][j]);
            }
            corr[i][i] = 1.0;
        }
        return corr;
    }

    public static double[][] getCorrelation(double[] mu, double[][] sigma) {
        if (sigma.length != sigma[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (mu.length != sigma.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        return MultiNormalDist.getCorrelation_(mu, sigma);
    }

    public static double[] getMLEMu(double[][] x, int n, int d2) {
        int i;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d2 <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        double[] parameters = new double[d2];
        for (i = 0; i < parameters.length; ++i) {
            parameters[i] = 0.0;
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < d2; ++j) {
                int n2 = j;
                parameters[n2] = parameters[n2] + x[i][j];
            }
        }
        for (i = 0; i < parameters.length; ++i) {
            parameters[i] = parameters[i] / (double)n;
        }
        return parameters;
    }

    public static double[][] getMLESigma(double[][] x, int n, int d2) {
        int j;
        int i;
        double sum = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d2 <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        double[] mean = MultiNormalDist.getMLEMu(x, n, d2);
        double[][] parameters = new double[d2][d2];
        for (i = 0; i < parameters.length; ++i) {
            for (j = 0; j < parameters.length; ++j) {
                parameters[i][j] = 0.0;
            }
        }
        for (i = 0; i < parameters.length; ++i) {
            for (j = 0; j < parameters.length; ++j) {
                sum = 0.0;
                for (int t = 0; t < n; ++t) {
                    sum += (x[t][i] - mean[i]) * (x[t][j] - mean[j]);
                }
                parameters[i][j] = sum / (double)n;
            }
        }
        return parameters;
    }

    public double[] getMu() {
        return this.mu;
    }

    public double getMu(int i) {
        return this.mu[i];
    }

    public double[][] getSigma() {
        return this.sigma.toArray();
    }

    public void setParams(double[] mu, double[][] sigma) {
        if (sigma.length != sigma[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (mu.length != sigma.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        this.mu = new double[mu.length];
        this.dimension = mu.length;
        System.arraycopy(mu, 0, this.mu, 0, mu.length);
        this.sigma = new DenseDoubleMatrix2D(sigma);
        this.invSigma = null;
    }
}

