/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NakagamiDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NakagamiGen
extends RandomVariateGen {
    protected double a;
    protected double lambda;
    protected double c;

    public NakagamiGen(RandomStream s, double a2, double lambda, double c2) {
        super(s, new NakagamiDist(a2, lambda, c2));
        this.setParams(a2, lambda, c2);
    }

    public NakagamiGen(RandomStream s, NakagamiDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getA(), dist.getLambda(), dist.getC());
        }
    }

    public static double nextDouble(RandomStream s, double a2, double lambda, double c2) {
        return NakagamiDist.inverseF(a2, lambda, c2, s.nextDouble());
    }

    public double getA() {
        return this.a;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getC() {
        return this.c;
    }

    protected void setParams(double a2, double lambda, double c2) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        this.a = a2;
        this.lambda = lambda;
        this.c = c2;
    }
}

