/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;

public class LFSR258
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final double NORM = 5.421010862427523E-20;
    private static final double MAX = 0.9999999999999999;
    private long z0;
    private long z1;
    private long z2;
    private long z3;
    private long z4;
    private long[] stream;
    private long[] substream;
    private static long[] curr_stream = new long[]{1234567890L, 1234567890L, 1234567890L, 1234567890L, 1234567890L};

    public LFSR258() {
        this.name = null;
        this.stream = new long[5];
        this.substream = new long[5];
        for (int i = 0; i < 5; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.resetStartStream();
        long z = curr_stream[0] & 0xFFFFFFFFFFFFFFFEL;
        long b2 = z ^ z << 1;
        LFSR258.curr_stream[0] = z = b2 >>> 61 ^ b2 >>> 59 ^ b2 >>> 58 ^ b2 >>> 57 ^ b2 >>> 51 ^ b2 >>> 47 ^ b2 >>> 46 ^ b2 >>> 45 ^ b2 >>> 43 ^ b2 >>> 39 ^ b2 >>> 30 ^ b2 >>> 29 ^ b2 >>> 23 ^ b2 >>> 15 ^ z << 2 ^ z << 4 ^ z << 5 ^ z << 6 ^ z << 12 ^ z << 16 ^ z << 17 ^ z << 18 ^ z << 20 ^ z << 24 ^ z << 33 ^ z << 34 ^ z << 40 ^ z << 48;
        z = curr_stream[1] & 0xFFFFFFFFFFFFFE00L;
        b2 = z ^ z << 24;
        LFSR258.curr_stream[1] = z = b2 >>> 52 ^ b2 >>> 50 ^ b2 >>> 49 ^ b2 >>> 46 ^ b2 >>> 43 ^ b2 >>> 40 ^ b2 >>> 37 ^ b2 >>> 34 ^ b2 >>> 30 ^ b2 >>> 28 ^ b2 >>> 26 ^ b2 >>> 25 ^ b2 >>> 23 ^ b2 >>> 21 ^ b2 >>> 20 ^ b2 >>> 19 ^ b2 >>> 17 ^ b2 >>> 15 ^ b2 >>> 13 ^ b2 >>> 12 ^ b2 >>> 10 ^ b2 >>> 8 ^ b2 >>> 7 ^ b2 >>> 6 ^ b2 >>> 2 ^ z << 1 ^ z << 4 ^ z << 6 ^ z << 7 ^ z << 11 ^ z << 14 ^ z << 15 ^ z << 16 ^ z << 17 ^ z << 21 ^ z << 22 ^ z << 25 ^ z << 27 ^ z << 29 ^ z << 30 ^ z << 32 ^ z << 34 ^ z << 35 ^ z << 36 ^ z << 38 ^ z << 40 ^ z << 42 ^ z << 43 ^ z << 45 ^ z << 47 ^ z << 48 ^ z << 49 ^ z << 53;
        z = curr_stream[2] & 0xFFFFFFFFFFFFF000L;
        b2 = z ^ z << 3;
        LFSR258.curr_stream[2] = z = b2 >>> 49 ^ b2 >>> 45 ^ b2 >>> 41 ^ b2 >>> 40 ^ b2 >>> 32 ^ b2 >>> 27 ^ b2 >>> 23 ^ b2 >>> 14 ^ b2 >>> 1 ^ z << 2 ^ z << 3 ^ z << 7 ^ z << 11 ^ z << 12 ^ z << 20 ^ z << 25 ^ z << 29 ^ z << 38 ^ z << 51;
        z = curr_stream[3] & 0xFFFFFFFFFFFE0000L;
        b2 = z ^ z << 5;
        LFSR258.curr_stream[3] = z = b2 >>> 45 ^ b2 >>> 32 ^ b2 >>> 27 ^ b2 >>> 22 ^ b2 >>> 17 ^ b2 >>> 13 ^ b2 >>> 12 ^ b2 >>> 7 ^ b2 >>> 3 ^ b2 >>> 2 ^ z << 3 ^ z << 15 ^ z << 20 ^ z << 25 ^ z << 30 ^ z << 34 ^ z << 35 ^ z << 40 ^ z << 44 ^ z << 45;
        z = curr_stream[4] & 0xFFFFFFFFFF800000L;
        b2 = z ^ z << 3;
        LFSR258.curr_stream[4] = z = b2 >>> 40 ^ b2 >>> 39 ^ b2 >>> 38 ^ b2 >>> 37 ^ b2 >>> 35 ^ b2 >>> 34 ^ b2 >>> 31 ^ b2 >>> 30 ^ b2 >>> 29 ^ b2 >>> 28 ^ b2 >>> 27 ^ b2 >>> 26 ^ b2 >>> 24 ^ b2 >>> 23 ^ b2 >>> 21 ^ b2 >>> 20 ^ b2 >>> 18 ^ b2 >>> 15 ^ b2 >>> 12 ^ b2 >>> 10 ^ b2 >>> 9 ^ b2 >>> 7 ^ b2 >>> 6 ^ b2 >>> 5 ^ b2 >>> 4 ^ b2 >>> 3 ^ z << 1 ^ z << 2 ^ z << 3 ^ z << 4 ^ z << 6 ^ z << 7 ^ z << 10 ^ z << 11 ^ z << 12 ^ z << 13 ^ z << 14 ^ z << 15 ^ z << 17 ^ z << 18 ^ z << 20 ^ z << 21 ^ z << 23 ^ z << 26 ^ z << 29 ^ z << 31 ^ z << 32 ^ z << 34 ^ z << 35 ^ z << 36 ^ z << 37 ^ z << 38;
    }

    public LFSR258(String name) {
        this();
        this.name = name;
    }

    public static void setPackageSeed(long[] seed) {
        LFSR258.checkSeed(seed);
        for (int i = 0; i < 5; ++i) {
            LFSR258.curr_stream[i] = seed[i];
        }
    }

    private static void checkSeed(long[] seed) {
        if (seed.length < 5) {
            throw new IllegalArgumentException("Seed must contain 5 values");
        }
        if (seed[0] >= 0L && seed[0] < 2L || seed[1] >= 0L && seed[1] < 512L || seed[2] >= 0L && seed[2] < 4096L || seed[3] >= 0L && seed[3] < 131072L || seed[4] >= 0L && seed[4] < 0x800000L) {
            throw new IllegalArgumentException("The seed elements must be either negative or greater than 1, 511, 4095, 131071 and 8388607 respectively");
        }
    }

    public void setSeed(long[] seed) {
        LFSR258.checkSeed(seed);
        for (int i = 0; i < 5; ++i) {
            this.stream[i] = seed[i];
        }
        this.resetStartStream();
    }

    public long[] getState() {
        return new long[]{this.z0, this.z1, this.z2, this.z3, this.z4};
    }

    public LFSR258 clone() {
        LFSR258 retour = null;
        retour = (LFSR258)super.clone();
        retour.stream = new long[5];
        retour.substream = new long[5];
        for (int i = 0; i < 5; ++i) {
            retour.substream[i] = this.substream[i];
            retour.stream[i] = this.stream[i];
        }
        return retour;
    }

    public void resetStartStream() {
        for (int i = 0; i < 5; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.z0 = this.substream[0];
        this.z1 = this.substream[1];
        this.z2 = this.substream[2];
        this.z3 = this.substream[3];
        this.z4 = this.substream[4];
    }

    public void resetNextSubstream() {
        long z = this.substream[0] & 0xFFFFFFFFFFFFFFFEL;
        long b2 = z ^ z << 1;
        this.substream[0] = z = b2 >>> 58 ^ b2 >>> 55 ^ b2 >>> 46 ^ b2 >>> 43 ^ z << 5 ^ z << 8 ^ z << 17 ^ z << 20;
        z = this.substream[1] & 0xFFFFFFFFFFFFFE00L;
        b2 = z ^ z << 24;
        this.substream[1] = z = b2 >>> 54 ^ b2 >>> 53 ^ b2 >>> 52 ^ b2 >>> 50 ^ b2 >>> 49 ^ b2 >>> 48 ^ b2 >>> 43 ^ b2 >>> 41 ^ b2 >>> 38 ^ b2 >>> 37 ^ b2 >>> 30 ^ b2 >>> 25 ^ b2 >>> 24 ^ b2 >>> 23 ^ b2 >>> 19 ^ b2 >>> 16 ^ b2 >>> 15 ^ b2 >>> 14 ^ b2 >>> 13 ^ b2 >>> 11 ^ b2 >>> 8 ^ b2 >>> 7 ^ b2 >>> 5 ^ b2 >>> 3 ^ z << 0 ^ z << 2 ^ z << 3 ^ z << 6 ^ z << 7 ^ z << 8 ^ z << 9 ^ z << 10 ^ z << 11 ^ z << 12 ^ z << 13 ^ z << 14 ^ z << 16 ^ z << 18 ^ z << 19 ^ z << 21 ^ z << 25 ^ z << 30 ^ z << 31 ^ z << 32 ^ z << 36 ^ z << 39 ^ z << 40 ^ z << 41 ^ z << 42 ^ z << 44 ^ z << 47 ^ z << 48 ^ z << 50 ^ z << 52;
        z = this.substream[2] & 0xFFFFFFFFFFFFF000L;
        b2 = z ^ z << 3;
        this.substream[2] = z = b2 >>> 50 ^ b2 >>> 49 ^ b2 >>> 46 ^ b2 >>> 42 ^ b2 >>> 40 ^ b2 >>> 39 ^ b2 >>> 38 ^ b2 >>> 37 ^ b2 >>> 36 ^ b2 >>> 32 ^ b2 >>> 29 ^ b2 >>> 28 ^ b2 >>> 27 ^ b2 >>> 25 ^ b2 >>> 23 ^ b2 >>> 20 ^ b2 >>> 19 ^ b2 >>> 15 ^ b2 >>> 12 ^ b2 >>> 11 ^ b2 >>> 2 ^ z << 1 ^ z << 2 ^ z << 3 ^ z << 6 ^ z << 10 ^ z << 12 ^ z << 13 ^ z << 14 ^ z << 15 ^ z << 16 ^ z << 20 ^ z << 23 ^ z << 24 ^ z << 25 ^ z << 27 ^ z << 29 ^ z << 32 ^ z << 33 ^ z << 37 ^ z << 40 ^ z << 41 ^ z << 50;
        z = this.substream[3] & 0xFFFFFFFFFFFE0000L;
        b2 = z ^ z << 5;
        this.substream[3] = z = b2 >>> 46 ^ b2 >>> 44 ^ b2 >>> 42 ^ b2 >>> 41 ^ b2 >>> 40 ^ b2 >>> 38 ^ b2 >>> 36 ^ b2 >>> 32 ^ b2 >>> 30 ^ b2 >>> 25 ^ b2 >>> 18 ^ b2 >>> 16 ^ b2 >>> 15 ^ b2 >>> 14 ^ b2 >>> 12 ^ b2 >>> 11 ^ b2 >>> 10 ^ b2 >>> 9 ^ b2 >>> 8 ^ b2 >>> 6 ^ b2 >>> 5 ^ b2 >>> 4 ^ b2 >>> 3 ^ b2 >>> 2 ^ z << 2 ^ z << 5 ^ z << 6 ^ z << 7 ^ z << 9 ^ z << 11 ^ z << 15 ^ z << 17 ^ z << 22 ^ z << 29 ^ z << 31 ^ z << 32 ^ z << 33 ^ z << 35 ^ z << 36 ^ z << 37 ^ z << 38 ^ z << 39 ^ z << 41 ^ z << 42 ^ z << 43 ^ z << 44 ^ z << 45;
        z = this.substream[4] & 0xFFFFFFFFFF800000L;
        b2 = z ^ z << 3;
        this.substream[4] = z = b2 >>> 40 ^ b2 >>> 29 ^ b2 >>> 10 ^ z << 1 ^ z << 12 ^ z << 31;
        this.resetStartSubstream();
    }

    public String toString() {
        if (this.name == null) {
            return "The state of the LFSR258 is: " + this.z0 + "L, " + this.z1 + "L, " + this.z2 + "L, " + this.z3 + "L, " + this.z4 + "L";
        }
        return "The state of " + this.name + " is: " + this.z0 + "L, " + this.z1 + "L, " + this.z2 + "L, " + this.z3 + "L, " + this.z4 + "L";
    }

    private long nextNumber() {
        long b2 = (this.z0 << 1 ^ this.z0) >>> 53;
        this.z0 = (this.z0 & 0xFFFFFFFFFFFFFFFEL) << 10 ^ b2;
        b2 = (this.z1 << 24 ^ this.z1) >>> 50;
        this.z1 = (this.z1 & 0xFFFFFFFFFFFFFE00L) << 5 ^ b2;
        b2 = (this.z2 << 3 ^ this.z2) >>> 23;
        this.z2 = (this.z2 & 0xFFFFFFFFFFFFF000L) << 29 ^ b2;
        b2 = (this.z3 << 5 ^ this.z3) >>> 24;
        this.z3 = (this.z3 & 0xFFFFFFFFFFFE0000L) << 23 ^ b2;
        b2 = (this.z4 << 3 ^ this.z4) >>> 33;
        this.z4 = (this.z4 & 0xFFFFFFFFFF800000L) << 8 ^ b2;
        return this.z0 ^ this.z1 ^ this.z2 ^ this.z3 ^ this.z4;
    }

    protected double nextValue() {
        long res = this.nextNumber();
        if (res <= 0L) {
            return (double)res * 5.421010862427523E-20 + 0.9999999999999999;
        }
        return (double)res * 5.421010862427523E-20;
    }

    public int nextInt(int i, int j) {
        long res;
        if (i > j) {
            throw new IllegalArgumentException(i + " is larger than " + j + ".");
        }
        long d2 = j - i + 1;
        long q = 0x4000000000000000L / d2;
        long r = 0x4000000000000000L % d2;
        while ((res = this.nextNumber() >>> 2) >= 0x4000000000000000L - r) {
        }
        return i + (int)(res / q);
    }
}

