/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStream;

public class TruncatedRandomStream
implements RandomStream {
    private RandomStream stream;
    private double a;
    private double bminusa;

    public TruncatedRandomStream(RandomStream stream, double a2, double b2) {
        if (stream == null) {
            throw new NullPointerException("The given stream must not be null");
        }
        if (a2 >= b2) {
            throw new IllegalArgumentException("a must be smaller than b");
        }
        if (a2 < 0.0 || b2 < 0.0 || a2 > 1.0 || b2 > 1.0) {
            throw new IllegalArgumentException("a and b must be in [0, 1]");
        }
        this.stream = stream;
        this.a = a2;
        this.bminusa = b2 - a2;
    }

    public void resetStartStream() {
        this.stream.resetStartStream();
    }

    public void resetStartSubstream() {
        this.stream.resetStartSubstream();
    }

    public void resetNextSubstream() {
        this.stream.resetNextSubstream();
    }

    public double nextDouble() {
        double v = this.stream.nextDouble();
        return this.a + v * this.bminusa;
    }

    public void nextArrayOfDouble(double[] u, int start, int n) {
        this.stream.nextArrayOfDouble(u, start, n);
        for (int i = start; i < start + n; ++i) {
            u[i] = this.a + u[i] * this.bminusa;
        }
    }

    public int nextInt(int i, int j) {
        return i + (int)(this.nextDouble() * (double)(j - i + 1));
    }

    public void nextArrayOfInt(int i, int j, int[] u, int start, int n) {
        for (int x = start; x < start + n; ++x) {
            u[x] = this.nextInt(i, j);
        }
    }
}

