/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat;

import java.util.ArrayList;
import java.util.List;
import umontreal.iro.lecuyer.stat.ObservationListener;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatProbe {
    private List<ObservationListener> listeners = new ArrayList<ObservationListener>();
    protected String name;
    protected double maxValue;
    protected double minValue;
    protected double sumValue;
    protected boolean collect = true;
    protected boolean broadcast = false;
    protected boolean showNobs = true;

    public abstract void init();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public double min() {
        return this.minValue;
    }

    public double max() {
        return this.maxValue;
    }

    public double sum() {
        return this.sumValue;
    }

    public abstract double average();

    public abstract String report();

    public abstract String shortReport();

    public abstract String shortReportHeader();

    public static String report(String globalName, StatProbe[] probes) {
        int maxn = 0;
        StatProbe firstProbe = null;
        for (StatProbe probe : probes) {
            String s;
            if (firstProbe == null) {
                firstProbe = probe;
            }
            if ((s = probe.getName()) == null || s.length() <= maxn) continue;
            maxn = s.length();
        }
        if (firstProbe == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("Report for ");
        sb.append(globalName).append(PrintfFormat.NEWLINE);
        for (int i = 0; i < maxn; ++i) {
            sb.append(' ');
        }
        sb.append("   ");
        sb.append(firstProbe.shortReportHeader()).append(PrintfFormat.NEWLINE);
        for (StatProbe probe : probes) {
            sb.append(PrintfFormat.s(-maxn, probe.getName()));
            sb.append("   ");
            sb.append(probe.shortReport()).append(PrintfFormat.NEWLINE);
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String report(String globalName, Iterable<? extends StatProbe> probes) {
        void var5_7;
        int maxn = 0;
        StatProbe firstProbe = null;
        for (StatProbe statProbe : probes) {
            String string;
            int sl;
            if (firstProbe == null) {
                firstProbe = statProbe;
            }
            if ((sl = (string = statProbe.getName()) == null ? 4 : string.length()) <= maxn) continue;
            maxn = sl;
        }
        if (firstProbe == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("Report for ");
        sb.append(globalName).append(PrintfFormat.NEWLINE);
        boolean bl = false;
        while (var5_7 < maxn) {
            sb.append(' ');
            ++var5_7;
        }
        sb.append("   ");
        sb.append(firstProbe.shortReportHeader()).append(PrintfFormat.NEWLINE);
        for (StatProbe statProbe : probes) {
            sb.append(PrintfFormat.s(-maxn, statProbe.getName()));
            sb.append("   ");
            sb.append(statProbe.shortReport()).append(PrintfFormat.NEWLINE);
        }
        return sb.toString();
    }

    public boolean isBroadcasting() {
        return this.broadcast;
    }

    public void setBroadcasting(boolean b2) {
        this.broadcast = b2;
    }

    public boolean isCollecting() {
        return this.collect;
    }

    public void setCollecting(boolean b2) {
        this.collect = b2;
    }

    public void addObservationListener(ObservationListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeObservationListener(ObservationListener l) {
        this.listeners.remove(l);
    }

    public void clearObservationListeners() {
        this.listeners.clear();
    }

    public void notifyListeners(double x) {
        if (!this.broadcast) {
            return;
        }
        int nl = this.listeners.size();
        for (int i = 0; i < nl; ++i) {
            this.listeners.get(i).newObservation(this, x);
        }
    }

    public StatProbe clone() throws CloneNotSupportedException {
        StatProbe s = (StatProbe)super.clone();
        s.listeners = new ArrayList<ObservationListener>(this.listeners);
        return s;
    }
}

