/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import umontreal.iro.lecuyer.functions.MathFunction;

public class RootFinder {
    private RootFinder() {
    }

    public static double brentDekker(double a2, double b2, MathFunction f2, double tol) {
        double e2;
        double EPS = 5.0E-16;
        int MAXITER = 120;
        if (b2 < a2) {
            double ctemp = a2;
            a2 = b2;
            b2 = ctemp;
        }
        double fa = f2.evaluate(a2);
        double fb = f2.evaluate(b2);
        double c2 = a2;
        double fc = fa;
        double d2 = e2 = b2 - a2;
        tol += 7.220446049250313E-16;
        if (Math.abs(fc) < Math.abs(fb)) {
            a2 = b2;
            b2 = c2;
            c2 = a2;
            fa = fb;
            fb = fc;
            fc = fa;
        }
        for (int i = 0; i < 120; ++i) {
            double tol1 = tol + 8.881784197001252E-16 * Math.abs(b2);
            double xm = 0.5 * (c2 - b2);
            if (Math.abs(fb) == 0.0 || Math.abs(xm) <= tol1) {
                return b2;
            }
            if (Math.abs(e2) >= tol1 && Math.abs(fa) > Math.abs(fb)) {
                double p;
                double s;
                double q;
                if (a2 != c2) {
                    q = fa / fc;
                    double r = fb / fc;
                    s = fb / fa;
                    p = s * (2.0 * xm * q * (q - r) - (b2 - a2) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                } else {
                    s = fb / fa;
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                }
                if (p > 0.0) {
                    q = -q;
                }
                if (2.0 * (p = Math.abs(p)) >= 3.0 * xm * q - Math.abs(tol1 * q) || p >= Math.abs(0.5 * e2 * q)) {
                    e2 = d2 = xm;
                } else {
                    e2 = d2;
                    d2 = p / q;
                }
            } else {
                e2 = d2 = xm;
            }
            a2 = b2;
            fa = fb;
            b2 = Math.abs(d2) > tol1 ? (b2 += d2) : (xm < 0.0 ? (b2 -= tol1) : (b2 += tol1));
            fb = f2.evaluate(b2);
            if (fb * (fc / Math.abs(fc)) > 0.0) {
                c2 = a2;
                fc = fa;
                d2 = e2 = b2 - a2;
                continue;
            }
            a2 = b2;
            b2 = c2;
            c2 = a2;
            fa = fb;
            fb = fc;
            fc = fa;
        }
        return b2;
    }

    public static double bisection(double a2, double b2, MathFunction f2, double tol) {
        if (b2 < a2) {
            double ctemp = a2;
            a2 = b2;
            b2 = ctemp;
        }
        double xa = a2;
        double xb = b2;
        double yb = f2.evaluate(b2);
        double ya = f2.evaluate(a2);
        double x = 0.0;
        double y = 0.0;
        int MAXITER = 1200;
        boolean DEBUG = false;
        double myMIN_NORMAL = 2.25E-308;
        boolean fini = false;
        int i = 0;
        while (!fini) {
            x = (xa + xb) / 2.0;
            y = f2.evaluate(x);
            if (Math.abs(y) <= 2.25E-308 || Math.abs(xb - xa) <= tol * Math.abs(x) || Math.abs(xb - xa) <= 0.0) {
                return x;
            }
            if (y * ya < 0.0) {
                xb = x;
            } else {
                xa = x;
            }
            if (++i <= 1200) continue;
            System.out.println("***** bisection:  SEARCH DOES NOT CONVERGE");
            fini = true;
        }
        return x;
    }
}

