/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.FloatComparator;
import cern.colt.function.FloatProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.FloatArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractFloatList
extends AbstractList {
    protected int size;

    protected AbstractFloatList() {
    }

    public void add(float f2) {
        this.beforeInsert(this.size, f2);
    }

    public void addAllOfFromTo(AbstractFloatList abstractFloatList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractFloatList, n, n2);
    }

    public void beforeInsert(int n, float f2) {
        this.beforeInsertDummies(n, 1);
        this.set(n, f2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractFloatList abstractFloatList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractFloatList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public int binarySearch(float f2) {
        return this.binarySearchFromTo(f2, 0, this.size - 1);
    }

    public int binarySearchFromTo(float f2, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            float f3 = this.get(n5);
            if (f3 < f2) {
                n3 = n5 + 1;
                continue;
            }
            if (f3 > f2) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(float f2) {
        return this.indexOfFromTo(f2, 0, this.size - 1) >= 0;
    }

    public void delete(float f2) {
        int n = this.indexOfFromTo(f2, 0, this.size - 1);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public float[] elements() {
        float[] fArray = new float[this.size];
        int n = this.size;
        while (--n >= 0) {
            fArray[n] = this.getQuick(n);
        }
        return fArray;
    }

    public AbstractFloatList elements(float[] fArray) {
        this.clear();
        this.addAllOfFromTo(new FloatArrayList(fArray), 0, fArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractFloatList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractFloatList abstractFloatList = (AbstractFloatList)object;
        if (this.size() != abstractFloatList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractFloatList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, float f2) {
        AbstractFloatList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            this.setQuick(n3++, f2);
        }
    }

    public boolean forEach(FloatProcedure floatProcedure) {
        int n = 0;
        while (n < this.size) {
            if (floatProcedure.apply(this.get(n++))) continue;
            return false;
        }
        return true;
    }

    public float get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract float getQuick(int var1);

    public int indexOf(float f2) {
        return this.indexOfFromTo(f2, 0, this.size - 1);
    }

    public int indexOfFromTo(float f2, int n, int n2) {
        AbstractFloatList.checkRangeFromTo(n, n2, this.size);
        for (int i = n; i <= n2; ++i) {
            if (f2 != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float f2) {
        return this.lastIndexOfFromTo(f2, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(float f2, int n, int n2) {
        AbstractFloatList.checkRangeFromTo(n, n2, this.size());
        for (int i = n2; i >= n; --i) {
            if (f2 != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public void mergeSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractFloatList.checkRangeFromTo(n, n2, n3);
        float[] fArray = this.elements();
        Sorting.mergeSort(fArray, n, n2 + 1);
        this.elements(fArray);
        this.setSizeRaw(n3);
    }

    public void mergeSortFromTo(int n, int n2, FloatComparator floatComparator) {
        int n3 = this.size();
        AbstractFloatList.checkRangeFromTo(n, n2, n3);
        float[] fArray = this.elements();
        Sorting.mergeSort(fArray, n, n2 + 1, floatComparator);
        this.elements(fArray);
        this.setSizeRaw(n3);
    }

    public AbstractFloatList partFromTo(int n, int n2) {
        AbstractFloatList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        FloatArrayList floatArrayList = new FloatArrayList(n3);
        floatArrayList.addAllOfFromTo(this, n, n2);
        return floatArrayList;
    }

    public void quickSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractFloatList.checkRangeFromTo(n, n2, n3);
        float[] fArray = this.elements();
        java.util.Arrays.sort(fArray, n, n2 + 1);
        this.elements(fArray);
        this.setSizeRaw(n3);
    }

    public void quickSortFromTo(int n, int n2, FloatComparator floatComparator) {
        int n3 = this.size();
        AbstractFloatList.checkRangeFromTo(n, n2, n3);
        float[] fArray = this.elements();
        Sorting.quickSort(fArray, n, n2 + 1, floatComparator);
        this.elements(fArray);
        this.setSizeRaw(n3);
    }

    public boolean removeAll(AbstractFloatList abstractFloatList) {
        int n;
        if (abstractFloatList.size() == 0) {
            return false;
        }
        int n2 = abstractFloatList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractFloatList.indexOfFromTo(this.getQuick(n), 0, n2) >= 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractFloatList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractFloatList abstractFloatList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractFloatList.checkRangeFromTo(n, n2, this.size());
            AbstractFloatList.checkRangeFromTo(n3, n3 + n4 - 1, abstractFloatList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractFloatList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractFloatList.getQuick(n5--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int n, int n2, AbstractFloatList abstractFloatList, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException("otherFrom: " + n3 + ", otherTo: " + n4);
        }
        if (this == abstractFloatList && n2 - n != n4 - n3) {
            this.replaceFromToWithFromTo(n, n2, this.partFromTo(n3, n4), 0, n4 - n3);
            return;
        }
        int n6 = n5 = n4 - n3 + 1;
        int n7 = n - 1;
        if (n2 >= n) {
            n6 -= n2 - n + 1;
            n7 = n2;
        }
        if (n6 > 0) {
            this.beforeInsertDummies(n7 + 1, n6);
        } else if (n6 < 0) {
            this.removeFromTo(n7 + n6, n7 - 1);
        }
        if (n5 > 0) {
            this.replaceFromToWithFrom(n, n + n5 - 1, abstractFloatList, n3);
        }
    }

    public void replaceFromWith(int n, Collection collection) {
        AbstractFloatList.checkRange(n, this.size());
        Iterator iterator = collection.iterator();
        int n2 = n;
        int n3 = Math.min(this.size() - n, collection.size());
        for (int i = 0; i < n3; ++i) {
            this.set(n2++, ((Number)iterator.next()).floatValue());
        }
    }

    public boolean retainAll(AbstractFloatList abstractFloatList) {
        int n;
        if (abstractFloatList.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int n2 = abstractFloatList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractFloatList.indexOfFromTo(this.getQuick(n), 0, n2) < 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void reverse() {
        int n = this.size() / 2;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 < n) {
            float f2 = this.getQuick(n3);
            this.setQuick(n3++, this.getQuick(n2));
            this.setQuick(n2--, f2);
        }
    }

    public void set(int n, float f2) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.setQuick(n, f2);
    }

    protected abstract void setQuick(int var1, float var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public void shuffleFromTo(int n, int n2) {
        AbstractFloatList.checkRangeFromTo(n, n2, this.size());
        Uniform uniform = new Uniform(new DRand(new Date()));
        for (int i = n; i < n2; ++i) {
            int n3 = uniform.nextIntFromTo(i, n2);
            float f2 = this.getQuick(n3);
            this.setQuick(n3, this.getQuick(i));
            this.setQuick(i, f2);
        }
    }

    public int size() {
        return this.size;
    }

    public AbstractFloatList times(int n) {
        FloatArrayList floatArrayList = new FloatArrayList(n * this.size());
        int n2 = n;
        while (--n2 >= 0) {
            floatArrayList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return floatArrayList;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Float(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

