/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.function.Double27Function;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.DoubleProcedure;
import cern.colt.function.IntIntIntProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix2DProcedure;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.AbstractMatrix3D;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;

public abstract class DoubleMatrix3D
extends AbstractMatrix3D {
    protected DoubleMatrix3D() {
    }

    public double aggregate(DoubleDoubleFunction doubleDoubleFunction, DoubleFunction doubleFunction) {
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d2 = doubleFunction.apply(this.getQuick(this.slices - 1, this.rows - 1, this.columns - 1));
        int n = 1;
        int n2 = this.slices;
        while (--n2 >= 0) {
            int n3 = this.rows;
            while (--n3 >= 0) {
                int n4 = this.columns - n;
                while (--n4 >= 0) {
                    d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(this.getQuick(n2, n3, n4)));
                }
                n = 0;
            }
        }
        return d2;
    }

    public double aggregate(DoubleMatrix3D doubleMatrix3D, DoubleDoubleFunction doubleDoubleFunction, DoubleDoubleFunction doubleDoubleFunction2) {
        this.checkShape(doubleMatrix3D);
        if (this.size() == 0) {
            return Double.NaN;
        }
        double d2 = doubleDoubleFunction2.apply(this.getQuick(this.slices - 1, this.rows - 1, this.columns - 1), doubleMatrix3D.getQuick(this.slices - 1, this.rows - 1, this.columns - 1));
        int n = 1;
        int n2 = this.slices;
        while (--n2 >= 0) {
            int n3 = this.rows;
            while (--n3 >= 0) {
                int n4 = this.columns - n;
                while (--n4 >= 0) {
                    d2 = doubleDoubleFunction.apply(d2, doubleDoubleFunction2.apply(this.getQuick(n2, n3, n4), doubleMatrix3D.getQuick(n2, n3, n4)));
                }
                n = 0;
            }
        }
        return d2;
    }

    public DoubleMatrix3D assign(double[][][] dArray) {
        if (dArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + dArray.length + "slices()=" + this.slices());
        }
        int n = this.slices;
        while (--n >= 0) {
            double[][] dArray2 = dArray[n];
            if (dArray2.length != this.rows) {
                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray2.length + "rows()=" + this.rows());
            }
            int n2 = this.rows;
            while (--n2 >= 0) {
                double[] dArray3 = dArray2[n2];
                if (dArray3.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray3.length + "columns()=" + this.columns());
                }
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, dArray3[n3]);
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(double d2) {
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, d2);
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleFunction doubleFunction) {
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, doubleFunction.apply(this.getQuick(n, n2, n3)));
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D == this) {
            return this;
        }
        this.checkShape(doubleMatrix3D);
        if (this.haveSharedCells(doubleMatrix3D)) {
            doubleMatrix3D = doubleMatrix3D.copy();
        }
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, doubleMatrix3D.getQuick(n, n2, n3));
                }
            }
        }
        return this;
    }

    public DoubleMatrix3D assign(DoubleMatrix3D doubleMatrix3D, DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix3D);
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    this.setQuick(n, n2, n3, doubleDoubleFunction.apply(this.getQuick(n, n2, n3), doubleMatrix3D.getQuick(n, n2, n3)));
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = this.slices;
        while (--n2 >= 0) {
            int n3 = this.rows;
            while (--n3 >= 0) {
                int n4 = this.columns;
                while (--n4 >= 0) {
                    if (this.getQuick(n2, n3, n4) == 0.0) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public DoubleMatrix3D copy() {
        return this.like().assign(this);
    }

    public boolean equals(double d2) {
        return Property.DEFAULT.equals(this, d2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DoubleMatrix3D)) {
            return false;
        }
        return Property.DEFAULT.equals(this, (DoubleMatrix3D)object);
    }

    public double get(int n, int n2, int n3) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        return this.getQuick(n, n2, n3);
    }

    protected DoubleMatrix3D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        doubleArrayList.clear();
        int n = this.slices;
        int n2 = this.rows;
        int n3 = this.columns;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    double d2 = this.getQuick(i, j, k);
                    if (d2 == 0.0) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    doubleArrayList.add(d2);
                }
            }
        }
    }

    public abstract double getQuick(int var1, int var2, int var3);

    protected boolean haveSharedCells(DoubleMatrix3D doubleMatrix3D) {
        if (doubleMatrix3D == null) {
            return false;
        }
        if (this == doubleMatrix3D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(doubleMatrix3D.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix3D doubleMatrix3D) {
        return false;
    }

    public DoubleMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract DoubleMatrix3D like(int var1, int var2, int var3);

    protected abstract DoubleMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    public void set(int n, int n2, int n3, double d2) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, d2);
    }

    public abstract void setQuick(int var1, int var2, int var3, double var4);

    public double[][][] toArray() {
        double[][][] dArray = new double[this.slices][this.rows][this.columns];
        int n = this.slices;
        while (--n >= 0) {
            double[][] dArray2 = dArray[n];
            int n2 = this.rows;
            while (--n2 >= 0) {
                double[] dArray3 = dArray2[n2];
                int n3 = this.columns;
                while (--n3 >= 0) {
                    dArray3[n3] = this.getQuick(n, n2, n3);
                }
            }
        }
        return dArray;
    }

    public String toString() {
        return new Formatter().toString(this);
    }

    protected DoubleMatrix3D view() {
        return (DoubleMatrix3D)this.clone();
    }

    public DoubleMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero + this._columnOffset(this._columnRank(n));
        int n6 = this.sliceStride;
        int n7 = this.rowStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public DoubleMatrix3D viewColumnFlip() {
        return (DoubleMatrix3D)this.view().vColumnFlip();
    }

    public DoubleMatrix3D viewDice(int n, int n2, int n3) {
        return (DoubleMatrix3D)this.view().vDice(n, n2, n3);
    }

    public DoubleMatrix3D viewPart(int n, int n2, int n3, int n4, int n5, int n6) {
        return (DoubleMatrix3D)this.view().vPart(n, n2, n3, n4, n5, n6);
    }

    public DoubleMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero + this._rowOffset(this._rowRank(n));
        int n6 = this.sliceStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public DoubleMatrix3D viewRowFlip() {
        return (DoubleMatrix3D)this.view().vRowFlip();
    }

    public DoubleMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray2.length];
        int[] nArray6 = new int[nArray3.length];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray4[n2] = this._sliceOffset(this._sliceRank(nArray[n2]));
        }
        n2 = nArray2.length;
        while (--n2 >= 0) {
            nArray5[n2] = this._rowOffset(this._rowRank(nArray2[n2]));
        }
        n2 = nArray3.length;
        while (--n2 >= 0) {
            nArray6[n2] = this._columnOffset(this._columnRank(nArray3[n2]));
        }
        return this.viewSelectionLike(nArray4, nArray5, nArray6);
    }

    public DoubleMatrix3D viewSelection(DoubleMatrix2DProcedure doubleMatrix2DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!doubleMatrix2DProcedure.apply(this.viewSlice(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null, null);
    }

    protected abstract DoubleMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public DoubleMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero + this._sliceOffset(this._sliceRank(n));
        int n6 = this.rowStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public DoubleMatrix3D viewSliceFlip() {
        return (DoubleMatrix3D)this.view().vSliceFlip();
    }

    public DoubleMatrix3D viewSorted(int n, int n2) {
        return Sorting.mergeSort.sort(this, n, n2);
    }

    public DoubleMatrix3D viewStrides(int n, int n2, int n3) {
        return (DoubleMatrix3D)this.view().vStrides(n, n2, n3);
    }

    private boolean xforEach(DoubleProcedure doubleProcedure) {
        int n = this.slices;
        while (--n >= 0) {
            int n2 = this.rows;
            while (--n2 >= 0) {
                int n3 = this.columns;
                while (--n3 >= 0) {
                    if (doubleProcedure.apply(this.getQuick(n, n2, n3))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean xforEachCoordinate(IntIntIntProcedure intIntIntProcedure) {
        int n = this.columns;
        while (--n >= 0) {
            int n2 = this.slices;
            while (--n2 >= 0) {
                int n3 = this.rows;
                while (--n3 >= 0) {
                    if (intIntIntProcedure.apply(n2, n3, n)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void zAssign27Neighbors(DoubleMatrix3D doubleMatrix3D, Double27Function double27Function) {
        if (double27Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(doubleMatrix3D);
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        for (int i = 1; i < this.slices - 1; ++i) {
            for (int j = 1; j < n; ++j) {
                double d2 = this.getQuick(i - 1, j - 1, 0);
                double d3 = this.getQuick(i - 1, j - 1, 1);
                double d4 = this.getQuick(i - 1, j, 0);
                double d5 = this.getQuick(i - 1, j, 1);
                double d6 = this.getQuick(i - 1, j + 1, 0);
                double d7 = this.getQuick(i - 1, j + 1, 1);
                double d8 = this.getQuick(i - 1, j - 1, 0);
                double d9 = this.getQuick(i, j - 1, 1);
                double d10 = this.getQuick(i, j, 0);
                double d11 = this.getQuick(i, j, 1);
                double d12 = this.getQuick(i, j + 1, 0);
                double d13 = this.getQuick(i, j + 1, 1);
                double d14 = this.getQuick(i + 1, j - 1, 0);
                double d15 = this.getQuick(i + 1, j - 1, 1);
                double d16 = this.getQuick(i + 1, j, 0);
                double d17 = this.getQuick(i + 1, j, 1);
                double d18 = this.getQuick(i + 1, j + 1, 0);
                double d19 = this.getQuick(i + 1, j + 1, 1);
                for (int k = 1; k < n2; ++k) {
                    double d20 = this.getQuick(i - 1, j - 1, k + 1);
                    double d21 = this.getQuick(i - 1, j, k + 1);
                    double d22 = this.getQuick(i - 1, j + 1, k + 1);
                    double d23 = this.getQuick(i, j - 1, k + 1);
                    double d24 = this.getQuick(i, j, k + 1);
                    double d25 = this.getQuick(i, j + 1, k + 1);
                    double d26 = this.getQuick(i + 1, j - 1, k + 1);
                    double d27 = this.getQuick(i + 1, j, k + 1);
                    double d28 = this.getQuick(i + 1, j + 1, k + 1);
                    doubleMatrix3D.setQuick(i, j, k, double27Function.apply(d2, d3, d20, d4, d5, d21, d6, d7, d22, d8, d9, d23, d10, d11, d24, d12, d13, d25, d14, d15, d26, d16, d17, d27, d18, d19, d28));
                    d2 = d3;
                    d3 = d20;
                    d4 = d5;
                    d5 = d21;
                    d6 = d7;
                    d7 = d22;
                    d8 = d9;
                    d9 = d23;
                    d10 = d11;
                    d11 = d24;
                    d12 = d13;
                    d13 = d25;
                    d14 = d15;
                    d15 = d26;
                    d16 = d17;
                    d17 = d27;
                    d18 = d19;
                    d19 = d28;
                }
            }
        }
    }

    public double zSum() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.aggregate(Functions.plus, Functions.identity);
    }
}

