/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import java.io.Serializable;

public class SingularValueDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;

    public SingularValueDecomposition(DoubleMatrix2D doubleMatrix2D) {
        int n;
        double d2;
        int n2;
        int n3;
        Property.DEFAULT.checkRectangular(doubleMatrix2D);
        double[][] dArray = doubleMatrix2D.toArray();
        this.m = doubleMatrix2D.rows();
        this.n = doubleMatrix2D.columns();
        int n4 = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][n4];
        this.V = new double[this.n][this.n];
        double[] dArray2 = new double[this.n];
        double[] dArray3 = new double[this.m];
        boolean bl = true;
        boolean bl2 = true;
        int n5 = Math.min(this.m - 1, this.n);
        int n6 = Math.max(0, Math.min(this.n - 2, this.m));
        for (n3 = 0; n3 < Math.max(n5, n6); ++n3) {
            int n7;
            if (n3 < n5) {
                this.s[n3] = 0.0;
                for (n2 = n3; n2 < this.m; ++n2) {
                    this.s[n3] = Algebra.hypot(this.s[n3], dArray[n2][n3]);
                }
                if (this.s[n3] != 0.0) {
                    if (dArray[n3][n3] < 0.0) {
                        this.s[n3] = -this.s[n3];
                    }
                    for (n2 = n3; n2 < this.m; ++n2) {
                        double[] dArray4 = dArray[n2];
                        int n8 = n3;
                        dArray4[n8] = dArray4[n8] / this.s[n3];
                    }
                    double[] dArray5 = dArray[n3];
                    int n9 = n3;
                    dArray5[n9] = dArray5[n9] + 1.0;
                }
                this.s[n3] = -this.s[n3];
            }
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                if (n3 < n5 & this.s[n3] != 0.0) {
                    double d3 = 0.0;
                    for (n7 = n3; n7 < this.m; ++n7) {
                        d3 += dArray[n7][n3] * dArray[n7][n2];
                    }
                    d3 = -d3 / dArray[n3][n3];
                    for (n7 = n3; n7 < this.m; ++n7) {
                        double[] dArray6 = dArray[n7];
                        int n10 = n2;
                        dArray6[n10] = dArray6[n10] + d3 * dArray[n7][n3];
                    }
                }
                dArray2[n2] = dArray[n3][n2];
            }
            if (bl & n3 < n5) {
                for (n2 = n3; n2 < this.m; ++n2) {
                    this.U[n2][n3] = dArray[n2][n3];
                }
            }
            if (n3 >= n6) continue;
            dArray2[n3] = 0.0;
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                dArray2[n3] = Algebra.hypot(dArray2[n3], dArray2[n2]);
            }
            if (dArray2[n3] != 0.0) {
                if (dArray2[n3 + 1] < 0.0) {
                    dArray2[n3] = -dArray2[n3];
                }
                n2 = n3 + 1;
                while (n2 < this.n) {
                    int n11 = n2++;
                    dArray2[n11] = dArray2[n11] / dArray2[n3];
                }
                int n12 = n3 + 1;
                dArray2[n12] = dArray2[n12] + 1.0;
            }
            dArray2[n3] = -dArray2[n3];
            if (n3 + 1 < this.m & dArray2[n3] != 0.0) {
                for (n2 = n3 + 1; n2 < this.m; ++n2) {
                    dArray3[n2] = 0.0;
                }
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    for (int i = n3 + 1; i < this.m; ++i) {
                        int n13 = i;
                        dArray3[n13] = dArray3[n13] + dArray2[n2] * dArray[i][n2];
                    }
                }
                for (n2 = n3 + 1; n2 < this.n; ++n2) {
                    double d4 = -dArray2[n2] / dArray2[n3 + 1];
                    for (n7 = n3 + 1; n7 < this.m; ++n7) {
                        double[] dArray7 = dArray[n7];
                        int n14 = n2;
                        dArray7[n14] = dArray7[n14] + d4 * dArray3[n7];
                    }
                }
            }
            if (!bl2) continue;
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                this.V[n2][n3] = dArray2[n2];
            }
        }
        n3 = Math.min(this.n, this.m + 1);
        if (n5 < this.n) {
            this.s[n5] = dArray[n5][n5];
        }
        if (this.m < n3) {
            this.s[n3 - 1] = 0.0;
        }
        if (n6 + 1 < n3) {
            dArray2[n6] = dArray[n6][n3 - 1];
        }
        dArray2[n3 - 1] = 0.0;
        if (bl) {
            for (n2 = n5; n2 < n4; ++n2) {
                for (int i = 0; i < this.m; ++i) {
                    this.U[i][n2] = 0.0;
                }
                this.U[n2][n2] = 1.0;
            }
            for (n2 = n5 - 1; n2 >= 0; --n2) {
                int n15;
                if (this.s[n2] != 0.0) {
                    for (n15 = n2 + 1; n15 < n4; ++n15) {
                        d2 = 0.0;
                        for (n = n2; n < this.m; ++n) {
                            d2 += this.U[n][n2] * this.U[n][n15];
                        }
                        d2 = -d2 / this.U[n2][n2];
                        for (n = n2; n < this.m; ++n) {
                            double[] dArray8 = this.U[n];
                            int n16 = n15;
                            dArray8[n16] = dArray8[n16] + d2 * this.U[n][n2];
                        }
                    }
                    for (n15 = n2; n15 < this.m; ++n15) {
                        this.U[n15][n2] = -this.U[n15][n2];
                    }
                    this.U[n2][n2] = 1.0 + this.U[n2][n2];
                    for (n15 = 0; n15 < n2 - 1; ++n15) {
                        this.U[n15][n2] = 0.0;
                    }
                    continue;
                }
                for (n15 = 0; n15 < this.m; ++n15) {
                    this.U[n15][n2] = 0.0;
                }
                this.U[n2][n2] = 1.0;
            }
        }
        if (bl2) {
            for (n2 = this.n - 1; n2 >= 0; --n2) {
                int n17;
                if (n2 < n6 & dArray2[n2] != 0.0) {
                    for (n17 = n2 + 1; n17 < n4; ++n17) {
                        d2 = 0.0;
                        for (n = n2 + 1; n < this.n; ++n) {
                            d2 += this.V[n][n2] * this.V[n][n17];
                        }
                        d2 = -d2 / this.V[n2 + 1][n2];
                        for (n = n2 + 1; n < this.n; ++n) {
                            double[] dArray9 = this.V[n];
                            int n18 = n17;
                            dArray9[n18] = dArray9[n18] + d2 * this.V[n][n2];
                        }
                    }
                }
                for (n17 = 0; n17 < this.n; ++n17) {
                    this.V[n17][n2] = 0.0;
                }
                this.V[n2][n2] = 1.0;
            }
        }
        n2 = n3 - 1;
        int n19 = 0;
        d2 = Math.pow(2.0, -52.0);
        while (n3 > 0) {
            int n20;
            int n21;
            for (n = n3 - 2; n >= -1 && n != -1; --n) {
                if (!(Math.abs(dArray2[n]) <= d2 * (Math.abs(this.s[n]) + Math.abs(this.s[n + 1])))) continue;
                dArray2[n] = 0.0;
                break;
            }
            if (n == n3 - 2) {
                n21 = 4;
            } else {
                for (n20 = n3 - 1; n20 >= n && n20 != n; --n20) {
                    double d5 = (n20 != n3 ? Math.abs(dArray2[n20]) : 0.0) + (n20 != n + 1 ? Math.abs(dArray2[n20 - 1]) : 0.0);
                    if (!(Math.abs(this.s[n20]) <= d2 * d5)) continue;
                    this.s[n20] = 0.0;
                    break;
                }
                if (n20 == n) {
                    n21 = 3;
                } else if (n20 == n3 - 1) {
                    n21 = 1;
                } else {
                    n21 = 2;
                    n = n20;
                }
            }
            ++n;
            switch (n21) {
                case 1: {
                    int n22;
                    double d6;
                    double d7;
                    double d8;
                    double d9 = dArray2[n3 - 2];
                    dArray2[n3 - 2] = 0.0;
                    for (int i = n3 - 2; i >= n; --i) {
                        d8 = Algebra.hypot(this.s[i], d9);
                        d7 = this.s[i] / d8;
                        d6 = d9 / d8;
                        this.s[i] = d8;
                        if (i != n) {
                            d9 = -d6 * dArray2[i - 1];
                            dArray2[i - 1] = d7 * dArray2[i - 1];
                        }
                        if (!bl2) continue;
                        for (n22 = 0; n22 < this.n; ++n22) {
                            d8 = d7 * this.V[n22][i] + d6 * this.V[n22][n3 - 1];
                            this.V[n22][n3 - 1] = -d6 * this.V[n22][i] + d7 * this.V[n22][n3 - 1];
                            this.V[n22][i] = d8;
                        }
                    }
                    break;
                }
                case 2: {
                    int n22;
                    double d6;
                    double d7;
                    double d8;
                    double d10 = dArray2[n - 1];
                    dArray2[n - 1] = 0.0;
                    for (int i = n; i < n3; ++i) {
                        d8 = Algebra.hypot(this.s[i], d10);
                        d7 = this.s[i] / d8;
                        d6 = d10 / d8;
                        this.s[i] = d8;
                        d10 = -d6 * dArray2[i];
                        dArray2[i] = d7 * dArray2[i];
                        if (!bl) continue;
                        for (n22 = 0; n22 < this.m; ++n22) {
                            d8 = d7 * this.U[n22][i] + d6 * this.U[n22][n - 1];
                            this.U[n22][n - 1] = -d6 * this.U[n22][i] + d7 * this.U[n22][n - 1];
                            this.U[n22][i] = d8;
                        }
                    }
                    break;
                }
                case 3: {
                    double d11 = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[n3 - 1]), Math.abs(this.s[n3 - 2])), Math.abs(dArray2[n3 - 2])), Math.abs(this.s[n])), Math.abs(dArray2[n]));
                    double d12 = this.s[n3 - 1] / d11;
                    double d13 = this.s[n3 - 2] / d11;
                    double d14 = dArray2[n3 - 2] / d11;
                    double d15 = this.s[n] / d11;
                    double d16 = dArray2[n] / d11;
                    double d17 = ((d13 + d12) * (d13 - d12) + d14 * d14) / 2.0;
                    double d18 = d12 * d14 * (d12 * d14);
                    double d19 = 0.0;
                    if (d17 != 0.0 | d18 != 0.0) {
                        d19 = Math.sqrt(d17 * d17 + d18);
                        if (d17 < 0.0) {
                            d19 = -d19;
                        }
                        d19 = d18 / (d17 + d19);
                    }
                    double d20 = (d15 + d12) * (d15 - d12) + d19;
                    double d21 = d15 * d16;
                    for (int i = n; i < n3 - 1; ++i) {
                        int n23;
                        double d22 = Algebra.hypot(d20, d21);
                        double d23 = d20 / d22;
                        double d24 = d21 / d22;
                        if (i != n) {
                            dArray2[i - 1] = d22;
                        }
                        d20 = d23 * this.s[i] + d24 * dArray2[i];
                        dArray2[i] = d23 * dArray2[i] - d24 * this.s[i];
                        d21 = d24 * this.s[i + 1];
                        this.s[i + 1] = d23 * this.s[i + 1];
                        if (bl2) {
                            for (n23 = 0; n23 < this.n; ++n23) {
                                d22 = d23 * this.V[n23][i] + d24 * this.V[n23][i + 1];
                                this.V[n23][i + 1] = -d24 * this.V[n23][i] + d23 * this.V[n23][i + 1];
                                this.V[n23][i] = d22;
                            }
                        }
                        d22 = Algebra.hypot(d20, d21);
                        d23 = d20 / d22;
                        d24 = d21 / d22;
                        this.s[i] = d22;
                        d20 = d23 * dArray2[i] + d24 * this.s[i + 1];
                        this.s[i + 1] = -d24 * dArray2[i] + d23 * this.s[i + 1];
                        d21 = d24 * dArray2[i + 1];
                        dArray2[i + 1] = d23 * dArray2[i + 1];
                        if (!bl || i >= this.m - 1) continue;
                        for (n23 = 0; n23 < this.m; ++n23) {
                            d22 = d23 * this.U[n23][i] + d24 * this.U[n23][i + 1];
                            this.U[n23][i + 1] = -d24 * this.U[n23][i] + d23 * this.U[n23][i + 1];
                            this.U[n23][i] = d22;
                        }
                    }
                    dArray2[n3 - 2] = d20;
                    ++n19;
                    break;
                }
                case 4: {
                    if (this.s[n] <= 0.0) {
                        double d25 = this.s[n] = this.s[n] < 0.0 ? -this.s[n] : 0.0;
                        if (bl2) {
                            for (n20 = 0; n20 <= n2; ++n20) {
                                this.V[n20][n] = -this.V[n20][n];
                            }
                        }
                    }
                    while (n < n2 && !(this.s[n] >= this.s[n + 1])) {
                        int n24;
                        double d26 = this.s[n];
                        this.s[n] = this.s[n + 1];
                        this.s[n + 1] = d26;
                        if (bl2 && n < this.n - 1) {
                            for (n24 = 0; n24 < this.n; ++n24) {
                                d26 = this.V[n24][n + 1];
                                this.V[n24][n + 1] = this.V[n24][n];
                                this.V[n24][n] = d26;
                            }
                        }
                        if (bl && n < this.m - 1) {
                            for (n24 = 0; n24 < this.m; ++n24) {
                                d26 = this.U[n24][n + 1];
                                this.U[n24][n + 1] = this.U[n24][n];
                                this.U[n24][n] = d26;
                            }
                        }
                        ++n;
                    }
                    n19 = 0;
                    --n3;
                }
            }
        }
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public DoubleMatrix2D getS() {
        double[][] dArray = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = 0.0;
            }
            dArray[i][i] = this.s[i];
        }
        return DoubleFactory2D.dense.make(dArray);
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public DoubleMatrix2D getU() {
        return DoubleFactory2D.dense.make(this.U).viewPart(0, 0, this.m, Math.min(this.m + 1, this.n));
    }

    public DoubleMatrix2D getV() {
        return DoubleFactory2D.dense.make(this.V);
    }

    public double norm2() {
        return this.s[0];
    }

    public int rank() {
        double d2 = Math.pow(2.0, -52.0);
        double d3 = (double)Math.max(this.m, this.n) * this.s[0] * d2;
        int n = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > d3)) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("cond = ");
        try {
            stringBuffer.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nrank = ");
        try {
            stringBuffer.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nnorm2 = ");
        try {
            stringBuffer.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nS = ");
        try {
            stringBuffer.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nV = ");
        try {
            stringBuffer.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

