/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math;

import cern.colt.Timer;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleDoubleProcedure;
import cern.colt.function.DoubleFunction;
import cern.colt.function.DoubleProcedure;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;
import cern.jet.random.engine.MersenneTwister;
import java.util.Date;

public class Functions {
    public static final Functions functions = new Functions();
    public static final DoubleFunction abs = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.abs(d2);
        }
    };
    public static final DoubleFunction acos = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.acos(d2);
        }
    };
    public static final DoubleFunction asin = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.asin(d2);
        }
    };
    public static final DoubleFunction atan = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.atan(d2);
        }
    };
    public static final DoubleFunction ceil = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.ceil(d2);
        }
    };
    public static final DoubleFunction cos = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.cos(d2);
        }
    };
    public static final DoubleFunction exp = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.exp(d2);
        }
    };
    public static final DoubleFunction floor = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.floor(d2);
        }
    };
    public static final DoubleFunction identity = new DoubleFunction(){

        public final double apply(double d2) {
            return d2;
        }
    };
    public static final DoubleFunction inv = new DoubleFunction(){

        public final double apply(double d2) {
            return 1.0 / d2;
        }
    };
    public static final DoubleFunction log = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.log(d2);
        }
    };
    public static final DoubleFunction log2 = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.log(d2) * 1.4426950408889634;
        }
    };
    public static final DoubleFunction neg = new DoubleFunction(){

        public final double apply(double d2) {
            return -d2;
        }
    };
    public static final DoubleFunction rint = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.rint(d2);
        }
    };
    public static final DoubleFunction sign = new DoubleFunction(){

        public final double apply(double d2) {
            return d2 < 0.0 ? -1.0 : (d2 > 0.0 ? 1.0 : 0.0);
        }
    };
    public static final DoubleFunction sin = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.sin(d2);
        }
    };
    public static final DoubleFunction sqrt = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.sqrt(d2);
        }
    };
    public static final DoubleFunction square = new DoubleFunction(){

        public final double apply(double d2) {
            return d2 * d2;
        }
    };
    public static final DoubleFunction tan = new DoubleFunction(){

        public final double apply(double d2) {
            return Math.tan(d2);
        }
    };
    public static final DoubleDoubleFunction atan2 = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return Math.atan2(d2, d3);
        }
    };
    public static final DoubleDoubleFunction compare = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return d2 < d3 ? -1.0 : (d2 > d3 ? 1.0 : 0.0);
        }
    };
    public static final DoubleDoubleFunction div = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return d2 / d3;
        }
    };
    public static final DoubleDoubleFunction equals = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return d2 == d3 ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction greater = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return d2 > d3 ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction IEEEremainder = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return Math.IEEEremainder(d2, d3);
        }
    };
    public static final DoubleDoubleProcedure isEqual = new DoubleDoubleProcedure(){

        public final boolean apply(double d2, double d3) {
            return d2 == d3;
        }
    };
    public static final DoubleDoubleProcedure isLess = new DoubleDoubleProcedure(){

        public final boolean apply(double d2, double d3) {
            return d2 < d3;
        }
    };
    public static final DoubleDoubleProcedure isGreater = new DoubleDoubleProcedure(){

        public final boolean apply(double d2, double d3) {
            return d2 > d3;
        }
    };
    public static final DoubleDoubleFunction less = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return d2 < d3 ? 1.0 : 0.0;
        }
    };
    public static final DoubleDoubleFunction lg = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return Math.log(d2) / Math.log(d3);
        }
    };
    public static final DoubleDoubleFunction max = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return Math.max(d2, d3);
        }
    };
    public static final DoubleDoubleFunction min = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return Math.min(d2, d3);
        }
    };
    public static final DoubleDoubleFunction minus = Functions.plusMult(-1.0);
    public static final DoubleDoubleFunction mod = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return d2 % d3;
        }
    };
    public static final DoubleDoubleFunction mult = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return d2 * d3;
        }
    };
    public static final DoubleDoubleFunction plus = Functions.plusMult(1.0);
    public static final DoubleDoubleFunction plusAbs = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return Math.abs(d2) + Math.abs(d3);
        }
    };
    public static final DoubleDoubleFunction pow = new DoubleDoubleFunction(){

        public final double apply(double d2, double d3) {
            return Math.pow(d2, d3);
        }
    };

    protected Functions() {
    }

    public static DoubleFunction between(final double d2, final double d3) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return d2 <= d22 && d22 <= d3 ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction bindArg1(final DoubleDoubleFunction doubleDoubleFunction, final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return doubleDoubleFunction.apply(d2, d22);
            }
        };
    }

    public static DoubleFunction bindArg2(final DoubleDoubleFunction doubleDoubleFunction, final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return doubleDoubleFunction.apply(d22, d2);
            }
        };
    }

    public static DoubleDoubleFunction chain(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, final DoubleFunction doubleFunction2) {
        return new DoubleDoubleFunction(){

            public final double apply(double d2, double d3) {
                return doubleDoubleFunction.apply(doubleFunction.apply(d2), doubleFunction2.apply(d3));
            }
        };
    }

    public static DoubleDoubleFunction chain(final DoubleFunction doubleFunction, final DoubleDoubleFunction doubleDoubleFunction) {
        return new DoubleDoubleFunction(){

            public final double apply(double d2, double d3) {
                return doubleFunction.apply(doubleDoubleFunction.apply(d2, d3));
            }
        };
    }

    public static DoubleFunction chain(final DoubleFunction doubleFunction, final DoubleFunction doubleFunction2) {
        return new DoubleFunction(){

            public final double apply(double d2) {
                return doubleFunction.apply(doubleFunction2.apply(d2));
            }
        };
    }

    public static DoubleFunction compare(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return d22 < d2 ? -1.0 : (d22 > d2 ? 1.0 : 0.0);
            }
        };
    }

    public static DoubleFunction constant(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return d2;
            }
        };
    }

    public static void demo1() {
        Functions functions = Functions.functions;
        double d2 = 0.5;
        double d3 = 0.2;
        double d4 = Math.sin(d2) + Math.pow(Math.cos(d3), 2.0);
        System.out.println(d4);
        DoubleDoubleFunction doubleDoubleFunction = Functions.chain(plus, sin, Functions.chain(square, cos));
        System.out.println(doubleDoubleFunction.apply(d2, d3));
        DoubleDoubleFunction doubleDoubleFunction2 = new DoubleDoubleFunction(){

            public final double apply(double d2, double d3) {
                return Math.sin(d2) + Math.pow(Math.cos(d3), 2.0);
            }
        };
        System.out.println(doubleDoubleFunction2.apply(d2, d3));
        DoubleFunction doubleFunction = Functions.plus(3.0);
        DoubleFunction doubleFunction2 = Functions.plus(4.0);
        System.out.println(doubleFunction.apply(0.0));
        System.out.println(doubleFunction2.apply(0.0));
    }

    public static void demo2(int n) {
        Functions functions = Functions.functions;
        System.out.println("\n\n");
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Math.abs(Math.sin(d2) + Math.pow(Math.cos(d3), 2.0));
        System.out.println(d4);
        DoubleDoubleFunction doubleDoubleFunction = Functions.chain(abs, Functions.chain(plus, sin, Functions.chain(square, cos)));
        System.out.println(doubleDoubleFunction.apply(d2, d3));
        DoubleDoubleFunction doubleDoubleFunction2 = new DoubleDoubleFunction(){

            public final double apply(double d2, double d3) {
                return Math.abs(Math.sin(d2) + Math.pow(Math.cos(d3), 2.0));
            }
        };
        System.out.println(doubleDoubleFunction2.apply(d2, d3));
        Timer timer = new Timer().start();
        d2 = 0.0;
        d3 = 0.0;
        double d5 = 0.0;
        int n2 = n;
        while (--n2 >= 0) {
            d5 += d2;
            d2 += 1.0;
            d3 += 1.0;
        }
        timer.stop().display();
        System.out.println("empty sum=" + d5);
        Timer timer2 = new Timer().start();
        d2 = 0.0;
        d3 = 0.0;
        d5 = 0.0;
        int n3 = n;
        while (--n3 >= 0) {
            d5 += Math.abs(Math.sin(d2) + Math.pow(Math.cos(d3), 2.0));
            d2 += 1.0;
            d3 += 1.0;
        }
        timer2.stop().display();
        System.out.println("evals / sec = " + (float)n / timer2.minus(timer).seconds());
        System.out.println("sum=" + d5);
        timer2.reset().start();
        d2 = 0.0;
        d3 = 0.0;
        d5 = 0.0;
        n3 = n;
        while (--n3 >= 0) {
            d5 += doubleDoubleFunction.apply(d2, d3);
            d2 += 1.0;
            d3 += 1.0;
        }
        timer2.stop().display();
        System.out.println("evals / sec = " + (float)n / timer2.minus(timer).seconds());
        System.out.println("sum=" + d5);
        timer2.reset().start();
        d2 = 0.0;
        d3 = 0.0;
        d5 = 0.0;
        n3 = n;
        while (--n3 >= 0) {
            d5 += doubleDoubleFunction2.apply(d2, d3);
            d2 += 1.0;
            d3 += 1.0;
        }
        timer2.stop().display();
        System.out.println("evals / sec = " + (float)n / timer2.minus(timer).seconds());
        System.out.println("sum=" + d5);
    }

    public static DoubleFunction div(double d2) {
        return Functions.mult(1.0 / d2);
    }

    public static DoubleFunction equals(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return d22 == d2 ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction greater(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return d22 > d2 ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction IEEEremainder(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return Math.IEEEremainder(d22, d2);
            }
        };
    }

    public static DoubleProcedure isBetween(final double d2, final double d3) {
        return new DoubleProcedure(){

            public final boolean apply(double d22) {
                return d2 <= d22 && d22 <= d3;
            }
        };
    }

    public static DoubleProcedure isEqual(final double d2) {
        return new DoubleProcedure(){

            public final boolean apply(double d22) {
                return d22 == d2;
            }
        };
    }

    public static DoubleProcedure isGreater(final double d2) {
        return new DoubleProcedure(){

            public final boolean apply(double d22) {
                return d22 > d2;
            }
        };
    }

    public static DoubleProcedure isLess(final double d2) {
        return new DoubleProcedure(){

            public final boolean apply(double d22) {
                return d22 < d2;
            }
        };
    }

    public static DoubleFunction less(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return d22 < d2 ? 1.0 : 0.0;
            }
        };
    }

    public static DoubleFunction lg(final double d2) {
        return new DoubleFunction(){
            private final double logInv;
            {
                this.logInv = 1.0 / Math.log(d2);
            }

            public final double apply(double d22) {
                return Math.log(d22) * this.logInv;
            }
        };
    }

    protected static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        Functions.demo2(n);
    }

    public static DoubleFunction max(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return Math.max(d22, d2);
            }
        };
    }

    public static DoubleFunction min(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return Math.min(d22, d2);
            }
        };
    }

    public static DoubleFunction minus(double d2) {
        return Functions.plus(-d2);
    }

    public static DoubleDoubleFunction minusMult(double d2) {
        return Functions.plusMult(-d2);
    }

    public static DoubleFunction mod(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return d22 % d2;
            }
        };
    }

    public static DoubleFunction mult(double d2) {
        return new Mult(d2);
    }

    public static DoubleFunction plus(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return d22 + d2;
            }
        };
    }

    public static DoubleDoubleFunction plusMult(double d2) {
        return new PlusMult(d2);
    }

    public static DoubleFunction pow(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return Math.pow(d22, d2);
            }
        };
    }

    public static DoubleFunction random() {
        return new MersenneTwister(new Date());
    }

    public static DoubleFunction round(final double d2) {
        return new DoubleFunction(){

            public final double apply(double d22) {
                return Math.rint(d22 / d2) * d2;
            }
        };
    }

    public static DoubleDoubleFunction swapArgs(final DoubleDoubleFunction doubleDoubleFunction) {
        return new DoubleDoubleFunction(){

            public final double apply(double d2, double d3) {
                return doubleDoubleFunction.apply(d3, d2);
            }
        };
    }
}

