/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.engine.RandomEngine;

public class Empirical
extends AbstractContinousDistribution {
    protected double[] cdf;
    protected int interpolationType;
    public static final int LINEAR_INTERPOLATION = 0;
    public static final int NO_INTERPOLATION = 1;

    public Empirical(double[] dArray, int n, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(dArray, n);
    }

    public double cdf(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (n >= this.cdf.length - 1) {
            return 1.0;
        }
        return this.cdf[n];
    }

    public Object clone() {
        Empirical empirical = (Empirical)super.clone();
        if (this.cdf != null) {
            empirical.cdf = (double[])this.cdf.clone();
        }
        return empirical;
    }

    public double nextDouble() {
        double d2 = this.randomGenerator.raw();
        if (this.cdf == null) {
            return d2;
        }
        int n = this.cdf.length - 1;
        int n2 = 0;
        int n3 = n;
        while (n3 > n2 + 1) {
            int n4 = n3 + n2 + 1 >> 1;
            if (d2 >= this.cdf[n4]) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        if (this.interpolationType == 1) {
            return (double)n2 / (double)n;
        }
        if (this.interpolationType == 0) {
            double d3 = this.cdf[n3] - this.cdf[n2];
            if (d3 == 0.0) {
                return ((double)n2 + 0.5) / (double)n;
            }
            double d4 = (d2 - this.cdf[n2]) / d3;
            return ((double)n2 + d4) / (double)n;
        }
        throw new InternalError();
    }

    public double pdf(double d2) {
        throw new RuntimeException("not implemented");
    }

    public double pdf(int n) {
        if (n < 0 || n >= this.cdf.length - 1) {
            return 0.0;
        }
        return this.cdf[n - 1] - this.cdf[n];
    }

    public void setState(double[] dArray, int n) {
        int n2;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal Interpolation Type");
        }
        this.interpolationType = n;
        if (dArray == null || dArray.length == 0) {
            this.cdf = null;
            return;
        }
        int n3 = dArray.length;
        this.cdf = new double[n3 + 1];
        this.cdf[0] = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            double d2 = dArray[n2];
            if (d2 < 0.0) {
                throw new IllegalArgumentException("Negative probability");
            }
            this.cdf[n2 + 1] = this.cdf[n2] + d2;
        }
        if (this.cdf[n3] <= 0.0) {
            throw new IllegalArgumentException("At leat one probability must be > 0.0");
        }
        n2 = 0;
        while (n2 < n3 + 1) {
            int n4 = n2++;
            this.cdf[n4] = this.cdf[n4] / this.cdf[n3];
        }
    }

    public String toString() {
        String string = null;
        if (this.interpolationType == 1) {
            string = "NO_INTERPOLATION";
        }
        if (this.interpolationType == 0) {
            string = "LINEAR_INTERPOLATION";
        }
        return this.getClass().getName() + "(" + (this.cdf != null ? this.cdf.length : 0) + "," + string + ")";
    }

    private int xnBins() {
        return this.cdf.length - 1;
    }
}

