/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;

public class Uniform
extends AbstractContinousDistribution {
    protected double min;
    protected double max;
    protected static Uniform shared = new Uniform(Uniform.makeDefaultGenerator());

    public Uniform(double d2, double d3, int n) {
        this(d2, d3, new MersenneTwister(n));
    }

    public Uniform(double d2, double d3, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d2, d3);
    }

    public Uniform(RandomEngine randomEngine) {
        this(0.0, 1.0, randomEngine);
    }

    public double cdf(double d2) {
        if (d2 <= this.min) {
            return 0.0;
        }
        if (d2 >= this.max) {
            return 1.0;
        }
        return (d2 - this.min) / (this.max - this.min);
    }

    public boolean nextBoolean() {
        return this.randomGenerator.raw() > 0.5;
    }

    public double nextDouble() {
        return this.min + (this.max - this.min) * this.randomGenerator.raw();
    }

    public double nextDoubleFromTo(double d2, double d3) {
        return d2 + (d3 - d2) * this.randomGenerator.raw();
    }

    public float nextFloatFromTo(float f2, float f3) {
        return (float)this.nextDoubleFromTo(f2, f3);
    }

    public int nextInt() {
        return this.nextIntFromTo((int)Math.round(this.min), (int)Math.round(this.max));
    }

    public int nextIntFromTo(int n, int n2) {
        return (int)((long)n + (long)((double)(1L + (long)n2 - (long)n) * this.randomGenerator.raw()));
    }

    public long nextLongFromTo(long l, long l2) {
        long l3;
        if (l >= 0L && l2 < Long.MAX_VALUE) {
            return l + (long)this.nextDoubleFromTo(0.0, l2 - l + 1L);
        }
        double d2 = (double)l2 - (double)l + 1.0;
        if (d2 <= 9.223372036854776E18) {
            return l + (long)this.nextDoubleFromTo(0.0, d2);
        }
        if (l == Long.MIN_VALUE) {
            if (l2 == Long.MAX_VALUE) {
                int n = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                int n2 = this.nextIntFromTo(Integer.MIN_VALUE, Integer.MAX_VALUE);
                return ((long)n & 0xFFFFFFFFL) << 32 | (long)n2 & 0xFFFFFFFFL;
            }
            l3 = Math.round(this.nextDoubleFromTo(l, l2 + 1L));
            if (l3 > l2) {
                l3 = l;
            }
        } else {
            l3 = Math.round(this.nextDoubleFromTo(l - 1L, l2));
            if (l3 < l) {
                l3 = l2;
            }
        }
        return l3;
    }

    public double pdf(double d2) {
        if (d2 <= this.min || d2 >= this.max) {
            return 0.0;
        }
        return 1.0 / (this.max - this.min);
    }

    public void setState(double d2, double d3) {
        if (d3 < d2) {
            this.setState(d3, d2);
            return;
        }
        this.min = d2;
        this.max = d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean staticNextBoolean() {
        Uniform uniform = shared;
        synchronized (uniform) {
            return shared.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble() {
        Uniform uniform = shared;
        synchronized (uniform) {
            return shared.nextDouble();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDoubleFromTo(double d2, double d3) {
        Uniform uniform = shared;
        synchronized (uniform) {
            return shared.nextDoubleFromTo(d2, d3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float staticNextFloatFromTo(float f2, float f3) {
        Uniform uniform = shared;
        synchronized (uniform) {
            return shared.nextFloatFromTo(f2, f3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextIntFromTo(int n, int n2) {
        Uniform uniform = shared;
        synchronized (uniform) {
            return shared.nextIntFromTo(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long staticNextLongFromTo(long l, long l2) {
        Uniform uniform = shared;
        synchronized (uniform) {
            return shared.nextLongFromTo(l, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticSetRandomEngine(RandomEngine randomEngine) {
        Uniform uniform = shared;
        synchronized (uniform) {
            shared.setRandomGenerator(randomEngine);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.min + "," + this.max + ")";
    }
}

