/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.function.DoubleProcedure;
import cern.jet.stat.quantile.BufferSet;
import cern.jet.stat.quantile.DoubleBuffer;

class DoubleBufferSet
extends BufferSet {
    protected DoubleBuffer[] buffers;
    private boolean nextTriggerCalculationState;

    public DoubleBufferSet(int n, int n2) {
        this.buffers = new DoubleBuffer[n];
        this.clear(n2);
    }

    public DoubleBuffer _getFirstEmptyBuffer() {
        DoubleBuffer doubleBuffer = null;
        int n = this.buffers.length;
        while (--n >= 0) {
            if (!this.buffers[n].isEmpty()) continue;
            if (this.buffers[n].isAllocated()) {
                return this.buffers[n];
            }
            doubleBuffer = this.buffers[n];
        }
        return doubleBuffer;
    }

    public DoubleBuffer[] _getFullOrPartialBuffers() {
        int n = 0;
        int n2 = this.buffers.length;
        while (--n2 >= 0) {
            if (this.buffers[n2].isEmpty()) continue;
            ++n;
        }
        DoubleBuffer[] doubleBufferArray = new DoubleBuffer[n];
        int n3 = 0;
        int n4 = this.buffers.length;
        while (--n4 >= 0) {
            if (this.buffers[n4].isEmpty()) continue;
            doubleBufferArray[n3++] = this.buffers[n4];
        }
        return doubleBufferArray;
    }

    public DoubleBuffer[] _getFullOrPartialBuffersWithLevel(int n) {
        int n2 = 0;
        int n3 = this.buffers.length;
        while (--n3 >= 0) {
            if (this.buffers[n3].isEmpty() || this.buffers[n3].level() != n) continue;
            ++n2;
        }
        DoubleBuffer[] doubleBufferArray = new DoubleBuffer[n2];
        int n4 = 0;
        int n5 = this.buffers.length;
        while (--n5 >= 0) {
            if (this.buffers[n5].isEmpty() || this.buffers[n5].level() != n) continue;
            doubleBufferArray[n4++] = this.buffers[n5];
        }
        return doubleBufferArray;
    }

    public int _getMinLevelOfFullOrPartialBuffers() {
        int n = this.b();
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            DoubleBuffer doubleBuffer = this.buffers[i];
            if (doubleBuffer.isEmpty() || doubleBuffer.level() >= n2) continue;
            n2 = doubleBuffer.level();
        }
        return n2;
    }

    public int _getNumberOfEmptyBuffers() {
        int n = 0;
        int n2 = this.buffers.length;
        while (--n2 >= 0) {
            if (!this.buffers[n2].isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public DoubleBuffer _getPartialBuffer() {
        int n = this.buffers.length;
        while (--n >= 0) {
            if (!this.buffers[n].isPartial()) continue;
            return this.buffers[n];
        }
        return null;
    }

    public int b() {
        return this.buffers.length;
    }

    public void clear() {
        this.clear(this.k());
    }

    protected void clear(int n) {
        int n2 = this.b();
        while (--n2 >= 0) {
            this.buffers[n2] = new DoubleBuffer(n);
        }
        this.nextTriggerCalculationState = true;
    }

    public Object clone() {
        DoubleBufferSet doubleBufferSet = (DoubleBufferSet)super.clone();
        doubleBufferSet.buffers = (DoubleBuffer[])doubleBufferSet.buffers.clone();
        int n = this.buffers.length;
        while (--n >= 0) {
            doubleBufferSet.buffers[n] = (DoubleBuffer)doubleBufferSet.buffers[n].clone();
        }
        return doubleBufferSet;
    }

    public DoubleBuffer collapse(DoubleBuffer[] doubleBufferArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < doubleBufferArray.length; ++n) {
            n2 += doubleBufferArray[n].weight();
        }
        n = this.k();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.nextTriggerPosition(i, n2);
        }
        double[] dArray = this.getValuesAtPositions(doubleBufferArray, lArray);
        for (int i = 1; i < doubleBufferArray.length; ++i) {
            doubleBufferArray[i].clear();
        }
        DoubleBuffer doubleBuffer = doubleBufferArray[0];
        doubleBuffer.values.elements(dArray);
        doubleBuffer.weight(n2);
        return doubleBuffer;
    }

    public boolean contains(double d2) {
        int n = this.buffers.length;
        while (--n >= 0) {
            if (this.buffers[n].isEmpty() || !this.buffers[n].contains(d2)) continue;
            return true;
        }
        return false;
    }

    public boolean forEach(DoubleProcedure doubleProcedure) {
        int n = this.buffers.length;
        while (--n >= 0) {
            int n2 = this.buffers[n].weight();
            while (--n2 >= 0) {
                if (this.buffers[n].values.forEach(doubleProcedure)) continue;
                return false;
            }
        }
        return true;
    }

    protected double[] getValuesAtPositions(DoubleBuffer[] doubleBufferArray, long[] lArray) {
        int n = doubleBufferArray.length;
        while (--n >= 0) {
            doubleBufferArray[n].sort();
        }
        int[] nArray = new int[doubleBufferArray.length];
        double[][] dArrayArray = new double[doubleBufferArray.length][];
        int n2 = 0;
        int n3 = doubleBufferArray.length;
        while (--n3 >= 0) {
            nArray[n3] = doubleBufferArray[n3].size();
            dArrayArray[n3] = doubleBufferArray[n3].values.elements();
            n2 += nArray[n3];
        }
        n3 = doubleBufferArray.length;
        int n4 = lArray.length;
        int n5 = 0;
        int[] nArray2 = new int[doubleBufferArray.length];
        long l = 0L;
        long l2 = lArray[n5];
        double[] dArray = new double[n4];
        if (n2 == 0) {
            for (int i = 0; i < lArray.length; ++i) {
                dArray[i] = Double.NaN;
            }
            return dArray;
        }
        while (n5 < n4) {
            double d2 = Double.POSITIVE_INFINITY;
            int n6 = -1;
            int n7 = n3;
            while (--n7 >= 0) {
                double d3;
                if (nArray2[n7] >= nArray[n7] || !((d3 = dArrayArray[n7][nArray2[n7]]) <= d2)) continue;
                d2 = d3;
                n6 = n7;
            }
            DoubleBuffer doubleBuffer = doubleBufferArray[n6];
            l += (long)doubleBuffer.weight();
            while (l > l2 && n5 < n4) {
                dArray[n5++] = d2;
                if (n5 >= n4) continue;
                l2 = lArray[n5];
            }
            int n8 = n6;
            nArray2[n8] = nArray2[n8] + 1;
        }
        return dArray;
    }

    public int k() {
        return this.buffers[0].k;
    }

    public long memory() {
        long l = 0L;
        int n = this.buffers.length;
        while (--n >= 0) {
            l += (long)this.buffers[n].memory();
        }
        return l;
    }

    protected long nextTriggerPosition(int n, long l) {
        long l2 = l % 2L != 0L ? (long)n * l + (l + 1L) / 2L : (this.nextTriggerCalculationState ? (long)n * l + l / 2L : (long)n * l + (l + 2L) / 2L);
        return l2;
    }

    public double phi(double d2) {
        double d3 = 0.0;
        int n = this.buffers.length;
        while (--n >= 0) {
            if (this.buffers[n].isEmpty()) continue;
            d3 += (double)this.buffers[n].weight * this.buffers[n].rank(d2);
        }
        return d3 / (double)this.totalSize();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.b(); ++i) {
            if (this.buffers[i].isEmpty()) continue;
            stringBuffer.append("buffer#" + i + " = ");
            stringBuffer.append(this.buffers[i].toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public long totalSize() {
        DoubleBuffer[] doubleBufferArray = this._getFullOrPartialBuffers();
        long l = 0L;
        int n = doubleBufferArray.length;
        while (--n >= 0) {
            l += (long)(doubleBufferArray[n].size() * doubleBufferArray[n].weight());
        }
        return l;
    }
}

