/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.ref.Histogram;

abstract class AbstractHistogram2D
extends Histogram
implements IHistogram2D {
    protected IAxis xAxis;
    protected IAxis yAxis;

    AbstractHistogram2D(String string) {
        super(string);
    }

    public int allEntries() {
        int n = 0;
        int n2 = this.xAxis.bins();
        while (--n2 >= -2) {
            int n3 = this.yAxis.bins();
            while (--n3 >= -2) {
                n += this.binEntries(n2, n3);
            }
        }
        return n;
    }

    public int binEntriesX(int n) {
        return this.projectionX().binEntries(n);
    }

    public int binEntriesY(int n) {
        return this.projectionY().binEntries(n);
    }

    public double binHeightX(int n) {
        return this.projectionX().binHeight(n);
    }

    public double binHeightY(int n) {
        return this.projectionY().binHeight(n);
    }

    public int dimensions() {
        return 2;
    }

    public int entries() {
        int n = 0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                n += this.binEntries(i, j);
            }
        }
        return n;
    }

    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    public void fill(double d2, double d3) {
        this.fill(d2, d3, 1.0);
    }

    protected abstract IHistogram1D internalSliceX(String var1, int var2, int var3);

    protected abstract IHistogram1D internalSliceY(String var1, int var2, int var3);

    int mapX(int n) {
        int n2 = this.xAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    int mapY(int n) {
        int n2 = this.yAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    public int[] minMaxBins() {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = this.xAxis.bins();
        while (--n5 >= 0) {
            int n6 = this.yAxis.bins();
            while (--n6 >= 0) {
                double d4 = this.binHeight(n5, n6);
                if (d4 < d2) {
                    d2 = d4;
                    n = n5;
                    n2 = n6;
                }
                if (!(d4 > d3)) continue;
                d3 = d4;
                n3 = n5;
                n4 = n6;
            }
        }
        int[] nArray = new int[]{n, n2, n3, n4};
        return nArray;
    }

    public IHistogram1D projectionX() {
        String string = this.title() + " (projectionX)";
        return this.internalSliceX(string, this.mapY(-2), this.mapY(-1));
    }

    public IHistogram1D projectionY() {
        String string = this.title() + " (projectionY)";
        return this.internalSliceY(string, this.mapX(-2), this.mapX(-1));
    }

    public IHistogram1D sliceX(int n) {
        int n2 = this.mapY(n);
        String string = this.title() + " (sliceX [" + n + "])";
        return this.internalSliceX(string, n2, n2);
    }

    public IHistogram1D sliceX(int n, int n2) {
        int n3 = this.mapY(n);
        int n4 = this.mapY(n2);
        String string = this.title() + " (sliceX [" + n + ":" + n2 + "])";
        return this.internalSliceX(string, n3, n4);
    }

    public IHistogram1D sliceY(int n) {
        int n2 = this.mapX(n);
        String string = this.title() + " (sliceY [" + n + "])";
        return this.internalSliceY(string, n2, n2);
    }

    public IHistogram1D sliceY(int n, int n2) {
        int n3 = this.mapX(n);
        int n4 = this.mapX(n2);
        String string = this.title() + " (slicey [" + n + ":" + n2 + "])";
        return this.internalSliceY(string, n3, n4);
    }

    public double sumAllBinHeights() {
        double d2 = 0.0;
        int n = this.xAxis.bins();
        while (--n >= -2) {
            int n2 = this.yAxis.bins();
            while (--n2 >= -2) {
                d2 += this.binHeight(n, n2);
            }
        }
        return d2;
    }

    public double sumBinHeights() {
        double d2 = 0.0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                d2 += this.binHeight(i, j);
            }
        }
        return d2;
    }

    public double sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    public IAxis xAxis() {
        return this.xAxis;
    }

    public IAxis yAxis() {
        return this.yAxis;
    }
}

