/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.pi.controller;

import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cobi.pi.controller.GenotypeQC;
import org.cobi.pi.controller.PValueImputer;
import org.cobi.pi.entity.GenotypeBasedLDMapSparseMatrix;
import org.cobi.pi.entity.GenotypeFile;
import org.cobi.pi.entity.HaplotypeDataset;
import org.cobi.pi.entity.Options;
import org.cobi.pi.entity.PlinkDataset;
import org.cobi.pi.entity.SNP;
import org.cobi.pi.entity.SNPOrderComparator;
import org.cobi.pi.entity.SNPPositionComparator;

public class ImputeBySameGenotype {
    int a = 0;
    int b = 0;
    String c;
    Options d;
    Map[] e;
    List[] f;
    BufferedWriter g;
    List h;
    GenotypeBasedLDMapSparseMatrix i;

    public ImputeBySameGenotype(int n, int n2, String string, Options options, Map[] mapArray, List[] listArray, BufferedWriter bufferedWriter) {
        this.a = n;
        this.c = string;
        this.d = options;
        this.e = mapArray;
        this.f = listArray;
        this.b = n2;
        this.g = bufferedWriter;
        this.h = new ArrayList();
    }

    public String impute() {
        int n = 0;
        long l = System.currentTimeMillis();
        GenotypeQC genotypeQC = new GenotypeQC();
        HaplotypeDataset haplotypeDataset = new HaplotypeDataset();
        PValueImputer pValueImputer = new PValueImputer();
        boolean bl = false;
        for (int i = 0; i < this.a; ++i) {
            Object object;
            Object object2;
            n = 0;
            this.f[i] = new ArrayList();
            if (this.e[i] == null || this.e[i].isEmpty() || this.e[i].size() < 2) continue;
            l = System.currentTimeMillis();
            GenotypeFile genotypeFile = (GenotypeFile)this.d.genotypeFileList.get(this.b);
            if (genotypeFile.getDataType().equals("--vcf")) {
                object2 = genotypeFile.getFilePath().replaceAll("_CHROM_", this.c);
                object = new File((String)object2);
                if (!((File)object).exists()) {
                    String string = "The file " + ((File)object).getCanonicalPath() + " does not exist!";
                    return string;
                }
                if (i == 0) {
                    bl = haplotypeDataset.readSNPMapHapVCFFileByPositions((File)object, this.c, this.e[i], this.f[i], this.h, true, this.g, this.d.mafThreshold);
                } else {
                    for (SNP sNP : this.f[0]) {
                        SNP sNP2 = (SNP)this.e[i].get(sNP.getPhysicalPosition());
                        if (sNP2 == null) {
                            sNP2 = new SNP(sNP.getRsID(), sNP.getPhysicalPosition(), sNP.order);
                        } else {
                            sNP2.setOrder(sNP.order);
                        }
                        this.f[i].add(sNP2);
                    }
                }
            } else if (genotypeFile.getDataType().equals("--plink")) {
                object2 = new PlinkDataset(genotypeFile.getFilePath() + ".fam", genotypeFile.getFilePath() + ".bim", genotypeFile.getFilePath() + ".bed");
                if (((PlinkDataset)object2).readSNPsinPlinkBinaryMapFileBySPositions(this.f[i], this.c, this.e[i], true, this.g) <= 0) {
                    return "No SNPs in the reference panel on chromosome " + this.c;
                }
                Collections.sort(this.f[i], new SNPOrderComparator());
                ((PlinkDataset)object2).readPlinkBinaryGenotypeinPedigreeFile(this.h, this.f[i]);
                bl = false;
                object = "";
                if (i == 0 && this.d.mafThreshold > 0.0) {
                    object = genotypeQC.removeByMAF(this.f[i], this.h, this.d.mafThreshold);
                    System.out.println("On chromosome " + this.c + ", " + (String)object);
                }
            } else {
                object2 = "No data to account for LD on chromosome " + this.c;
                throw new Exception((String)object2);
            }
            if (i == 0) {
                this.i = new GenotypeBasedLDMapSparseMatrix(this.h, bl);
                this.i.setIsPhased(bl);
                Collections.sort(this.f[i], new SNPPositionComparator());
            }
            pValueImputer.fastImputeStage2ByR2(this.i, this.f[i], this.d.windowSize, this.d.weakCorrelationThreshold, this.d.windowLen, this.c);
            object2 = (n += pValueImputer.fastImputeByR2(this.i, this.f[i], this.d.windowSize, this.d.weakCorrelationThreshold, this.d.windowLen, this.c)) + " p-values are imputed on chromosome " + this.c + " for study " + i + ". Elapsed time: " + (System.currentTimeMillis() - l) / 1000L + " seconds.";
            System.out.println((String)object2);
        }
        if (this.h != null) {
            this.h.clear();
        }
        if (this.i != null) {
            this.i.releaseLDData();
        }
        return "";
    }
}

