/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.pi.entity;

import cern.colt.bitvector.BitVector;
import cern.colt.list.IntArrayList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.samtools.util.AsciiLineReader;
import net.sf.samtools.util.CompressedFileReader;
import net.sf.samtools.util.LineReader;
import org.cobi.pi.Constants;
import org.cobi.pi.entity.Individual;
import org.cobi.pi.entity.SNP;
import org.cobi.pi.entity.SNPOrderComparator;
import org.cobi.pi.entity.StatusGtySet;
import org.cobi.util.text.LocalString;

public class HaplotypeDataset
implements Constants {
    String a;
    String b;

    public HaplotypeDataset() {
    }

    public HaplotypeDataset(String string, String string2) {
        this.a = string;
        this.b = string2;
    }

    public int readAllMapSNPPositions(String string, int[] nArray, Map map, List list) {
        StringTokenizer stringTokenizer;
        String string2 = this.a.replaceAll("_CHROM_", string);
        File file = new File(string2);
        if (!file.exists()) {
            return 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = nArray.length / 2;
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (nArray[i * 2] == -9 && nArray[i * 2 + 1] == -9) continue;
            bl = true;
            if (nArray[i * 2 + 1] == -9) {
                nArray[1] = Integer.MAX_VALUE;
            }
            stringBuilder2.append(" [");
            stringBuilder2.append(nArray[i * 2]);
            stringBuilder2.append(",");
            stringBuilder2.append(nArray[i * 2 + 1]);
            stringBuilder2.append("]bp");
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n2 = -1;
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 2;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        String string3 = null;
        String string4 = "\t ,";
        int n8 = n4;
        String string5 = bufferedReader.readLine();
        if (string5 != null) {
            stringTokenizer = new StringTokenizer(string5, string4);
            bl2 = false;
            n6 = 0;
            string3 = null;
            n7 = -1;
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder3.delete(0, stringBuilder3.length());
                stringBuilder3.append(stringTokenizer.nextToken().trim());
                if (n6 == n4) {
                    if (!LocalString.isInteger(stringBuilder3.toString())) break;
                    n7 = Integer.parseInt(stringBuilder3.toString());
                    if (bl) {
                        for (int i = 0; i < n; ++i) {
                            if (n7 < nArray[i * 2] || n7 > nArray[i * 2 + 1]) continue;
                            bl2 = true;
                            break;
                        }
                    }
                } else if (n6 == n5) {
                    string3 = stringBuilder3.toString();
                } else if (n6 > n8) break;
                ++n6;
            }
            if (n7 >= 0) {
                ++n2;
                if (!bl || bl2) {
                    SNP sNP = (SNP)map.get(n7);
                    if (sNP == null) {
                        list.add(new SNP(string3, n7, n2));
                    } else {
                        list.add(new SNP(string3, n7, sNP.pValue, n2));
                    }
                    ++n3;
                }
            }
        }
        while ((string5 = bufferedReader.readLine()) != null) {
            ++n2;
            stringTokenizer = new StringTokenizer(string5, string4);
            bl2 = false;
            n6 = 0;
            string3 = null;
            n7 = -1;
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder3.delete(0, stringBuilder3.length());
                stringBuilder3.append(stringTokenizer.nextToken().trim());
                if (n6 == n4) {
                    n7 = Integer.parseInt(stringBuilder3.toString());
                    if (bl) {
                        for (int i = 0; i < n; ++i) {
                            if (n7 < nArray[i * 2] || n7 > nArray[i * 2 + 1]) continue;
                            bl2 = true;
                            break;
                        }
                    }
                } else if (n6 == n5) {
                    string3 = stringBuilder3.toString();
                } else if (n6 > n8) break;
                ++n6;
            }
            if (bl && !bl2) continue;
            SNP sNP = (SNP)map.get(n7);
            if (sNP == null) {
                list.add(new SNP(string3, n7, n2));
            } else {
                list.add(new SNP(string3, n7, sNP.pValue, n2));
            }
            ++n3;
        }
        bufferedReader.close();
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append("The number of SNPs on chromosome ");
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(" is ");
        stringBuilder.append(n3);
        stringBuilder.append(".");
        System.out.println(stringBuilder);
        return n3;
    }

    public int readListedMapSNPPositions(String string, int[] nArray, Map map, List list) {
        StringTokenizer stringTokenizer;
        String string2 = this.a.replaceAll("_CHROM_", string);
        File file = new File(string2);
        if (!file.exists()) {
            return 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = nArray.length / 2;
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (nArray[i * 2] == -9 && nArray[i * 2 + 1] == -9) continue;
            bl = true;
            if (nArray[i * 2 + 1] == -9) {
                nArray[1] = Integer.MAX_VALUE;
            }
            stringBuilder2.append(" [");
            stringBuilder2.append(nArray[i * 2]);
            stringBuilder2.append(",");
            stringBuilder2.append(nArray[i * 2 + 1]);
            stringBuilder2.append("]bp");
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n2 = -1;
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 2;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        String string3 = null;
        String string4 = "\t ,";
        int n8 = n4;
        String string5 = bufferedReader.readLine();
        if (string5 != null) {
            stringTokenizer = new StringTokenizer(string5, string4);
            bl2 = false;
            n6 = 0;
            string3 = null;
            n7 = -1;
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder3.delete(0, stringBuilder3.length());
                stringBuilder3.append(stringTokenizer.nextToken().trim());
                if (n6 == n4) {
                    if (!LocalString.isInteger(stringBuilder3.toString())) break;
                    n7 = Integer.parseInt(stringBuilder3.toString());
                    if (bl) {
                        for (int i = 0; i < n; ++i) {
                            if (n7 < nArray[i * 2] || n7 > nArray[i * 2 + 1]) continue;
                            bl2 = true;
                            break;
                        }
                    }
                } else if (n6 == n5) {
                    string3 = stringBuilder3.toString();
                } else if (n6 > n8) break;
                ++n6;
            }
            if (n7 >= 0) {
                SNP sNP;
                ++n2;
                if ((!bl || bl2) && (sNP = (SNP)map.get(n7)) != null) {
                    sNP.setOrder(n2);
                    list.add(sNP);
                    ++n3;
                }
            }
        }
        while ((string5 = bufferedReader.readLine()) != null) {
            SNP sNP;
            ++n2;
            stringTokenizer = new StringTokenizer(string5, string4);
            bl2 = false;
            n6 = 0;
            string3 = null;
            n7 = -1;
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder3.delete(0, stringBuilder3.length());
                stringBuilder3.append(stringTokenizer.nextToken().trim());
                if (n6 == n4) {
                    n7 = Integer.parseInt(stringBuilder3.toString());
                    if (bl) {
                        for (int i = 0; i < n; ++i) {
                            if (n7 < nArray[i * 2] || n7 > nArray[i * 2 + 1]) continue;
                            bl2 = true;
                            break;
                        }
                    }
                } else if (n6 == n5) {
                    string3 = stringBuilder3.toString();
                } else if (n6 > n8) break;
                ++n6;
            }
            if (bl && !bl2 || (sNP = (SNP)map.get(n7)) == null) continue;
            ++n3;
            if (sNP.order >= 0) continue;
            sNP.setOrder(n2);
            list.add(sNP);
        }
        bufferedReader.close();
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append("The number of SNPs on chromosome ");
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(" is ");
        stringBuilder.append(n3);
        stringBuilder.append(".");
        System.out.println(stringBuilder);
        return n3;
    }

    public void readHaplotypesBySNPList(String string, List list, List list2) {
        String string2 = null;
        int n = list.size();
        String string3 = this.b.replaceAll("_CHROM_", string);
        int n2 = list.size();
        Collections.sort(list, new SNPOrderComparator());
        char[] cArray = new char[n2];
        char[] cArray2 = new char[n2];
        boolean[] blArray = new boolean[n2];
        int[] nArray = new int[n2];
        Arrays.fill(cArray, 'X');
        Arrays.fill(cArray2, 'X');
        Arrays.fill(blArray, true);
        Arrays.fill(nArray, -1);
        int n3 = 0;
        File file = new File(string3);
        int n4 = 0;
        int n5 = 0;
        char c2 = 'X';
        int n6 = 0;
        LineReader lineReader = null;
        if (file.exists() && file.getName().endsWith(".zip")) {
            lineReader = new CompressedFileReader(file);
        } else if (file.exists() && file.getName().endsWith(".gz")) {
            lineReader = new CompressedFileReader(file);
        } else if (file.exists()) {
            lineReader = new AsciiLineReader(file);
        } else {
            throw new Exception("No pvalue file: " + file.getCanonicalPath());
        }
        while ((string2 = lineReader.readLine()) != null) {
            n5 = n4 = 0;
            while (string2.charAt(n5) != ' ') {
                ++n5;
            }
            Individual individual = new Individual();
            individual.setLabelInChip(string2.substring(n4, n5));
            n4 = ++n5;
            while (string2.charAt(n5) != ' ') {
                ++n5;
            }
            String string4 = string2.substring(n5 + 1);
            string2 = lineReader.readLine();
            n5 = n4 = 0;
            while (string2.charAt(n5) != ' ') {
                ++n5;
            }
            n4 = ++n5;
            while (string2.charAt(n5) != ' ') {
                ++n5;
            }
            String string5 = string2.substring(n5 + 1);
            individual.markerGtySet = new StatusGtySet();
            individual.markerGtySet.existence = new BitVector(n);
            individual.markerGtySet.paternalChrom = new BitVector(n);
            individual.markerGtySet.maternalChrom = new BitVector(n);
            list2.add(individual);
            n6 = 0;
            for (int i = 0; i < n2; ++i) {
                String string6;
                n6 = ((SNP)list.get((int)i)).order;
                if (blArray[i]) {
                    if (cArray[i] != 'X' && cArray2[i] == 'X') {
                        if (string4.charAt(n6) != cArray[i] && string4.charAt(n6) != c2) {
                            cArray2[i] = string4.charAt(n6);
                            blArray[i] = false;
                        } else if (string5.charAt(n6) != cArray[i] && string5.charAt(n6) != c2) {
                            cArray2[i] = string5.charAt(n6);
                            blArray[i] = false;
                        }
                    } else if (cArray[i] == 'X' && cArray2[i] == 'X') {
                        if (string4.charAt(n6) != c2) {
                            cArray[i] = string4.charAt(n6);
                            if (string5.charAt(n6) != c2 && string5.charAt(n6) != cArray[i]) {
                                cArray2[i] = string5.charAt(n6);
                                blArray[i] = false;
                            }
                        } else if (string5.charAt(n6) != c2) {
                            cArray[i] = string5.charAt(n6);
                        }
                    } else if (cArray[i] == 'X' && cArray2[i] != 'X') {
                        if (string4.charAt(n6) != cArray2[i] && string4.charAt(n6) != c2) {
                            cArray[i] = string4.charAt(n6);
                            blArray[i] = false;
                        } else if (string5.charAt(n6) != cArray2[i] && string5.charAt(n6) != c2) {
                            cArray[i] = string5.charAt(n6);
                            blArray[i] = false;
                        }
                    }
                }
                if (string4.charAt(n6) == cArray2[i]) {
                    individual.markerGtySet.existence.putQuick(i, true);
                    individual.markerGtySet.paternalChrom.putQuick(i, true);
                } else if (string4.charAt(n6) == cArray[i]) {
                    individual.markerGtySet.existence.putQuick(i, true);
                } else if (string4.charAt(n6) != c2) {
                    string6 = "Unexpected allele " + string4.charAt(n6) + " in " + file.getName() + " for IndivID " + individual.getLabelInChip() + " of phase 1.";
                    System.out.println(string6);
                    ++n3;
                }
                if (string5.charAt(n6) == cArray2[i]) {
                    individual.markerGtySet.maternalChrom.putQuick(i, true);
                    continue;
                }
                if (string5.charAt(n6) == cArray[i] || string5.charAt(n6) == c2) continue;
                string6 = "Unexpected allele " + string4.charAt(n6) + " in " + file.getName() + " for IndivID " + individual.getLabelInChip() + " of phase 2.";
                System.out.println(string6);
                ++n3;
            }
            string2 = null;
        }
        lineReader.close();
        if (n3 > 0) {
            System.out.println(n3 + " SNPs have unexpected genotypes in " + file.getName() + "in total.");
        }
        for (int i = 0; i < n2; ++i) {
            ((SNP)list.get((int)i)).order = i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readSNPMapHapVCFFileByPositions(File file, String string, Map map, List list, List list2, boolean bl, BufferedWriter bufferedWriter, double d2) {
        Object object;
        int n;
        Object object2;
        String string2;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl2 = false;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = map.size();
        LineReader lineReader = null;
        if (file.exists() && file.getName().endsWith(".zip")) {
            lineReader = new CompressedFileReader(file);
        } else if (file.exists() && file.getName().endsWith(".gz")) {
            lineReader = new CompressedFileReader(file);
        } else if (file.exists()) {
            lineReader = new AsciiLineReader(file);
        } else {
            throw new Exception("No input file: " + file.getCanonicalPath());
        }
        boolean bl3 = false;
        int n13 = n2 = 2;
        int n14 = 0;
        String string3 = "\t ,";
        int n15 = 0;
        while ((string2 = lineReader.readLine()) != null && !string2.startsWith("#CHROM")) {
        }
        if (string2 == null) {
            lineReader.close();
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2.trim());
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        double[] dArray = null;
        Object[] objectArray = null;
        int[] nArray = null;
        float[] fArray = null;
        int n20 = 0;
        IntArrayList intArrayList = new IntArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder2.delete(0, stringBuilder2.length());
            stringBuilder2.append(stringTokenizer.nextToken().trim());
            if (stringBuilder2.toString().equals("#CHROM")) {
                n3 = n17;
            } else if (stringBuilder2.toString().equals("POS")) {
                n4 = n17;
            } else if (stringBuilder2.toString().equals("ID")) {
                n5 = n17;
            } else if (stringBuilder2.toString().equals("REF")) {
                n6 = n17;
            } else if (stringBuilder2.toString().equals("ALT")) {
                n7 = n17;
            } else if (stringBuilder2.toString().equals("QUAL")) {
                n8 = n17;
            } else if (stringBuilder2.toString().equals("FILTER")) {
                n9 = n17;
            } else if (stringBuilder2.toString().equals("INFO")) {
                n11 = n17;
            } else if (stringBuilder2.toString().equals("FORMAT")) {
                n10 = n17;
                n18 = -1;
                n19 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuilder2.delete(0, stringBuilder2.length());
                    stringBuilder2.append(stringTokenizer.nextToken().trim());
                    ++n18;
                    Individual individual = new Individual();
                    individual.setLabelInChip(stringBuilder2.toString());
                    individual.markerGtySet = new StatusGtySet();
                    individual.markerGtySet.existence = new BitVector(n12);
                    individual.markerGtySet.paternalChrom = new BitVector(n12);
                    individual.markerGtySet.maternalChrom = new BitVector(n12);
                    list2.add(individual);
                    ++n19;
                    intArrayList.add(n18);
                }
                ++n18;
                break;
            }
            ++n17;
        }
        if (n18 > 0) {
            dArray = new double[n18];
            objectArray = new String[n18];
            nArray = new int[n18];
            fArray = new float[n18];
            Arrays.fill(objectArray, null);
            Arrays.fill(dArray, 0.0);
            Arrays.fill(nArray, 0);
            Arrays.fill(fArray, 0.0f);
        }
        int n21 = n3;
        n21 = Math.max(n21, n4);
        n21 = Math.max(n21, n5);
        n21 = Math.max(n21, n7);
        n21 = Math.max(n21, n6);
        n21 = Math.max(n21, n10);
        String string4 = "\t";
        boolean bl4 = false;
        String string5 = null;
        boolean bl5 = false;
        String string6 = null;
        int n22 = -1;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        int n23 = -1;
        int n24 = -1;
        int n25 = -1;
        int n26 = -1;
        int n27 = -1;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        int n28 = 0;
        double d3 = 0.0;
        int n29 = 0;
        int n30 = 0;
        int n31 = 0;
        boolean bl11 = false;
        boolean bl12 = false;
        int n32 = stringBuilder2.length();
        int n33 = 0;
        double d4 = 0.0;
        int n34 = 0;
        double d5 = 1.0;
        double d6 = 0.0;
        String string10 = null;
        String string11 = null;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        double d7 = 0.0;
        double d8 = 1.0 - d2;
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n35 = 0;
        string2 = lineReader.readLine();
        if (string2 != null) {
            if (string2.indexOf("0|0") >= 0 || string2.indexOf("0|0") >= 0 || string2.indexOf("0|1") >= 0 || string2.indexOf("1|0") >= 0 || string2.indexOf("0|2") >= 0 || string2.indexOf("2|0") >= 0 || string2.indexOf("0|3") >= 0 || string2.indexOf("3|0") >= 0 || string2.indexOf("1|1") >= 0 || string2.indexOf("1|2") >= 0 || string2.indexOf("2|1") >= 0 || string2.indexOf("1|3") >= 0 || string2.indexOf("3|1") >= 0 || string2.indexOf("2|2") >= 0 || string2.indexOf("2|3") >= 0 || string2.indexOf("3|2") >= 0 || string2.indexOf("3|3") >= 0) {
                bl5 = true;
            }
            do {
                if ((string6 = (stringArray = bl ? LocalString.tokenize(string2.trim(), '\t') : LocalString.tokenize(string2.trim(), '\t', n4))[n3].charAt(stringArray[n3].length() - 1) == 'T' || stringArray[n3].charAt(stringArray[n3].length() - 1) == 't' ? stringArray[n3].substring(0, stringArray[n3].length() - 1) : stringArray[n3]).charAt(0) == 'C' || string6.charAt(0) == 'c') {
                    string6 = string6.substring(3);
                }
                if (!string6.equals(string) || (n22 = Integer.parseInt(stringArray[n4])) <= 0) continue;
                string6 = null;
                string9 = null;
                object2 = (SNP)map.get(n22);
                if (bl) {
                    string9 = stringArray[n5];
                    if (object2 == null) {
                        object2 = new SNP(string9, n22, n15);
                    }
                } else {
                    if (object2 == null) continue;
                    stringArray = LocalString.tokenize(string2.trim(), '\t');
                    if (((SNP)object2).order >= 0) continue;
                    string9 = stringArray[n5];
                }
                string7 = null;
                string8 = null;
                n23 = -1;
                n24 = -1;
                n25 = -1;
                n26 = -1;
                n27 = -1;
                bl6 = false;
                bl7 = false;
                bl8 = false;
                bl9 = false;
                bl10 = false;
                if (n18 > 0) {
                    Arrays.fill(objectArray, null);
                    Arrays.fill(dArray, 0.0);
                    Arrays.fill(nArray, 0);
                    Arrays.fill(fArray, 0.0f);
                }
                ++n20;
                string8 = stringArray[n7];
                string7 = stringArray[n6];
                stringArray2 = LocalString.tokenize(stringArray[n10], ':');
                for (n = 0; n < stringArray2.length; ++n) {
                    object = stringArray2[n];
                    if (object.equals("GT")) {
                        n23 = n;
                        bl6 = true;
                        continue;
                    }
                    if (object.equals("GQ")) {
                        n24 = n;
                        bl7 = true;
                        continue;
                    }
                    if (object.equals("DP")) {
                        n25 = n;
                        bl8 = true;
                        continue;
                    }
                    if (object.equals("AD")) {
                        n26 = n;
                        bl9 = true;
                        continue;
                    }
                    if (!object.equals("FA")) continue;
                    n27 = n;
                    bl10 = true;
                }
                if (n18 <= 0) {
                    n18 = stringTokenizer.countTokens() - n17;
                    dArray = new double[n18];
                    objectArray = new String[n18];
                    nArray = new int[n18];
                    fArray = new float[n18];
                    Arrays.fill(objectArray, null);
                    Arrays.fill(dArray, 0.0);
                    Arrays.fill(nArray, 0);
                    Arrays.fill(fArray, 0.0f);
                    Individual individual = new Individual();
                    individual.setLabelInChip(stringBuilder2.toString());
                    individual.markerGtySet = new StatusGtySet();
                    individual.markerGtySet.existence = new BitVector(n12);
                    individual.markerGtySet.paternalChrom = new BitVector(n12);
                    individual.markerGtySet.maternalChrom = new BitVector(n12);
                    list2.add(individual);
                }
                n30 = 0;
                for (n17 = n10 + 1; n17 < stringArray.length; ++n17) {
                    if (stringArray[n17].charAt(0) == '\"') {
                        string5 = stringArray[n17].substring(1, stringArray[n17].length() - 1);
                    }
                    if (stringArray[n17].equals(".|.") || stringArray[n17].equals(".") || stringArray[n17].equals("./.")) {
                        objectArray[n30] = null;
                        ++n30;
                        continue;
                    }
                    n31 = 0;
                    bl11 = false;
                    bl12 = false;
                    stringArray2 = LocalString.tokenize(stringArray[n17], ':');
                    objectArray[n30] = stringArray2[n23];
                    if (n24 >= 0) {
                        dArray[n30] = stringArray2[n24].charAt(n31) == '.' ? 0.0 : Double.parseDouble(stringArray2[n24]);
                    }
                    if (n25 >= 0) {
                        nArray[n30] = stringArray2[n25].charAt(0) == '.' ? 0 : Integer.parseInt(stringArray2[n25]);
                    }
                    if (!bl10 && n26 >= 0) {
                        if (stringArray2[n26].charAt(0) == '.') {
                            fArray[n30] = Float.NaN;
                        } else {
                            String string12 = stringArray2[n26];
                            int n36 = string12.indexOf(44);
                            int n37 = string12.lastIndexOf(44);
                            string10 = string12.substring(0, n36);
                            string11 = string12.substring(n37 + 1);
                            if (string10.equals(".")) {
                                string10 = "0";
                            }
                            if (string11.equals(".")) {
                                string11 = "0";
                            }
                            fArray[n30] = Float.parseFloat(string11) / (Float.parseFloat(string11) + Float.parseFloat(string10));
                        }
                    }
                    if (n27 >= 0) {
                        fArray[n30] = stringArray2[n27].charAt(n31) == '.' ? Float.NaN : Float.parseFloat(stringArray2[n27]);
                    }
                    ++n30;
                }
                n = 0;
                for (n14 = n18 - 1; n14 >= 0; --n14) {
                    if (objectArray[n14] == null || ((String)objectArray[n14]).charAt(0) == '.') {
                        ++n;
                        continue;
                    }
                    if (bl7 && dArray[n14] < d4) {
                        ++n28;
                        objectArray[n14] = null;
                        ++n;
                        continue;
                    }
                    if (bl8 && nArray[n14] < n34) {
                        ++n33;
                        objectArray[n14] = null;
                        ++n;
                        continue;
                    }
                    if (!bl9 && !bl10) continue;
                    if (Float.isNaN(fArray[n14])) {
                        ++n29;
                        objectArray[n14] = null;
                        ++n;
                        continue;
                    }
                    if (((String)objectArray[n14]).charAt(0) == '0') {
                        if (!((double)fArray[n14] > d5)) continue;
                        ++n29;
                        objectArray[n14] = null;
                        ++n;
                        continue;
                    }
                    if (!((double)fArray[n14] < d6)) continue;
                    ++n29;
                    objectArray[n14] = null;
                    ++n;
                }
                if (n == n18) continue;
                object = LocalString.tokenize(string8, ',');
                if (((String[])object).length > 1) {
                    // empty if block
                }
                if (n12 <= n15) {
                    n12 = bl ? (n12 += 100000) : (n12 += 1000);
                    for (Individual individual : list2) {
                        individual.markerGtySet.existence.setSize(n12);
                        individual.markerGtySet.paternalChrom.setSize(n12);
                        individual.markerGtySet.maternalChrom.setSize(n12);
                    }
                }
                ((SNP)object2).setRefAllle(string7);
                ((SNP)object2).setAltAllle(string8);
                d7 = 0.0;
                for (n14 = 0; n14 < n19; ++n14) {
                    n16 = intArrayList.getQuick(n14);
                    Map.Entry entry = ((Individual)list2.get((int)n14)).markerGtySet;
                    if (objectArray[n16] == null) {
                        ((StatusGtySet)((Object)entry)).existence.putQuick(n15, false);
                        continue;
                    }
                    if (((String)objectArray[n16]).equals("0|0")) {
                        ((StatusGtySet)((Object)entry)).existence.putQuick(n15, true);
                        ((StatusGtySet)((Object)entry)).paternalChrom.putQuick(n15, false);
                        ((StatusGtySet)((Object)entry)).maternalChrom.putQuick(n15, false);
                        continue;
                    }
                    if (((String)objectArray[n16]).equals("0|1")) {
                        ((StatusGtySet)((Object)entry)).existence.putQuick(n15, true);
                        ((StatusGtySet)((Object)entry)).paternalChrom.putQuick(n15, false);
                        ((StatusGtySet)((Object)entry)).maternalChrom.putQuick(n15, true);
                        d7 += 0.5;
                        continue;
                    }
                    if (((String)objectArray[n16]).equals("1|0")) {
                        ((StatusGtySet)((Object)entry)).existence.putQuick(n15, true);
                        ((StatusGtySet)((Object)entry)).paternalChrom.putQuick(n15, true);
                        ((StatusGtySet)((Object)entry)).maternalChrom.putQuick(n15, false);
                        d7 += 0.5;
                        continue;
                    }
                    if (!((String)objectArray[n16]).equals("1|1")) continue;
                    ((StatusGtySet)((Object)entry)).existence.putQuick(n15, true);
                    ((StatusGtySet)((Object)entry)).paternalChrom.putQuick(n15, true);
                    ((StatusGtySet)((Object)entry)).maternalChrom.putQuick(n15, true);
                    d7 += 1.0;
                }
                if ((d7 /= (double)n19) < d2 || d7 > d8) {
                    ++n35;
                    continue;
                }
                ((SNP)object2).order = n15++;
                list.add(object2);
                hashSet.add(((SNP)object2).physicalPosition);
            } while ((string2 = lineReader.readLine()) != null);
            lineReader.close();
        }
        System.out.println(n20 + " SNPs have registration in " + file.getCanonicalPath());
        object2 = new StringBuilder();
        n = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (hashSet.contains(entry.getKey())) continue;
            ((StringBuilder)object2).append(string);
            ((StringBuilder)object2).append('\t');
            ((StringBuilder)object2).append(String.valueOf(((SNP)entry.getValue()).physicalPosition));
            ((StringBuilder)object2).append('\t');
            ((StringBuilder)object2).append(((SNP)entry.getValue()).getRsID());
            ((StringBuilder)object2).append('\n');
            ++n;
        }
        if (n35 > 0) {
            System.out.println("Warning!!! " + n35 + " SNPs have MAF less than " + d2 + " and will be ignored!");
        }
        if (((StringBuilder)object2).length() > 0) {
            System.out.println("Warning!!! " + n + " SNPs cannot be mapped onto reference panel according to their coordinates and will be ignored!");
            object = bufferedWriter;
            synchronized (object) {
                bufferedWriter.write(((StringBuilder)object2).toString());
            }
        }
        return bl5;
    }
}

