/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.pi.entity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.samtools.util.AsciiLineReader;
import net.sf.samtools.util.CompressedFileReader;
import org.cobi.pi.Constants;
import org.cobi.pi.GlobalManager;
import org.cobi.pi.entity.GenotypeFile;

public class Options
implements Constants {
    String[] a;
    int b;
    public String command = null;
    public Map regions = null;
    public List resultFileNameList = null;
    public double errorRate = 0.05;
    public List pvalueFileNameList = null;
    public List headerList = null;
    public List genotypeFileList = null;
    public List pvalueMarkerList = null;
    public List pvalueIndexList = null;
    public List sampleSizeList = null;
    public String chromMarker = null;
    public String IDMarker = null;
    public String positionMarker = null;
    public int chromIndex = 0;
    public int markerIDIndex = 1;
    public int markerPositionIndex = 2;
    public double mafThreshold = 0.03;
    public boolean pQC = false;
    public boolean pImpute = false;
    public boolean pMeta = false;
    public boolean noimpute = false;
    public boolean sameGenotypeFile = false;
    public double varianceFilter = 0.7;
    public double weakCorrelationThreshold = 0.1;
    public int windowSize = 10;
    public int windowLen = 1500000;
    public Map PUBDB_URL_MAP = new HashMap();
    public List downloadList = new ArrayList();
    public String resourceFolder = null;
    public int threadNum = 1;
    public String missingPValueLabel = "NA";

    private int a(String string) {
        for (int i = 0; i < this.b; ++i) {
            if (!this.a[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private int a(List list, String string) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!((String)list.get(i)).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public Options() {
        this.PUBDB_URL_MAP.put("hapmap2.r22.ceu.hg19", "hapmap/hapmap2.r22.ceu.hg19.tar");
        this.PUBDB_URL_MAP.put("hapmap2.r22.chbjpt.hg19", "hapmap/hapmap2.r22.chbjpt.hg19.tar");
        this.PUBDB_URL_MAP.put("hapmap2.r22.yri.hg19", "hapmap/hapmap2.r22.yri.hg19.tar");
        this.PUBDB_URL_MAP.put("hapmap3.r2.ceu.hg19", "hapmap/hapmap3.r2.ceu.hg19.tar");
        this.PUBDB_URL_MAP.put("hapmap3.r2.chbjpt.hg19", "hapmap/hapmap3.r2.chbjpt.hg19.tar");
        this.PUBDB_URL_MAP.put("hapmap3.r2.mex.hg19", "hapmap/hapmap3.r2.mex.hg19.tar");
        this.PUBDB_URL_MAP.put("hapmap3.r2.tsi.hg19", "hapmap/hapmap3.r2.tsi.hg19.tar");
        this.PUBDB_URL_MAP.put("hapmap3.r2.yri.hg19", "hapmap/hapmap3.r2.yri.hg19.tar");
        this.PUBDB_URL_MAP.put("1kg.phase1.v3.asn.hg19", "1kg/p1v3/ASN/1kg.phase1.v3.shapeit2.asn.hg19.chr_CHROM_.vcf.gz");
        this.PUBDB_URL_MAP.put("1kg.phase1.v3.eur.hg19", "1kg/p1v3/EUR/1kg.phase1.v3.shapeit2.eur.hg19.chr_CHROM_.vcf.gz");
        this.PUBDB_URL_MAP.put("1kg.phase1.v3.afr.hg19", "1kg/p1v3/AFR/1kg.phase1.v3.shapeit2.afr.hg19.chr_CHROM_.vcf.gz");
        this.PUBDB_URL_MAP.put("1kg.phase1.v3.amr.hg19", "1kg/p1v3/AMR/1kg.phase1.v3.shapeit2.amr.hg19.chr_CHROM_.vcf.gz");
        this.PUBDB_URL_MAP.put("1kg.phase3.v5.eas.hg19", "1kg/p3v5/EAS/1kg.phase3.v5.shapeit2.eas.hg19.chr_CHROM_.vcf.gz");
        this.PUBDB_URL_MAP.put("1kg.phase3.v5.sas.hg19", "1kg/p3v5/SAS/1kg.phase3.v5.shapeit2.sas.hg19.chr_CHROM_.vcf.gz");
        this.PUBDB_URL_MAP.put("1kg.phase3.v5.eur.hg19", "1kg/p3v5/EUR/1kg.phase3.v5.shapeit2.eur.hg19.chr_CHROM_.vcf.gz");
        this.PUBDB_URL_MAP.put("1kg.phase3.v5.afr.hg19", "1kg/p3v5/AFR/1kg.phase3.v5.shapeit2.afr.hg19.chr_CHROM_.vcf.gz");
        this.PUBDB_URL_MAP.put("1kg.phase3.v5.amr.hg19", "1kg/p3v5/AMR/1kg.phase3.v5.shapeit2.amr.hg19.chr_CHROM_.vcf.gz");
        this.PUBDB_URL_MAP.put("1kg.phase1.v3.all.hg19", "ALL/1kg.phase1.v3.shapeit2.all.hg19.chr_CHROM_.vcf.gz");
        this.pvalueFileNameList = new ArrayList();
        this.headerList = new ArrayList();
        this.pvalueMarkerList = new ArrayList();
        this.pvalueIndexList = new ArrayList();
        this.genotypeFileList = new ArrayList();
        this.sampleSizeList = new ArrayList();
        this.resultFileNameList = new ArrayList();
    }

    public void getResourceFolder(StringBuilder stringBuilder) {
        int n = this.a("--resource");
        if (n >= 0) {
            this.resourceFolder = this.a[n + 1];
            stringBuilder.append("--resource");
            stringBuilder.append(' ');
            stringBuilder.append(this.resourceFolder);
            stringBuilder.append('\n');
        }
    }

    public boolean noWebCheck() {
        int n = this.a("--no-web");
        return n >= 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parseOptions(StringBuilder stringBuilder) {
        block84: {
            block88: {
                void var3_23;
                String string;
                int n;
                int n2;
                int n3;
                block85: {
                    int n4;
                    block87: {
                        block86: {
                            String[] stringArray;
                            Object object;
                            void var3_8;
                            n3 = -1;
                            n3 = this.a("--nt");
                            if (n3 >= 0) {
                                this.threadNum = Integer.parseInt(this.a[n3 + 1]);
                                stringBuilder.append("--nt");
                                stringBuilder.append(' ');
                                stringBuilder.append(this.threadNum);
                                stringBuilder.append('\n');
                            }
                            if ((n3 = this.a("--impute")) >= 0) {
                                if (this.command != null) {
                                    String string2 = "You cannot use " + this.command + " and --impute at the same time!";
                                    throw new Exception(string2);
                                }
                                this.command = "--impute";
                                stringBuilder.append("--impute");
                                stringBuilder.append('\n');
                                this.pImpute = true;
                            } else {
                                this.pImpute = false;
                            }
                            n3 = this.a("--qc");
                            if (n3 >= 0) {
                                if (this.command != null) {
                                    String string3 = "You cannot use " + this.command + " and --qc at the same time!";
                                    throw new Exception(string3);
                                }
                                this.command = "--qc";
                                stringBuilder.append("--qc");
                                stringBuilder.append('\n');
                                this.pQC = true;
                            } else {
                                this.pQC = false;
                            }
                            n3 = this.a("--meta");
                            if (n3 >= 0) {
                                if (this.command != null) {
                                    String string4 = "You cannot use " + this.command + " and --meta at the same time!";
                                    throw new Exception(string4);
                                }
                                this.command = "--meta";
                                stringBuilder.append("--meta");
                                stringBuilder.append('\n');
                                this.pMeta = true;
                            } else {
                                this.pMeta = false;
                            }
                            n3 = this.a("--noimpute");
                            if (n3 >= 0) {
                                stringBuilder.append("--noimpute");
                                stringBuilder.append('\n');
                                this.noimpute = true;
                            } else {
                                this.noimpute = false;
                            }
                            if (this.command == null) {
                                String string5 = "No function command, You can specify it by  --impute or --qc or --meta !";
                                throw new Exception(string5);
                            }
                            n3 = this.a("--pfile");
                            if (n3 < 0) {
                                String string6 = "No --pfile option to get input p-values";
                                throw new Exception(string6);
                            }
                            stringBuilder.append("--pfile");
                            stringBuilder.append(' ');
                            stringBuilder.append(this.a[n3 + 1]);
                            stringBuilder.append('\n');
                            this.pvalueFileNameList.addAll(Arrays.asList(this.a[n3 + 1].split(",")));
                            boolean bl = false;
                            while (var3_8 < this.pvalueFileNameList.size()) {
                                object = new File((String)this.pvalueFileNameList.get((int)var3_8));
                                stringArray = null;
                                if (((File)object).exists() && ((File)object).getName().endsWith(".zip")) {
                                    stringArray = new CompressedFileReader((File)object);
                                } else if (((File)object).exists() && ((File)object).getName().endsWith(".gz")) {
                                    stringArray = new CompressedFileReader((File)object);
                                } else {
                                    if (!((File)object).exists()) {
                                        throw new Exception("No pvalue file: " + ((File)object).getCanonicalPath());
                                    }
                                    stringArray = new AsciiLineReader((File)object);
                                }
                                this.headerList.add(stringArray.readLine());
                                stringArray.close();
                                ++var3_8;
                            }
                            n3 = this.a("--gfile");
                            if (n3 < 0) {
                                String string7 = "No --gfile option to specify the reference genotypes!";
                                throw new Exception(string7);
                            }
                            stringBuilder.append("--gfile");
                            stringBuilder.append(' ');
                            stringBuilder.append(this.a[n3 + 1]);
                            stringBuilder.append('\n');
                            String[] stringArray2 = this.a[n3 + 1].split(",");
                            object = new HashMap();
                            if (stringArray2.length < this.pvalueFileNameList.size()) {
                                stringArray = "Not enough genotpye files of --gfile option. [Each pvalue file has mapped with one genotype file]";
                                throw new Exception((String)stringArray);
                            }
                            stringArray = stringArray2;
                            n2 = stringArray.length;
                            for (n = 0; n < n2; ++n) {
                                Object object2;
                                string = stringArray[n];
                                if (string.indexOf("::") < 0) {
                                    String string8 = "--gfile option have to include file name and file type seperated by colon eg, --gfile path/to/file1::vcf,path/to/file2::plink";
                                    throw new Exception(string8);
                                }
                                object.put(string, (byte)0);
                                String[] stringArray3 = string.split("::");
                                if (stringArray3[1].equals("vcf")) {
                                    GenotypeFile genotypeFile;
                                    object2 = stringArray3[0];
                                    String string9 = (String)this.PUBDB_URL_MAP.get(object2);
                                    if (string9 != null) {
                                        if (string9.indexOf("_CHROM_") >= 0) {
                                            for (int i = 0; i < 23; ++i) {
                                                this.downloadList.add(string9.replaceAll("_CHROM_", CHROM_NAMES[i]));
                                            }
                                        } else {
                                            this.downloadList.add(string9);
                                        }
                                        if (string9.startsWith("hapmap")) {
                                            genotypeFile = new GenotypeFile(GlobalManager.RESOURCE_PATH + "hapmap/" + (String)object2 + ".chr_CHROM_.vcf.gz", "--vcf");
                                            this.genotypeFileList.add(genotypeFile);
                                            continue;
                                        }
                                        genotypeFile = new GenotypeFile(GlobalManager.RESOURCE_PATH + string9, "--vcf");
                                        this.genotypeFileList.add(genotypeFile);
                                        continue;
                                    }
                                    genotypeFile = new GenotypeFile((String)object2, "--vcf");
                                    this.genotypeFileList.add(genotypeFile);
                                    continue;
                                }
                                if (!stringArray3[1].equals("plink")) {
                                    object2 = "--gfile option have to include file name and file type seperated by colon eg, --gfile path/to/file1::vcf,path/to/file2::plink";
                                    throw new Exception((String)object2);
                                }
                                object2 = new GenotypeFile(stringArray3[0], "--plink");
                                this.genotypeFileList.add(object2);
                            }
                            if (object.size() == 1) {
                                this.sameGenotypeFile = true;
                            }
                            if ((n3 = this.a("--p-col")) >= 0) {
                                stringBuilder.append("--p-col");
                                stringBuilder.append(' ');
                                stringBuilder.append(this.a[n3 + 1]);
                                stringBuilder.append('\n');
                                String[] stringArray4 = this.a[n3 + 1].split(",");
                                this.pvalueMarkerList.addAll(Arrays.asList(stringArray4));
                                if (this.pvalueMarkerList.size() != this.pvalueFileNameList.size()) {
                                    object = "The --p-col option must have the same number of values as the p-value files!!!";
                                    throw new Exception((String)object);
                                }
                            } else {
                                String string10 = "No --p-col option to get p-value column number in the p-value file";
                                this.pvalueIndexList = new ArrayList();
                                for (int i = 0; i < this.pvalueFileNameList.size(); ++i) {
                                    this.pvalueIndexList.add(3);
                                }
                            }
                            if (this.command == null || !this.command.equals("--meta")) break block85;
                            n3 = this.a("--size");
                            if (n3 >= 0) break block86;
                            String string11 = "No --size option as sample size to weight p-value for meta analysis";
                            int n5 = this.a("--meta");
                            if (n5 >= 0 && (this.sampleSizeList == null || this.sampleSizeList.isEmpty())) {
                                for (int i = 0; i < this.pvalueFileNameList.size(); ++i) {
                                    this.sampleSizeList.add(1.0);
                                }
                            }
                            break block87;
                        }
                        stringBuilder.append("--size");
                        stringBuilder.append(' ');
                        stringBuilder.append(this.a[n3 + 1]);
                        stringBuilder.append('\n');
                        String[] stringArray = this.a[n3 + 1].split(",");
                        double d2 = 0.0;
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            if (stringArray[n2].indexOf(58) >= 0) {
                                String[] stringArray5 = stringArray[n2].split(":");
                                d2 = 1.0 / (double)Integer.parseInt(stringArray5[0]) + 1.0 / (double)Integer.parseInt(stringArray5[1]);
                                d2 = 4.0 / d2;
                            } else {
                                d2 = Integer.parseInt(stringArray[n2]);
                            }
                            this.sampleSizeList.add(Math.sqrt(d2));
                        }
                    }
                    double d3 = 0.0;
                    for (n4 = 0; n4 < this.sampleSizeList.size(); d3 += ((Double)this.sampleSizeList.get(n4)).doubleValue(), ++n4) {
                    }
                    for (n4 = 0; n4 < this.sampleSizeList.size(); ++n4) {
                        this.sampleSizeList.set(n4, (Double)this.sampleSizeList.get(n4) / d3);
                    }
                }
                if ((n3 = this.a("--chrom-col")) >= 0) {
                    this.chromMarker = this.a[n3 + 1];
                    stringBuilder.append("--chrom-col");
                    stringBuilder.append(' ');
                    stringBuilder.append(this.chromMarker);
                    stringBuilder.append('\n');
                } else {
                    String string12 = "No --chrom-col option to get chromosome column number in the p-value file";
                }
                n3 = this.a("--marker-col");
                if (n3 >= 0) {
                    this.IDMarker = this.a[n3 + 1];
                    stringBuilder.append("--marker-col");
                    stringBuilder.append(' ');
                    stringBuilder.append(this.IDMarker);
                    stringBuilder.append('\n');
                } else {
                    String string13 = "No --marker-col option to get marker name  in the p-value file";
                }
                n3 = this.a("--position-col");
                if (n3 >= 0) {
                    this.positionMarker = this.a[n3 + 1];
                    stringBuilder.append("--position-col");
                    stringBuilder.append(' ');
                    stringBuilder.append(this.positionMarker);
                    stringBuilder.append('\n');
                } else {
                    String string14 = "No --position-col option to get marker position column number in the p-value file";
                }
                boolean bl = false;
                while (var3_23 < this.pvalueMarkerList.size()) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)this.headerList.get((int)var3_23));
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    n3 = this.a(arrayList, (String)this.pvalueMarkerList.get((int)var3_23));
                    if (n3 < 0) {
                        String string15 = "No p-value name: " + (String)this.pvalueMarkerList.get((int)var3_23) + " in" + (String)this.pvalueFileNameList.get((int)var3_23) + " p-value file";
                        throw new Exception(string15);
                    }
                    this.pvalueIndexList.add(n3);
                    if (this.chromMarker != null) {
                        n3 = this.a(arrayList, this.chromMarker);
                        if (n3 < 0) {
                            String string16 = "No chromosome name: " + this.chromMarker + " in " + (String)this.pvalueFileNameList.get((int)var3_23) + " p-value file";
                            throw new Exception(string16);
                        }
                        this.chromIndex = n3;
                    }
                    if (this.IDMarker != null) {
                        n3 = this.a(arrayList, this.IDMarker);
                        if (n3 <= 0) {
                            String string17 = "No marker name: " + this.IDMarker + " in " + (String)this.pvalueFileNameList.get((int)var3_23) + " p-value file";
                            throw new Exception(string17);
                        }
                        this.markerIDIndex = n3;
                    }
                    if (this.positionMarker != null) {
                        n3 = this.a(arrayList, this.positionMarker);
                        if (n3 <= 0) {
                            String string18 = "No position name: " + this.positionMarker + " in" + (String)this.pvalueFileNameList.get((int)var3_23) + " p-value file";
                            throw new Exception(string18);
                        }
                        this.markerPositionIndex = n3;
                    }
                    ++var3_23;
                }
                n3 = this.a("--missing-p");
                if (n3 >= 0) {
                    this.missingPValueLabel = this.a[n3 + 1];
                    stringBuilder.append("--missing-p");
                    stringBuilder.append(' ');
                    stringBuilder.append(this.missingPValueLabel);
                    stringBuilder.append('\n');
                } else {
                    String string19 = "No --missing-p option to get p-value column number in the p-value file";
                }
                n3 = this.a("--maf");
                if (n3 >= 0) {
                    this.mafThreshold = Double.parseDouble(this.a[n3 + 1]);
                    stringBuilder.append("--maf");
                    stringBuilder.append(' ');
                    stringBuilder.append(this.mafThreshold);
                    stringBuilder.append('\n');
                } else if (this.a("--gfile") >= 0 || this.a("--linkage-file") >= 0) {
                    String string20 = "To set minimal minor allele frequencies, please set --maf x tag. The default is --maf " + this.mafThreshold + ".";
                    System.out.println(string20);
                }
                n3 = this.a("--conf-filter");
                if (n3 >= 0) {
                    this.varianceFilter = Double.parseDouble(this.a[n3 + 1]);
                    stringBuilder.append("--conf-filter");
                    stringBuilder.append(' ');
                    stringBuilder.append(this.varianceFilter);
                    stringBuilder.append('\n');
                    this.varianceFilter = 1.0 - this.varianceFilter;
                }
                if ((n3 = this.a("--window-len")) >= 0) {
                    this.windowLen = Integer.parseInt(this.a[n3 + 1]);
                    stringBuilder.append("--window-len");
                    stringBuilder.append(' ');
                    stringBuilder.append(this.windowLen);
                    stringBuilder.append('\n');
                    this.windowLen /= 2;
                }
                if ((n3 = this.a("--window-size")) >= 0) {
                    this.windowSize = Integer.parseInt(this.a[n3 + 1]);
                    stringBuilder.append("--window-size");
                    stringBuilder.append(' ');
                    stringBuilder.append(this.windowSize);
                    stringBuilder.append('\n');
                    this.windowSize /= 2;
                }
                if ((n3 = this.a("--ignore-r2")) >= 0) {
                    this.weakCorrelationThreshold = Double.parseDouble(this.a[n3 + 1]);
                    stringBuilder.append("--ignore-r2");
                    stringBuilder.append(' ');
                    stringBuilder.append(this.weakCorrelationThreshold);
                    stringBuilder.append('\n');
                }
                if ((n3 = this.a("--genome")) >= 0) {
                    void var3_27;
                    this.regions = new HashMap();
                    boolean bl2 = false;
                    while (var3_27 < CHROM_NAMES.length) {
                        this.regions.put(CHROM_NAMES[var3_27], new int[]{-9, -9});
                        ++var3_27;
                    }
                    stringBuilder.append("--genome");
                    stringBuilder.append('\n');
                } else {
                    n3 = this.a("--regions");
                    if (n3 >= 0) {
                        String string21 = "\nWrong --regions format, the correct one is like: --regions chr1,chr2:2323-34434,chr2:43455-345555";
                        try {
                            String string22 = this.a[n3 + 1];
                            stringBuilder.append("--regions");
                            stringBuilder.append(' ');
                            stringBuilder.append(string22);
                            stringBuilder.append('\n');
                            String[] stringArray = string22.split(",");
                            this.regions = new HashMap();
                            for (n2 = 0; n2 < stringArray.length; ++n2) {
                                void var9_60;
                                stringArray[n2] = stringArray[n2].trim();
                                n = stringArray[n2].indexOf(58);
                                if (n < 0) {
                                    string = stringArray[n2].substring(3);
                                    this.regions.put(string, new int[]{-9, -9});
                                    continue;
                                }
                                string = stringArray[n2].substring(0, stringArray[n2].indexOf(58));
                                int[] nArray = (int[])this.regions.get(string = string.substring(3));
                                if (nArray == null) {
                                    int[] nArray2 = new int[2];
                                } else {
                                    int[] nArray3 = new int[nArray.length];
                                    System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                                    int[] nArray4 = new int[nArray.length + 2];
                                    System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
                                }
                                stringArray[n2] = stringArray[n2].substring(n + 1);
                                n = stringArray[n2].indexOf("-");
                                if (n < 0) continue;
                                int n6 = Integer.parseInt(stringArray[n2].substring(0, n));
                                int n7 = Integer.parseInt(stringArray[n2].substring(n + 1));
                                var9_60[((void)var9_60).length - 2] = n6;
                                var9_60[((void)var9_60).length - 1] = n7;
                                this.regions.put(string, var9_60);
                            }
                        }
                        catch (Exception exception) {
                            throw new Exception(exception.toString() + "\n" + string21);
                        }
                    } else {
                        void var3_30;
                        this.regions = new HashMap();
                        boolean bl3 = false;
                        while (var3_30 < CHROM_NAMES.length) {
                            this.regions.put(CHROM_NAMES[var3_30], new int[]{-9, -9});
                            ++var3_30;
                        }
                    }
                }
                n3 = this.a("--out");
                if (n3 < 0) break block88;
                stringBuilder.append("--out");
                stringBuilder.append(' ');
                stringBuilder.append(this.a[n3 + 1]);
                stringBuilder.append('\n');
                if (Arrays.asList(this.a[n3 + 1].split(",")).size() == this.pvalueFileNameList.size() || this.pImpute) {
                    this.resultFileNameList.addAll(Arrays.asList(this.a[n3 + 1].split(",")));
                    break block84;
                } else if (this.pMeta) {
                    this.resultFileNameList.add(this.a[n3 + 1]);
                    break block84;
                } else {
                    if (!this.noimpute) {
                        String string23 = "No enough --out files to save result data of each pvalue file";
                        throw new Exception(string23);
                    }
                    this.resultFileNameList.add(this.a[n3 + 1]);
                }
                break block84;
            }
            String string = "No --out option to save result data!";
            this.resultFileNameList.add("pi");
        }
        System.out.println("Effective settings :");
        System.out.println(stringBuilder);
        return true;
    }

    public void readOptions(String string) {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = "";
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).length() == 0 || string2.startsWith("//")) continue;
            n = string2.indexOf("//");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringBuilder.append(stringTokenizer.nextToken().trim()).toString());
                stringBuilder.delete(0, stringBuilder.length());
            }
            ++n2;
        }
        bufferedReader.close();
        this.b = arrayList.size();
        this.a = new String[this.b];
        for (n = 0; n < this.b; ++n) {
            this.a[n] = (String)arrayList.get(n);
        }
    }

    public void readOptions(String[] stringArray) {
        this.b = stringArray.length;
        this.a = new String[this.b];
        System.arraycopy(stringArray, 0, this.a, 0, this.b);
    }
}

