/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.util.download;

import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.cobi.util.download.DownloadTaskBean;
import org.cobi.util.download.DownloadThread;
import org.cobi.util.download.DownloadThreadEvent;
import org.cobi.util.download.HttpClient4DownloadTask;
import org.cobi.util.net.ProxyBean;

public class HttpClient4DownloadThread
extends DownloadThread
implements Callable {
    public HttpClient4DownloadThread(int n, DownloadTaskBean downloadTaskBean, ProxyBean proxyBean) {
        super(n, downloadTaskBean, proxyBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String call() {
        Object object;
        Cloneable cloneable;
        if (HttpClient4DownloadTask.getDebug()) {
            System.out.println("Thread:" + this.sectionID + " Start:" + this.taskBean.getSectionsOffset()[this.sectionID] + "-" + this.taskBean.getSectionsEnd()[this.sectionID]);
        }
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        if (this.proxyBean != null && this.proxyBean.getProxyHost() != null && this.proxyBean.getProxyPort() != null) {
            cloneable = new HttpHost(this.proxyBean.getProxyHost(), Integer.parseInt(this.proxyBean.getProxyPort()));
            if (this.proxyBean.getProxyUserName() != null && this.proxyBean.getProxyPassword() != null) {
                object = new BasicCredentialsProvider();
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.proxyBean.getProxyUserName(), this.proxyBean.getProxyPassword());
                object.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), usernamePasswordCredentials);
                defaultHttpClient.getParams().setParameter("http.route.default-proxy", cloneable);
                defaultHttpClient.setCredentialsProvider((CredentialsProvider)object);
            } else {
                defaultHttpClient.getParams().setParameter("http.route.default-proxy", cloneable);
            }
        }
        try {
            cloneable = new HttpGet(this.taskBean.getDownURL());
            if (this.taskBean.isIsRange()) {
                ((AbstractHttpMessage)((Object)cloneable)).addHeader("Range", "bytes=" + this.taskBean.getSectionsOffset()[this.sectionID] + "-" + this.taskBean.getSectionsEnd()[this.sectionID]);
            }
            object = defaultHttpClient.execute((HttpUriRequest)((Object)cloneable));
            int n = object.getStatusLine().getStatusCode();
            if (HttpClient4DownloadTask.getDebug()) {
                for (Header header : object.getAllHeaders()) {
                    System.out.println(header.getName() + ":" + header.getValue());
                }
                System.out.println("statusCode:" + n);
            }
            if (n == 206 || n == 200 && !this.taskBean.isIsRange()) {
                InputStream inputStream = object.getEntity().getContent();
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.taskBean.getSaveFile() + ".save", "rw");
                long l = this.taskBean.getSectionsOffset()[this.sectionID];
                randomAccessFile.seek(this.taskBean.getSectionsOffset()[this.sectionID]);
                int n2 = 0;
                byte[] byArray = new byte[10240];
                while (this.notStop && (n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    randomAccessFile.write(byArray, 0, n2);
                    this.taskBean.getSectionsOffset()[this.sectionID] = l += (long)n2;
                    this.fireAfterPerDown(new DownloadThreadEvent(this, n2));
                }
                randomAccessFile.close();
                if (this.notStop) {
                    EntityUtils.consume(object.getEntity());
                }
            }
            ((AbstractExecutionAwareRequest)cloneable).abort();
        }
        finally {
            this.fireDownCompleted(new DownloadThreadEvent(this, this.taskBean.getSectionsEnd()[this.sectionID]));
            if (HttpClient4DownloadTask.getDebug()) {
                System.out.println("End:" + this.taskBean.getSectionsOffset()[this.sectionID] + "-" + this.taskBean.getSectionsEnd()[this.sectionID]);
            }
            defaultHttpClient.getConnectionManager().shutdown();
        }
        return "Download thread " + this.sectionID + " over";
    }
}

