/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.util.download;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cobi.util.download.OriginalJavaTaskBean;
import org.cobi.util.download.f;

public class OriginalJavaTaskAssign {
    long a = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work(OriginalJavaTaskBean originalJavaTaskBean) {
        File file = new File(originalJavaTaskBean.getSaveFile());
        this.a = this.getContentLength(originalJavaTaskBean.getDownURL());
        if (file.exists()) {
            if (this.a == file.length()) {
                System.out.println("The file " + file.getName() + " has the same size as the one to be downloaded. No need to download it!");
                return;
            }
            file.delete();
            System.out.println("The file " + file.getName() + " will be overwritten");
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        File file2 = new File(originalJavaTaskBean.getSaveFile() + ".r_task");
        File file3 = new File(originalJavaTaskBean.getSaveFile() + ".r_save");
        boolean bl = file2.exists();
        RandomAccessFile randomAccessFile = null;
        RandomAccessFile randomAccessFile2 = null;
        try {
            randomAccessFile = new RandomAccessFile(file2, "rw");
            randomAccessFile2 = new RandomAccessFile(file3, "rw");
            if (!bl) {
                originalJavaTaskBean.setContentLength(this.a);
                this.initTaskFile(randomAccessFile, originalJavaTaskBean);
                randomAccessFile2.setLength(this.a);
            } else {
                originalJavaTaskBean.read(randomAccessFile);
                if (originalJavaTaskBean.getContentLength() != this.a) {
                    throw new RuntimeException();
                }
            }
            int n = originalJavaTaskBean.getSectionCount();
            ExecutorService executorService = Executors.newFixedThreadPool(originalJavaTaskBean.getWorkerCount());
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                OriginalJavaTaskBean originalJavaTaskBean2 = originalJavaTaskBean;
                RandomAccessFile randomAccessFile3 = randomAccessFile;
                RandomAccessFile randomAccessFile4 = randomAccessFile2;
                executorService.execute(new f(this, randomAccessFile3, randomAccessFile4, originalJavaTaskBean2, n3, atomicBoolean));
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(86400L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            randomAccessFile.close();
            randomAccessFile = null;
            randomAccessFile2.close();
            randomAccessFile2 = null;
            if (atomicBoolean.get()) {
                file2.delete();
                file3.renameTo(file);
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
                randomAccessFile = null;
            }
            if (randomAccessFile2 != null) {
                randomAccessFile2.close();
                randomAccessFile2 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, OriginalJavaTaskBean originalJavaTaskBean, int n) {
        Object object;
        URL uRL = new URL(originalJavaTaskBean.getDownURL());
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        long l = originalJavaTaskBean.getSectionsOffset()[n];
        long l2 = -1L;
        if (n < originalJavaTaskBean.getSectionCount() - 1) {
            long l3 = originalJavaTaskBean.getContentLength() / (long)originalJavaTaskBean.getSectionCount();
            l2 = l3 * (long)(n + 1);
        } else {
            l2 = originalJavaTaskBean.getContentLength();
        }
        if (l >= l2) {
            String string = "Section has finished before. " + n;
            System.out.println(string);
            return;
        }
        String string = "bytes=" + l + "-" + (l2 - 1L);
        httpURLConnection.setRequestProperty("Range", string);
        httpURLConnection.setRequestProperty("User-Agent", "Ray-Downer");
        try {
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 206) {
                throw new RuntimeException();
            }
            if ((long)httpURLConnection.getContentLength() != l2 - l) {
                throw new RuntimeException();
            }
            object = httpURLConnection.getInputStream();
            byte[] byArray = new byte[originalJavaTaskBean.getBufferSize()];
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object, byArray.length);
            int n2 = 0;
            while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                long l4 = originalJavaTaskBean.getSectionsOffset()[n];
                OriginalJavaTaskBean originalJavaTaskBean2 = originalJavaTaskBean;
                synchronized (originalJavaTaskBean2) {
                    randomAccessFile2.seek(l4);
                    randomAccessFile2.write(byArray, 0, n2);
                    originalJavaTaskBean.getSectionsOffset()[n] = l4 += (long)n2;
                    originalJavaTaskBean.writeOffset(randomAccessFile);
                }
            }
            ((InputStream)object).close();
            bufferedInputStream.close();
        }
        finally {
            httpURLConnection.disconnect();
        }
        object = "Section finished. " + n;
        System.out.println((String)object);
    }

    public void initTaskFile(RandomAccessFile randomAccessFile, OriginalJavaTaskBean originalJavaTaskBean) {
        int n = originalJavaTaskBean.getSectionCount();
        long l = originalJavaTaskBean.getContentLength() / (long)n;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = l * (long)i;
        }
        originalJavaTaskBean.setSectionsOffset(lArray);
        originalJavaTaskBean.create(randomAccessFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength(String string) {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        try {
            long l = httpURLConnection.getContentLength();
            return l;
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        OriginalJavaTaskBean originalJavaTaskBean = new OriginalJavaTaskBean();
        originalJavaTaskBean.setDownURL("http://dlc2.pconline.com.cn/filedown.jsp?dlid=53944&linkid=6444611");
        try {
            originalJavaTaskBean.setSaveFile("D:/xx1.exe");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        originalJavaTaskBean.setSectionCount(10);
        originalJavaTaskBean.setWorkerCount(10);
        originalJavaTaskBean.setBufferSize(131072);
    }
}

