/*
 * Decompiled with CFR 0.152.
 */
package org.cobi.util.plot;

import cern.colt.list.AbstractDoubleList;
import cern.colt.list.AbstractList;
import cern.colt.list.DoubleArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.stat.Descriptive;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.samtools.util.AsciiLineReader;
import net.sf.samtools.util.CompressedFileReader;
import net.sf.samtools.util.LineReader;
import org.cobi.util.plot.BasicPainter;
import org.cobi.util.plot.BasicPainter$CoordinateTransformer;
import umontreal.iro.lecuyer.probdist.BetaDist;

public class PValuePainter
extends BasicPainter {
    public PValuePainter(int n, int n2) {
        super(n, n2);
    }

    public int drawQQPlot(DoubleArrayList doubleArrayList, String string, String string2, double d2) {
        if (doubleArrayList == null || doubleArrayList.size() == 0) {
            System.err.println("Null p-value list");
            return -1;
        }
        if (string != null && string.length() > 0) {
            this.calculateDataPlottingArea(true);
        } else {
            this.calculateDataPlottingArea(false);
        }
        DoubleArrayList doubleArrayList2 = doubleArrayList.copy();
        BufferedImage bufferedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(graphics2D);
        int n = doubleArrayList2.size();
        doubleArrayList2.quickSort();
        double d3 = -Math.log10(doubleArrayList2.getQuick(0));
        double d4 = -Math.log10(doubleArrayList2.getQuick(n - 1));
        double d5 = 0.0;
        double d6 = -Math.log10(1.0 / (double)(n + 1));
        if (d3 > -Math.log10(d2)) {
            d3 = -Math.log10(d2);
        }
        BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer = new BasicPainter$CoordinateTransformer(this);
        basicPainter$CoordinateTransformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, d5, d6, d4, d3);
        int n2 = this.drawAxesScale(graphics2D, basicPainter$CoordinateTransformer);
        this.drawAxes(graphics2D, string, "Expected [-log10(P)]", "Observed [-log10(P)]", n2);
        Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(0.0, 0.0);
        Point point2 = basicPainter$CoordinateTransformer.data2ScreenPoint(Math.min(d6, d3), Math.min(d6, d3));
        Line2D.Double double_ = new Line2D.Double(point, point2);
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.GREEN);
        graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
        graphics2D.draw(double_);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        int n3 = 2;
        double d7 = 0.05;
        int n4 = -1;
        double d8 = 4.0;
        int n5 = n + 1;
        for (int i = 0; i < n; ++i) {
            double d9 = -Math.log10((double)(i + 1) / (double)n5);
            double d10 = -Math.log10(doubleArrayList2.getQuick(i));
            if (d10 <= d3) {
                basicPainter$CoordinateTransformer.data2ScreenPoint(point, d9, d10);
                graphics2D.drawRect(point.x - n3 / 2, point.y - n3 / 2, n3, n3);
                continue;
            }
            d10 = d3;
            basicPainter$CoordinateTransformer.data2ScreenPoint(point, d9, d10);
            double d11 = point.getX();
            double d12 = point.getY();
            graphics2D.setColor(Color.red);
            this.plotTriangle(graphics2D, (int)d11, (int)d12, (int)d8);
            graphics2D.setColor(color);
        }
        graphics2D.dispose();
        PValuePainter.outputPNGFile(bufferedImage, string2);
        return n4;
    }

    public void drawMultipleQQPlot(List list, List list2, String string, String string2, double d2) {
        Object object;
        double d3;
        int n;
        if (list == null || list.isEmpty()) {
            System.err.println("Null p-value list");
            return;
        }
        int n2 = list.size();
        for (n = n2 - 1; n >= 0; --n) {
            if (list.get(n) != null && ((DoubleArrayList)list.get(n)).size() != 0) continue;
            System.err.println("Null p-value list");
            list.remove(n);
        }
        if (list == null || list.isEmpty()) {
            System.err.println("Null p-value list");
            return;
        }
        n = ((DoubleArrayList)list.get(0)).size();
        if (string != null && string.length() > 0) {
            this.calculateDataPlottingArea(true);
        } else {
            this.calculateDataPlottingArea(false);
        }
        double d4 = d3 = ((DoubleArrayList)list.get(0)).getQuick(0);
        double d5 = 0.0;
        double d6 = 1.0 / (double)n;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            object = (DoubleArrayList)list.get(i);
            ((AbstractList)object).quickSort();
            n = ((AbstractDoubleList)object).size();
            for (int j = 0; j < n; ++j) {
                if (d3 > ((DoubleArrayList)object).getQuick(j)) {
                    d3 = ((DoubleArrayList)object).getQuick(j);
                    continue;
                }
                if (!(d4 < ((DoubleArrayList)object).getQuick(j))) continue;
                d4 = ((DoubleArrayList)object).getQuick(j);
            }
            if (d6 > 1.0 / (double)(n + 1)) {
                d6 = 1.0 / (double)(n + 1);
            }
            if (n3 >= n) continue;
            n3 = n;
        }
        d4 = -Math.log10(d4);
        d3 = -Math.log10(d3);
        d6 = -Math.log10(d6);
        if (d3 > -Math.log10(d2)) {
            d3 = -Math.log10(d2);
        }
        BufferedImage bufferedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        object = bufferedImage.createGraphics();
        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas((Graphics2D)object);
        BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer = new BasicPainter$CoordinateTransformer(this);
        basicPainter$CoordinateTransformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, d5, d6, d4, d3);
        int n4 = this.drawAxesScale((Graphics2D)object, basicPainter$CoordinateTransformer);
        this.drawAxes((Graphics2D)object, string, "Expected [-log10(P)]", "Observed [-log10(P)]", n4);
        Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(0.0, 0.0);
        Point point2 = basicPainter$CoordinateTransformer.data2ScreenPoint(Math.min(d6, d3), Math.min(d6, d3));
        Line2D.Double double_ = new Line2D.Double(point, point2);
        Stroke stroke = ((Graphics2D)object).getStroke();
        Color color = ((Graphics)object).getColor();
        ((Graphics)object).setColor(Color.GREEN);
        ((Graphics2D)object).setStroke(new BasicStroke(2.0f, 1, 1));
        ((Graphics2D)object).draw(double_);
        int n5 = 2;
        int n6 = n5 / 2;
        int n7 = 4;
        double d7 = 0.05;
        Color[] colorArray = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.MAGENTA, Color.BLACK, Color.PINK, Color.CYAN};
        int n8 = ((Graphics)object).getFontMetrics().getHeight();
        double d8 = 6.0;
        double d9 = 6.0;
        ((Graphics2D)object).setStroke(stroke);
        Font font = ((Graphics)object).getFont();
        ((Graphics)object).setFont(this.numFont);
        int n9 = ((Graphics)object).getFontMetrics().stringWidth((String)list2.get(n2 - 1));
        for (int i = n2 - 2; i >= 0; --i) {
            int n10 = ((Graphics)object).getFontMetrics().stringWidth((String)list2.get(i));
            if (n9 >= n10) continue;
            n9 = n10;
        }
        BetaDist betaDist = null;
        Point point3 = new Point();
        Point point4 = new Point();
        Point point5 = new Point();
        Point point6 = new Point();
        betaDist = new BetaDist(1.0, n3);
        double d10 = betaDist.inverseF(0.5);
        d10 = -Math.log10(d10);
        double d11 = betaDist.inverseF(0.025);
        d11 = -Math.log10(d11);
        basicPainter$CoordinateTransformer.data2ScreenPoint(point3, d10, d11);
        double d12 = betaDist.inverseF(0.975);
        d12 = -Math.log10(d12);
        basicPainter$CoordinateTransformer.data2ScreenPoint(point5, d10, d12);
        ((Graphics)object).setColor(Color.BLACK);
        float[] fArray = new float[]{3.0f};
        ((Graphics2D)object).setStroke(new BasicStroke(0.5f, 1, 1, 10.0f, fArray, 0.0f));
        int n11 = 2;
        while (n11 <= n3) {
            betaDist = new BetaDist(n11, n3 + 1 - n11);
            d10 = betaDist.inverseF(0.5);
            d10 = -Math.log10(d10);
            d11 = betaDist.inverseF(0.025);
            d11 = -Math.log10(d11);
            basicPainter$CoordinateTransformer.data2ScreenPoint(point4, d10, d11);
            ((Graphics)object).drawLine(point3.x, point3.y, point4.x, point4.y);
            point3.x = point4.x;
            point3.y = point4.y;
            d12 = betaDist.inverseF(0.975);
            d12 = -Math.log10(d12);
            basicPainter$CoordinateTransformer.data2ScreenPoint(point6, d10, d12);
            ((Graphics)object).drawLine(point5.x, point5.y, point6.x, point6.y);
            point5.x = point6.x;
            point5.y = point6.y;
            if (n11 <= 2000) {
                ++n11;
                continue;
            }
            n11 += n11;
        }
        ((Graphics2D)object).setStroke(stroke);
        for (n11 = n2 - 1; n11 >= 0; --n11) {
            DoubleArrayList doubleArrayList = (DoubleArrayList)list.get(n11);
            n = doubleArrayList.size();
            ((Graphics)object).setColor(colorArray[n11]);
            int n12 = n + 1;
            for (int i = 0; i < n; ++i) {
                double d13 = -Math.log10((double)(i + 1) / (double)n12);
                double d14 = -Math.log10(doubleArrayList.getQuick(i));
                if (d14 <= d3) {
                    basicPainter$CoordinateTransformer.data2ScreenPoint(point, d13, d14);
                    ((Graphics)object).drawRect(point.x - n6, point.y - n6, n5, n5);
                    if (n11 % 3 == 1 || n11 % 3 == 2 || n11 % 3 != 0) continue;
                    continue;
                }
                d14 = d3;
                basicPainter$CoordinateTransformer.data2ScreenPoint(point, d13, d14);
                d10 = point.getX();
                double d15 = point.getY();
                this.plotTriangle((Graphics2D)object, (int)d10, (int)d15, n7);
            }
            stroke = ((Graphics2D)object).getStroke();
            ((Graphics2D)object).setStroke(new BasicStroke(1.5f));
            double d16 = 10.0;
            double d17 = 10.0;
            ((Graphics2D)object).drawString((String)list2.get(n11), (float)((double)this.dataPlottingArea.x + d16), (float)(this.dataPlottingArea.getY() + d17) + (float)(n8 * n11));
            Rectangle2D.Double double_2 = new Rectangle2D.Double((double)this.dataPlottingArea.x + d16 + (double)n9 + d9, this.dataPlottingArea.getY() + d17 + (double)(n8 * n11) - d8, d9, d8);
            ((Graphics2D)object).fill(double_2);
            ((Graphics2D)object).draw(double_2);
            ((Graphics2D)object).setStroke(stroke);
        }
        ((Graphics)object).setFont(font);
        ((Graphics)object).setColor(color);
        ((Graphics)object).dispose();
        PValuePainter.outputPNGFile(bufferedImage, string2);
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            String[] stringArray2;
            DoubleArrayList doubleArrayList = new DoubleArrayList();
            Uniform uniform = new Uniform(new MersenneTwister(new Date()));
            for (int i = 0; i < 1000000; ++i) {
            }
            String string = "disttest/pi.impute.chr1.txt";
            String string2 = "disttest/dist1_output_chr1.eur";
            LineReader lineReader = null;
            File file = new File(string);
            if (!file.exists()) {
                System.out.println(file + " does not exist!!");
                return;
            }
            if (file.exists() && file.getName().endsWith(".gz")) {
                lineReader = new CompressedFileReader(file);
            } else if (file.exists()) {
                lineReader = new AsciiLineReader(file);
            } else {
                throw new Exception("No pvalue file: " + file.getCanonicalPath());
            }
            String string3 = null;
            lineReader.readLine();
            DoubleArrayList doubleArrayList2 = new DoubleArrayList();
            HashSet<String> hashSet = new HashSet<String>();
            while ((string3 = lineReader.readLine()) != null) {
                if ((string3 = string3.trim()).trim().length() == 0) continue;
                stringArray2 = string3.split("\t");
                doubleArrayList2.add(Double.parseDouble(stringArray2[5]));
                hashSet.add(stringArray2[2]);
            }
            lineReader.close();
            stringArray2 = new DoubleArrayList();
            file = new File(string2);
            if (!file.exists()) {
                System.out.println(file + " does not exist!!");
                return;
            }
            if (file.exists() && file.getName().endsWith(".gz")) {
                lineReader = new CompressedFileReader(file);
            } else if (file.exists()) {
                lineReader = new AsciiLineReader(file);
            } else {
                throw new Exception("No pvalue file: " + file.getCanonicalPath());
            }
            lineReader.readLine();
            while ((string3 = lineReader.readLine()) != null) {
                if ((string3 = string3.trim()).trim().length() == 0 || (object2 = string3.split(" "))[7].equals("nan") || Double.parseDouble(object2[7]) < 0.3) continue;
                stringArray2.add(Double.parseDouble(object2[8]));
            }
            lineReader.close();
            System.out.println("Overlapped SNP: " + stringArray2.size());
            object2 = new DoubleArrayList();
            string2 = "disttest/assoc.logistic.ch1.hg19.result.txt";
            file = new File(string2);
            lineReader = new AsciiLineReader(file);
            lineReader.readLine();
            String[] stringArray3 = new String[12];
            String string4 = "\t ,";
            while ((string3 = lineReader.readLine()) != null) {
                if ((string3 = string3.trim()).trim().length() == 0) continue;
                object = new StringTokenizer(string3, string4);
                int n = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    stringArray3[n] = ((StringTokenizer)object).nextToken();
                    ++n;
                }
                if (!stringArray3[0].equals("1") || stringArray3[11].equals("NA")) continue;
                ((DoubleArrayList)object2).add(Double.parseDouble(stringArray3[11]));
            }
            lineReader.close();
            object = new PValuePainter(400, 400);
            double d2 = 1.0E-20;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("PI");
            arrayList.add("DIST");
            arrayList.add("Typed");
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            doubleArrayList2.quickSort();
            stringArray2.quickSort();
            ((AbstractList)object2).quickSort();
            arrayList2.add(doubleArrayList2);
            arrayList2.add(stringArray2);
            arrayList2.add(object2);
            ((PValuePainter)object).drawMultipleQQPlot(arrayList2, arrayList, null, "qq.png", d2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void drawMultipleTruncatedQQPlot(List list, List list2, String string, String string2, double d2, int n) {
        int n2;
        Object object;
        int n3;
        double d3;
        int n4;
        if (list == null || list.isEmpty()) {
            System.err.println("Null p-value list");
            return;
        }
        int n5 = list.size();
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            if (list.get(n4) != null && ((DoubleArrayList)list.get(n4)).size() != 0) continue;
            System.err.println("Null p-value list");
            list.remove(n4);
        }
        if (list == null || list.isEmpty()) {
            System.err.println("Null p-value list");
            return;
        }
        n4 = ((DoubleArrayList)list.get(0)).size();
        if (string != null && string.length() > 0) {
            this.calculateDataPlottingArea(true);
        } else {
            this.calculateDataPlottingArea(false);
        }
        double d4 = d3 = ((DoubleArrayList)list.get(0)).getQuick(0);
        double d5 = 0.0;
        double d6 = 1.0 / (double)n4;
        double d7 = Double.MAX_VALUE;
        int n6 = 0;
        double d8 = 0.0;
        for (n3 = 0; n3 < n5; ++n3) {
            object = (DoubleArrayList)list.get(n3);
            ((AbstractList)object).quickSort();
            d8 = Descriptive.median((DoubleArrayList)object);
            n4 = ((AbstractDoubleList)object).size();
            if (d7 > d8 && (n6 = ((AbstractDoubleList)object).binarySearch(d7 = d8)) < 0) {
                n6 = -n6 - 1;
            }
            for (int i = 0; i < n4; ++i) {
                if (d3 > ((DoubleArrayList)object).getQuick(i)) {
                    d3 = ((DoubleArrayList)object).getQuick(i);
                    continue;
                }
                if (!(d4 < ((DoubleArrayList)object).getQuick(i))) continue;
                d4 = ((DoubleArrayList)object).getQuick(i);
            }
            if (!(d6 > 1.0 / (double)(n4 + 1))) continue;
            d6 = 1.0 / (double)(n4 + 1);
        }
        if (d6 > 1.0 / (double)(n + 1)) {
            d6 = 1.0 / (double)(n + 1);
        }
        n3 = 4000;
        d4 = 0.0;
        d3 = -Math.log10(d3);
        d6 = -Math.log10(d6);
        if (d3 > -Math.log10(d2)) {
            d3 = -Math.log10(d2);
        }
        object = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(graphics2D);
        BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer = new BasicPainter$CoordinateTransformer(this);
        basicPainter$CoordinateTransformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, d5, d6, d4, d3);
        int n7 = this.drawAxesScale(graphics2D, basicPainter$CoordinateTransformer);
        this.drawAxes(graphics2D, string, "Expected [-log10(P)]", "Observed [-log10(P)]", n7);
        Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(0.0, 0.0);
        Point point2 = basicPainter$CoordinateTransformer.data2ScreenPoint(Math.min(d6, d3), Math.min(d6, d3));
        Line2D.Double double_ = new Line2D.Double(point, point2);
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.GREEN);
        graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
        graphics2D.draw(double_);
        int n8 = 2;
        int n9 = n8 / 2;
        int n10 = 4;
        double d9 = 0.05;
        Color[] colorArray = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.MAGENTA, Color.BLACK, Color.PINK};
        int n11 = graphics2D.getFontMetrics().getHeight();
        double d10 = 6.0;
        double d11 = 6.0;
        graphics2D.setStroke(stroke);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.numFont);
        int n12 = graphics2D.getFontMetrics().stringWidth((String)list2.get(n5 - 1));
        for (n2 = n5 - 2; n2 >= 0; --n2) {
            int n13 = graphics2D.getFontMetrics().stringWidth((String)list2.get(n2));
            if (n12 >= n13) continue;
            n12 = n13;
        }
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            double d12;
            double d13;
            DoubleArrayList doubleArrayList = (DoubleArrayList)list.get(n2);
            n4 = doubleArrayList.size();
            graphics2D.setColor(colorArray[n2]);
            int n14 = n4 + 1;
            for (int i = 0; i < n4; ++i) {
                double d14 = -Math.log10((double)(i + 1) / (double)(n14 + n3));
                double d15 = -Math.log10(doubleArrayList.getQuick(i));
                if (d15 <= d3) {
                    basicPainter$CoordinateTransformer.data2ScreenPoint(point, d14, d15);
                    graphics2D.drawRect(point.x - n9, point.y - n9, n8, n8);
                    continue;
                }
                d15 = d3;
                basicPainter$CoordinateTransformer.data2ScreenPoint(point, d14, d15);
                d13 = point.getX();
                d12 = point.getY();
                this.plotTriangle(graphics2D, (int)d13, (int)d12, n10);
            }
            float[] fArray = new float[]{3.0f};
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.5f));
            d13 = this.dataPlottingArea.getWidth() / 4.0;
            d12 = this.dataPlottingArea.getHeight() / 8.0;
            graphics2D.drawString((String)list2.get(n2), (float)((double)this.dataPlottingArea.x + d13), (float)(this.dataPlottingArea.getY() + d12) + (float)(n11 * n2));
            Rectangle2D.Double double_2 = new Rectangle2D.Double((double)this.dataPlottingArea.x + d13 + (double)n12 + d11, this.dataPlottingArea.getY() + d12 + (double)(n11 * n2) - d10, d11, d10);
            graphics2D.fill(double_2);
            graphics2D.draw(double_2);
            graphics2D.setStroke(stroke);
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.dispose();
        PValuePainter.outputPNGFile((BufferedImage)object, string2);
    }

    public void drawScatterPlot(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2, String string, String string2) {
        BufferedImage bufferedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(graphics2D);
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        int n = doubleArrayList.size();
        double d2 = Descriptive.max(doubleArrayList2);
        double d3 = Descriptive.min(doubleArrayList2);
        double d4 = Descriptive.min(doubleArrayList);
        double d5 = Descriptive.max(doubleArrayList);
        double d6 = 0.05;
        if (d3 - d2 == 0.0) {
            d3 = d2 - 1.0;
        }
        if (d4 - d5 == 0.0) {
            d4 = d5 - 1.0;
        }
        BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer = new BasicPainter$CoordinateTransformer(this);
        basicPainter$CoordinateTransformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, d4, d5, d3, d2);
        int n2 = this.drawAxesScale(graphics2D, basicPainter$CoordinateTransformer);
        this.drawAxes(graphics2D, string, "Relative Pyshical Position (bp)", "-Log10(p)", n2);
        double d7 = 4.0;
        for (int i = 0; i < n; ++i) {
            if (doubleArrayList2.getQuick(i) > -Math.log10(d6)) {
                graphics2D.setColor(Color.RED);
            } else {
                graphics2D.setColor(Color.BLACK);
            }
            Point point = basicPainter$CoordinateTransformer.data2ScreenPoint(doubleArrayList.getQuick(i), doubleArrayList2.getQuick(i));
            Rectangle2D.Double double_ = new Rectangle2D.Double(((Point2D)point).getX() - d7 / 2.0, ((Point2D)point).getY() - d7 / 2.0, d7, d7);
            graphics2D.draw(double_);
            graphics2D.fill(double_);
        }
        graphics2D.dispose();
        PValuePainter.outputPNGFile(bufferedImage, string2);
    }

    public void drawMultiScatterPlot(List list, List list2, List list3, String string, String string2) {
        int n;
        if (list == null || list.isEmpty()) {
            System.err.println("Null  xList");
            return;
        }
        this.dataPlottingOffsetLeft = 40;
        int n2 = list.size();
        for (int i = n2 - 1; i >= 0; --i) {
            if (list.get(i) != null && ((DoubleArrayList)list.get(i)).size() != 0) continue;
            System.err.println("Null xList");
            list.remove(i);
        }
        if (string != null && string.length() > 0) {
            this.calculateDataPlottingArea(true);
        } else {
            this.calculateDataPlottingArea(false);
        }
        BufferedImage bufferedImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintCanvas(graphics2D);
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        if (d3 - d2 == 0.0) {
            d3 = d2 - 1.0;
        }
        if (d4 - d5 == 0.0) {
            d4 = d5 - 1.0;
        }
        int n3 = list.size();
        int n4 = graphics2D.getFontMetrics().stringWidth((String)list3.get(n3 - 1));
        for (int i = n3 - 2; i >= 0; --i) {
            n = graphics2D.getFontMetrics().stringWidth((String)list3.get(i));
            if (n4 >= n) continue;
            n4 = n;
        }
        BasicPainter$CoordinateTransformer basicPainter$CoordinateTransformer = new BasicPainter$CoordinateTransformer(this);
        basicPainter$CoordinateTransformer.setupBasicScope(this.dataPlottingArea.x, this.dataPlottingArea.x + this.dataPlottingArea.width, this.dataPlottingArea.y, this.dataPlottingArea.y + this.dataPlottingArea.height, d4, d5, d3, d2);
        n = this.drawAxesScale(graphics2D, basicPainter$CoordinateTransformer);
        this.drawAxes(graphics2D, string, "False positive rate", "True positive rate", n);
        double d6 = 4.0;
        int n5 = graphics2D.getFontMetrics().getHeight();
        Color[] colorArray = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.MAGENTA, Color.BLACK, Color.YELLOW};
        Point point = null;
        Line2D.Double double_ = new Line2D.Double();
        for (int i = 0; i < n3; ++i) {
            int n6 = ((DoubleArrayList)list.get(i)).size();
            graphics2D.setColor(colorArray[i]);
            for (int j = 0; j < n6; ++j) {
                Point point2 = basicPainter$CoordinateTransformer.data2ScreenPoint(((DoubleArrayList)list.get(i)).getQuick(j), ((DoubleArrayList)list2.get(i)).getQuick(j));
                Rectangle2D.Double double_2 = new Rectangle2D.Double(((Point2D)point2).getX() - d6 / 2.0, ((Point2D)point2).getY() - d6 / 2.0, d6, d6);
                graphics2D.draw(double_2);
                graphics2D.fill(double_2);
                if (j > 0) {
                    double_.setLine(point, point2);
                    graphics2D.draw(double_);
                }
                point = point2;
            }
            graphics2D.setStroke(new BasicStroke(1.5f));
            double d7 = this.dataPlottingArea.getWidth() / 4.0;
            double d8 = this.dataPlottingArea.getHeight() / 2.0;
            graphics2D.drawString((String)list3.get(i), (float)((double)this.dataPlottingArea.x + d7), (float)(this.dataPlottingArea.getY() + d8) + (float)(n5 * i));
            Rectangle2D.Double double_3 = new Rectangle2D.Double((double)this.dataPlottingArea.x + d7 + (double)n4 + d6, this.dataPlottingArea.getY() + d8 + (double)(n5 * i) - d6, d6, d6);
            graphics2D.fill(double_3);
        }
        graphics2D.dispose();
        PValuePainter.outputPNGFile(bufferedImage, string2);
    }
}

