/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.functions.MathFunctionWithDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithIntegral;

public class AverageMathFunction
implements MathFunction,
MathFunctionWithFirstDerivative,
MathFunctionWithDerivative,
MathFunctionWithIntegral {
    private MathFunction[] func;

    public AverageMathFunction(MathFunction ... func) {
        if (func == null) {
            throw new NullPointerException();
        }
        this.func = (MathFunction[])func.clone();
    }

    public MathFunction[] getFunctions() {
        return (MathFunction[])this.func.clone();
    }

    public double evaluate(double x) {
        double sum = 0.0;
        for (MathFunction fi : this.func) {
            sum += fi.evaluate(x);
        }
        return sum / (double)this.func.length;
    }

    public double derivative(double x, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be greater than or equal to 0");
        }
        if (n == 0) {
            return this.evaluate(x);
        }
        double sum = 0.0;
        for (MathFunction fi : this.func) {
            sum += MathFunctionUtil.derivative(fi, x, n);
        }
        return sum / (double)this.func.length;
    }

    public double derivative(double x) {
        double sum = 0.0;
        for (MathFunction fi : this.func) {
            sum += MathFunctionUtil.derivative(fi, x);
        }
        return sum / (double)this.func.length;
    }

    public double integral(double a2, double b2) {
        double sum = 0.0;
        for (MathFunction fi : this.func) {
            sum += MathFunctionUtil.integral(fi, a2, b2);
        }
        return sum / (double)this.func.length;
    }
}

