/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import umontreal.iro.lecuyer.hups.DigitalSequenceBase2;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class NiedSequenceBase2
extends DigitalSequenceBase2 {
    private static final int MAXDIM = 318;
    private static final int NUMCOLS = 30;
    private static int[] NiedMat = new int[9540];
    private static final int MAXN = 9540;

    public NiedSequenceBase2(int k, int w, int dim) {
        this.init(k, w, w, dim);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Niederreiter sequence:" + PrintfFormat.NEWLINE);
        sb.append(super.toString());
        return sb.toString();
    }

    private void init(int k, int r, int w, int dim) {
        if (dim < 1 || dim > 318) {
            throw new IllegalArgumentException("Dimension for NiedSequenceBase2 must be > 1 and <= 318");
        }
        if (r < k || w < r || w > 31 || k >= 31) {
            throw new IllegalArgumentException("One must have k < 31 and k <= r <= w <= 31 for NiedSequenceBase2");
        }
        this.numCols = k;
        this.numRows = r;
        this.outDigits = w;
        this.numPoints = 1 << k;
        this.dim = dim;
        this.normFactor = 1.0 / (double)(1L << this.outDigits);
        this.genMat = new int[dim * this.numCols];
        this.initGenMat();
    }

    public void extendSequence(int k) {
        this.init(k, this.numRows, this.outDigits, this.dim);
    }

    private void initGenMat() {
        for (int j = 0; j < this.dim; ++j) {
            for (int c2 = 0; c2 < this.numCols; ++c2) {
                this.genMat[j * this.numCols + c2] = NiedMat[j * 30 + c2] << 1;
                int n = j * this.numCols + c2;
                this.genMat[n] = this.genMat[n] >> 31 - this.outDigits;
            }
        }
    }

    static {
        try {
            InputStream is = NiedSequenceBase2.class.getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/hups/dataSer/Nieder/NiedSequenceBase2.ser");
            if (is == null) {
                throw new FileNotFoundException("Cannot find NiedSequenceBase2.ser");
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            NiedMat = (int[])ois.readObject();
            ois.close();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        catch (IOException e3) {
            e3.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException e4) {
            e4.printStackTrace();
            System.exit(1);
        }
    }
}

