/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.Distribution;

public abstract class ContinuousDistribution
implements Distribution {
    @Deprecated
    public int decPrec = 15;
    protected static final double XBIG = 100.0;
    protected static final double XBIGM = 1000.0;
    protected double supportA = Double.NEGATIVE_INFINITY;
    protected double supportB = Double.POSITIVE_INFINITY;
    protected static final double[] EPSARRAY = new double[]{0.5, 0.05, 0.005, 5.0E-4, 5.0E-5, 5.0E-6, 5.0E-7, 5.0E-8, 5.0E-9, 5.0E-10, 5.0E-11, 5.0E-12, 5.0E-13, 5.0E-14, 5.0E-15, 5.0E-16, 5.0E-17, 5.0E-18, 5.0E-19, 5.0E-20, 5.0E-21, 5.0E-22, 5.0E-23, 5.0E-24, 5.0E-25, 5.0E-26, 5.0E-27, 5.0E-28, 5.0E-29, 5.0E-30, 5.0E-31, 5.0E-32, 5.0E-33, 5.0E-34, 5.0E-35, 5.0E-36};

    private int getDecPrec() {
        return this.decPrec;
    }

    public abstract double density(double var1);

    public double barF(double x) {
        return 1.0 - this.cdf(x);
    }

    private void findInterval(double u, double[] iv) {
        double a2;
        double b2;
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        double XLIM = 8.988465674311579E307;
        double B0 = 8.0;
        for (b2 = 8.0; b2 < 8.988465674311579E307 && u > this.cdf(b2); b2 *= 2.0) {
        }
        if (b2 > 8.0) {
            iv[0] = b2 / 2.0;
            iv[1] = Math.min(b2, this.supportB);
            return;
        }
        for (a2 = -8.0; a2 > -8.988465674311579E307 && u < this.cdf(a2); a2 *= 2.0) {
        }
        if (a2 < -8.0) {
            iv[1] = a2 / 2.0;
            iv[0] = Math.max(a2, this.supportA);
            return;
        }
        iv[0] = Math.max(a2, this.supportA);
        iv[1] = Math.min(b2, this.supportB);
    }

    public double inverseBrent(double a2, double b2, double u, double tol) {
        int i;
        double len;
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (b2 < a2) {
            double ctemp = a2;
            a2 = b2;
            b2 = ctemp;
        }
        if (u <= 0.0) {
            System.out.println("********** WARNING,  inverseBrent:   u = 0");
            return this.supportA;
        }
        if (u >= 1.0) {
            System.out.println("********** WARNING,  inverseBrent:   u = 1");
            return this.supportB;
        }
        int MAXITER = 50;
        tol += EPSARRAY[this.decPrec] + 2.220446049250313E-16;
        double ua = this.cdf(a2) - u;
        if (ua > 0.0) {
            throw new IllegalArgumentException("u < cdf(a)");
        }
        double ub = this.cdf(b2) - u;
        if (ub < 0.0) {
            throw new IllegalArgumentException("u > cdf(b)");
        }
        boolean DEBUG = false;
        double c2 = a2;
        double uc = ua;
        double t = len = b2 - a2;
        if (Math.abs(uc) < Math.abs(ub)) {
            a2 = b2;
            b2 = c2;
            c2 = a2;
            ua = ub;
            ub = uc;
            uc = ua;
        }
        for (i = 0; i < 50; ++i) {
            double tol1 = tol + 8.881784197001252E-16 * Math.abs(b2);
            double xm = 0.5 * (c2 - b2);
            if (Math.abs(ub) == 0.0 || Math.abs(xm) <= tol1) {
                if (b2 <= this.supportA) {
                    return this.supportA;
                }
                if (b2 >= this.supportB) {
                    return this.supportB;
                }
                return b2;
            }
            if (Math.abs(t) >= tol1 && Math.abs(ua) > Math.abs(ub)) {
                double p;
                double q;
                double s;
                if (a2 == c2) {
                    s = ub / ua;
                    q = 1.0 - s;
                    p = 2.0 * xm * s;
                } else {
                    q = ua / uc;
                    double r = ub / uc;
                    s = ub / ua;
                    p = s * (2.0 * xm * q * (q - r) - (b2 - a2) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                if (2.0 * (p = Math.abs(p)) >= 3.0 * xm * q - Math.abs(q * tol1) || p >= Math.abs(0.5 * t * q)) {
                    t = len = xm;
                } else {
                    t = len;
                    len = p / q;
                }
            } else {
                t = len = xm;
            }
            a2 = b2;
            ua = ub;
            b2 = Math.abs(len) > tol1 ? (b2 += len) : (xm < 0.0 ? (b2 -= tol1) : (b2 += tol1));
            ub = this.cdf(b2) - u;
            if (ub * (uc / Math.abs(uc)) > 0.0) {
                c2 = a2;
                uc = ua;
                t = len = b2 - a2;
                continue;
            }
            if (!(Math.abs(uc) < Math.abs(ub))) continue;
            a2 = b2;
            b2 = c2;
            c2 = a2;
            ua = ub;
            ub = uc;
            uc = ua;
        }
        if (i >= 50) {
            String lineSep = System.getProperty("line.separator");
            System.out.println(lineSep + "*********** inverseBrent:   no convergence after " + 50 + " iterations");
        }
        return b2;
    }

    public double inverseBisection(double u) {
        int MAXITER = 100;
        double EPSILON = EPSARRAY[this.decPrec];
        double XLIM = 8.988465674311579E307;
        boolean DEBUG = false;
        String lineSep = System.getProperty("line.separator");
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (this.decPrec > 15) {
            throw new IllegalArgumentException("decPrec too large");
        }
        if (this.decPrec <= 0) {
            throw new IllegalArgumentException("decPrec <= 0");
        }
        double x = 0.0;
        if (u <= 0.0) {
            x = this.supportA;
            return x;
        }
        if (u >= 1.0) {
            x = this.supportB;
            return x;
        }
        double[] iv = new double[2];
        this.findInterval(u, iv);
        double xa = iv[0];
        double xb = iv[1];
        double yb = this.cdf(xb) - u;
        double ya = this.cdf(xa) - u;
        boolean fini = false;
        int i = 0;
        while (!fini) {
            x = (xa + xb) / 2.0;
            double y = this.cdf(x) - u;
            if (y == 0.0 || Math.abs((xb - xa) / (x + 2.220446049250313E-16)) <= EPSILON) {
                fini = true;
            } else if (y * ya < 0.0) {
                xb = x;
            } else {
                xa = x;
            }
            if (++i <= 100) continue;
            fini = true;
        }
        return x;
    }

    public double inverseF(double u) {
        double[] iv = new double[2];
        this.findInterval(u, iv);
        return this.inverseBrent(iv[0], iv[1], u, EPSARRAY[this.decPrec]);
    }

    public double getMean() {
        throw new UnsupportedOperationException("getMean is not implemented ");
    }

    public double getVariance() {
        throw new UnsupportedOperationException("getVariance is not implemented ");
    }

    public double getStandardDeviation() {
        throw new UnsupportedOperationException("getStandardDeviation is not implemented ");
    }

    public double getXinf() {
        return this.supportA;
    }

    public double getXsup() {
        return this.supportB;
    }

    public void setXinf(double xa) {
        this.supportA = xa;
    }

    public void setXsup(double xb) {
        this.supportB = xb;
    }
}

