/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import java.util.Formatter;
import java.util.Locale;
import umontreal.iro.lecuyer.probdist.Distribution;

public class DiscreteDistribution
implements Distribution {
    protected double[] cdf = null;
    protected double[] pr = null;
    protected int xmin = 0;
    protected int xmax = 0;
    protected int xmed = 0;
    protected int nVal;
    protected double[] sortedVal;
    protected double supportA = Double.NEGATIVE_INFINITY;
    protected double supportB = Double.POSITIVE_INFINITY;

    protected DiscreteDistribution() {
    }

    public DiscreteDistribution(double[] values, double[] prob, int n) {
        this.init(n, values, prob);
    }

    public DiscreteDistribution(int[] values, double[] prob, int n) {
        double[] A = new double[n];
        for (int i = 0; i < n; ++i) {
            A[i] = values[i];
        }
        this.init(n, A, prob);
    }

    @Deprecated
    public DiscreteDistribution(double[] params) {
        if ((double)params.length != 1.0 + params[0] * 2.0) {
            throw new IllegalArgumentException("Wrong parameter size");
        }
        int n = (int)params[0];
        double[] val = new double[n];
        double[] prob = new double[n];
        System.arraycopy(params, 1, val, 0, n);
        System.arraycopy(params, n + 1, prob, 0, n);
        this.init(n, val, prob);
    }

    private void init(int n, double[] val, double[] prob) {
        int no = val.length;
        int np = prob.length;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (no < n || np < n) {
            throw new IllegalArgumentException("Size of arrays 'values' or 'prob' less than 'n'");
        }
        this.nVal = n;
        this.pr = prob;
        this.sortedVal = new double[this.nVal];
        System.arraycopy(val, 0, this.sortedVal, 0, this.nVal);
        this.supportA = this.sortedVal[0];
        this.supportB = this.sortedVal[this.nVal - 1];
        this.xmin = 0;
        this.xmax = this.nVal - 1;
        this.cdf = new double[this.nVal];
        this.cdf[0] = this.pr[0];
        int i = 0;
        while (i < this.xmax && this.cdf[i] < 0.5) {
            this.cdf[++i] = this.pr[i] + this.cdf[i - 1];
        }
        this.xmed = i;
        this.cdf[this.nVal - 1] = this.pr[this.nVal - 1];
        for (i = this.nVal - 2; i > this.xmed; --i) {
            this.cdf[i] = this.pr[i] + this.cdf[i + 1];
        }
    }

    public double cdf(double x) {
        if (x < this.sortedVal[0]) {
            return 0.0;
        }
        if (x >= this.sortedVal[this.nVal - 1]) {
            return 1.0;
        }
        if (this.xmax == this.xmed || x < this.sortedVal[this.xmed + 1]) {
            for (int i = 0; i <= this.xmed; ++i) {
                if (!(x >= this.sortedVal[i]) || !(x < this.sortedVal[i + 1])) continue;
                return this.cdf[i];
            }
        } else {
            for (int i = this.xmed + 1; i < this.nVal - 1; ++i) {
                if (!(x >= this.sortedVal[i]) || !(x < this.sortedVal[i + 1])) continue;
                return 1.0 - this.cdf[i + 1];
            }
        }
        throw new IllegalStateException();
    }

    public double barF(double x) {
        if (x <= this.sortedVal[0]) {
            return 1.0;
        }
        if (x > this.sortedVal[this.nVal - 1]) {
            return 0.0;
        }
        if (this.xmax == this.xmed || x <= this.sortedVal[this.xmed + 1]) {
            for (int i = 0; i <= this.xmed; ++i) {
                if (!(x > this.sortedVal[i]) || !(x <= this.sortedVal[i + 1])) continue;
                return 1.0 - this.cdf[i];
            }
        } else {
            for (int i = this.xmed + 1; i < this.nVal - 1; ++i) {
                if (!(x > this.sortedVal[i]) || !(x <= this.sortedVal[i + 1])) continue;
                return this.cdf[i + 1];
            }
        }
        throw new IllegalStateException();
    }

    public double inverseF(double u) {
        int i;
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return this.supportA;
        }
        if (u >= 1.0) {
            return this.supportB;
        }
        if (u <= this.cdf[this.xmed - this.xmin]) {
            if (u <= this.cdf[0]) {
                return this.sortedVal[this.xmin];
            }
            i = 0;
            int j = this.xmed - this.xmin;
            while (i < j) {
                int k = (i + j) / 2;
                if (u > this.cdf[k]) {
                    i = k + 1;
                    continue;
                }
                j = k;
            }
        } else {
            if ((u = 1.0 - u) < this.cdf[this.xmax - this.xmin]) {
                return this.sortedVal[this.xmax];
            }
            i = this.xmed - this.xmin + 1;
            int j = this.xmax - this.xmin;
            while (i < j) {
                int k = (i + j) / 2;
                if (u < this.cdf[k]) {
                    i = k + 1;
                    continue;
                }
                j = k;
            }
            --i;
        }
        return this.sortedVal[i + this.xmin];
    }

    public double getMean() {
        double mean = 0.0;
        for (int i = 0; i < this.nVal; ++i) {
            mean += this.sortedVal[i] * this.pr[i];
        }
        return mean;
    }

    public double getVariance() {
        double mean = this.getMean();
        double variance = 0.0;
        for (int i = 0; i < this.nVal; ++i) {
            variance += (this.sortedVal[i] - mean) * (this.sortedVal[i] - mean) * this.pr[i];
        }
        return variance;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public double[] getParams() {
        double[] retour = new double[1 + this.nVal * 2];
        double sum = 0.0;
        retour[0] = this.nVal;
        System.arraycopy(this.sortedVal, 0, retour, 1, this.nVal);
        for (int i = 0; i < this.nVal - 1; ++i) {
            retour[this.nVal + 1 + i] = this.cdf[i] - sum;
            sum = this.cdf[i];
        }
        retour[2 * this.nVal] = 1.0 - sum;
        return retour;
    }

    public int getN() {
        return this.nVal;
    }

    public double prob(int i) {
        return this.pr[i];
    }

    public double getValue(int i) {
        return this.sortedVal[i];
    }

    public double getXinf() {
        return this.supportA;
    }

    public double getXsup() {
        return this.supportB;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%s%n", this.getClass().getSimpleName());
        formatter.format("%s :      %s%n", "value", "cdf");
        for (int i = 0; i < this.nVal - 1; ++i) {
            formatter.format("%f : %f%n", this.sortedVal[i], this.cdf[i]);
        }
        formatter.format("%f : %f%n", this.sortedVal[this.nVal - 1], 1.0);
        return sb.toString();
    }
}

