/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.Num;

public class NakagamiDist
extends ContinuousDistribution {
    protected double a;
    protected double lambda;
    protected double c;
    private double factor;
    private double ratio;

    public NakagamiDist(double a2, double lambda, double c2) {
        this.setParams(a2, lambda, c2);
    }

    public double density(double x) {
        if (x <= this.a) {
            return 0.0;
        }
        return 2.0 * Math.exp(this.factor + Math.log(x - this.a) * (2.0 * this.c - 1.0) - this.lambda * (x - this.a) * (x - this.a));
    }

    public double cdf(double x) {
        return NakagamiDist.cdf(this.a, this.lambda, this.c, x);
    }

    public double barF(double x) {
        return NakagamiDist.barF(this.a, this.lambda, this.c, x);
    }

    public double inverseF(double u) {
        return NakagamiDist.inverseF(this.a, this.lambda, this.c, u);
    }

    public double getMean() {
        return this.a + this.ratio / Math.sqrt(this.lambda);
    }

    public double getVariance() {
        return (this.c - this.ratio * this.ratio) / this.lambda;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public static double density(double a2, double lambda, double c2, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a2) {
            return 0.0;
        }
        return 2.0 * Math.exp(Math.log(lambda) * c2 - Num.lnGamma(c2) + Math.log(x - a2) * (2.0 * c2 - 1.0) - lambda * (x - a2) * (x - a2));
    }

    public static double cdf(double a2, double lambda, double c2, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a2) {
            return 0.0;
        }
        return GammaDist.cdf(c2, 12, lambda * (x - a2) * (x - a2));
    }

    public static double barF(double a2, double lambda, double c2, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (x <= a2) {
            return 1.0;
        }
        return GammaDist.barF(c2, 12, lambda * (x - a2) * (x - a2));
    }

    public static double inverseF(double a2, double lambda, double c2, double u) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return a2;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double res = GammaDist.inverseF(c2, 12, u);
        return a2 + Math.sqrt(res / lambda);
    }

    public static double getMean(double a2, double lambda, double c2) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        return a2 + Num.gammaRatioHalf(c2) / Math.sqrt(lambda);
    }

    public static double getVariance(double a2, double lambda, double c2) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        double rat = Num.gammaRatioHalf(c2);
        return (c2 - rat * rat) / lambda;
    }

    public static double getStandardDeviation(double a2, double lambda, double c2) {
        return Math.sqrt(NakagamiDist.getVariance(a2, lambda, c2));
    }

    public double getA() {
        return this.a;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getC() {
        return this.c;
    }

    public void setParams(double a2, double lambda, double c2) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (c2 <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        this.a = a2;
        this.lambda = lambda;
        this.c = c2;
        this.factor = Math.log(lambda) * c2 - Num.lnGamma(c2);
        this.ratio = Num.gammaRatioHalf(c2);
    }

    public double[] getParams() {
        double[] retour = new double[]{this.a, this.lambda, this.c};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : a = " + this.a + ", lambda = " + this.lambda + ", c = " + this.c;
    }
}

