/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class NegativeBinomialDist
extends DiscreteDistributionInt {
    protected double n;
    protected double p;
    private static final double EPS2 = 1000.0 * EPSILON;
    public static double MAXN = 100000.0;

    protected NegativeBinomialDist() {
    }

    public NegativeBinomialDist(double n, double p) {
        this.setParams(n, p);
    }

    public double prob(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (this.p == 0.0) {
            return 0.0;
        }
        if (this.p == 1.0) {
            if (x > 0) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.pdf == null) {
            return NegativeBinomialDist.prob(this.n, this.p, x);
        }
        if (x > this.xmax || x < this.xmin) {
            return NegativeBinomialDist.prob(this.n, this.p, x);
        }
        return this.pdf[x - this.xmin];
    }

    public double cdf(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (this.p >= 1.0) {
            return 1.0;
        }
        if (this.p <= 0.0) {
            return 0.0;
        }
        if (this.cdf != null) {
            if (x >= this.xmax) {
                return 1.0;
            }
            if (x < this.xmin) {
                return NegativeBinomialDist.cdf(this.n, this.p, x);
            }
            if (x <= this.xmed) {
                return this.cdf[x - this.xmin];
            }
            return 1.0 - this.cdf[x + 1 - this.xmin];
        }
        return NegativeBinomialDist.cdf(this.n, this.p, x);
    }

    public double barF(int x) {
        if (x < 1) {
            return 1.0;
        }
        if (this.p >= 1.0) {
            return 0.0;
        }
        if (this.p <= 0.0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return BetaDist.barF(this.n, x, 15, this.p);
        }
        if (x > this.xmax) {
            return BetaDist.barF(this.n, x, 15, this.p);
        }
        if (x <= this.xmin) {
            return 1.0;
        }
        if (x > this.xmed) {
            return this.cdf[x - this.xmin];
        }
        return 1.0 - this.cdf[x - 1 - this.xmin];
    }

    public int inverseFInt(double u) {
        if (this.cdf == null || u <= EPS2) {
            return NegativeBinomialDist.inverseF(this.n, this.p, u);
        }
        return super.inverseFInt(u);
    }

    public double getMean() {
        return NegativeBinomialDist.getMean(this.n, this.p);
    }

    public double getVariance() {
        return NegativeBinomialDist.getVariance(this.n, this.p);
    }

    public double getStandardDeviation() {
        return NegativeBinomialDist.getStandardDeviation(this.n, this.p);
    }

    public static double prob(double n, double p, int x) {
        int SLIM = 15;
        double MAXEXP = 709.0895657128241;
        double MINEXP = -708.3964185322641;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0.0) {
            throw new IllegalArgumentException("n <= 0.0");
        }
        if (x < 0) {
            return 0.0;
        }
        if (p >= 1.0) {
            if (x == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (p <= 0.0) {
            return 0.0;
        }
        double y = Num.lnGamma(n + (double)x) - (Num.lnFactorial(x) + Num.lnGamma(n)) + n * Math.log(p) + (double)x * Math.log1p(-p);
        if (y >= 709.0895657128241) {
            throw new IllegalArgumentException("term overflow");
        }
        return Math.exp(y);
    }

    public static double cdf(double n, double p, int x) {
        double EPSILON = DiscreteDistributionInt.EPSILON;
        int LIM1 = 100000;
        double q = 1.0 - p;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0.0) {
            throw new IllegalArgumentException("n <= 0.0");
        }
        if (x < 0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return 1.0;
        }
        if (p <= 0.0) {
            return 0.0;
        }
        int mode = 1 + (int)Math.floor((n * q - 1.0) / p);
        if (mode < 0) {
            mode = 0;
        } else if (mode > x) {
            mode = x;
        }
        if (mode <= 100000) {
            int i;
            double termmode;
            double term = termmode = NegativeBinomialDist.prob(n, p, mode);
            double sum = termmode;
            for (i = mode; i > 0 && !((term *= (double)i / (q * (n + (double)i - 1.0))) < EPSILON); --i) {
                sum += term;
            }
            term = termmode;
            for (i = mode; i < x && !((term *= q * (n + (double)i) / (double)(i + 1)) < EPSILON); ++i) {
                sum += term;
            }
            if (sum <= 1.0) {
                return sum;
            }
            return 1.0;
        }
        return BetaDist.cdf(n, (double)x + 1.0, 15, p);
    }

    public static double barF(double n, double p, int x) {
        return 1.0 - NegativeBinomialDist.cdf(n, p, x - 1);
    }

    public static int inverseF(double n, double p, double u) {
        double termmode;
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0.0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (p >= 1.0) {
            return 0;
        }
        if (p <= 0.0) {
            return 0;
        }
        if (u <= NegativeBinomialDist.prob(n, p, 0)) {
            return 0;
        }
        if (u >= 1.0) {
            return Integer.MAX_VALUE;
        }
        double q = 1.0 - p;
        int mode = 1 + (int)Math.floor((n * q - 1.0) / p);
        if (mode < 0) {
            mode = 0;
        }
        int i = mode;
        double term = NegativeBinomialDist.prob(n, p, i);
        while (term >= u && term > Double.MIN_NORMAL) {
            term = NegativeBinomialDist.prob(n, p, i /= 2);
        }
        if (term <= Double.MIN_NORMAL) {
            term = NegativeBinomialDist.prob(n, p, i *= 2);
            while (term >= u && term > Double.MIN_NORMAL) {
                term *= (double)i / (q * (n + (double)i - 1.0));
                --i;
            }
        }
        mode = i;
        double sum = termmode = NegativeBinomialDist.prob(n, p, i);
        for (i = mode; i > 0 && !((term *= (double)i / (q * (n + (double)i - 1.0))) < EPSILON); --i) {
            sum += term;
        }
        term = termmode;
        i = mode;
        double prev = -1.0;
        if (sum < u) {
            while (sum < u && sum > prev) {
                prev = sum;
                sum += (term *= q * (n + (double)i) / (double)(i + 1));
                ++i;
            }
        } else {
            sum -= term;
            while (sum >= u) {
                sum -= (term *= (double)(--i) / (q * (n + (double)i - 1.0)));
            }
        }
        return i;
    }

    public static double[] getMLE(int[] x, int m, double n) {
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        double mean = 0.0;
        for (int i = 0; i < m; ++i) {
            mean += (double)x[i];
        }
        double[] param = new double[]{n / (n + (mean /= (double)m))};
        return param;
    }

    public static NegativeBinomialDist getInstanceFromMLE(int[] x, int m, double n) {
        double[] parameters = NegativeBinomialDist.getMLE(x, m, n);
        return new NegativeBinomialDist(n, parameters[0]);
    }

    public static double[] getMLE1(int[] x, int m, double p) {
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        double mean = 0.0;
        for (int i = 0; i < m; ++i) {
            mean += (double)x[i];
        }
        double gam0 = (mean /= (double)m) * p / (1.0 - p);
        double[] param = new double[1];
        Func1 f2 = new Func1(p, x, m);
        param[0] = RootFinder.brentDekker(gam0 / 10.0, 10.0 * gam0, f2, 1.0E-5);
        return param;
    }

    public static NegativeBinomialDist getInstanceFromMLE1(int[] x, int m, double p) {
        double[] param = NegativeBinomialDist.getMLE1(x, m, p);
        return new NegativeBinomialDist(param[0], p);
    }

    public static double[] getMLE(int[] x, int m) {
        if (m <= 0) {
            throw new IllegalArgumentException("m<= 0");
        }
        double sum = 0.0;
        double max = -2.147483648E9;
        for (int i = 0; i < m; ++i) {
            sum += (double)x[i];
            if (!((double)x[i] > max)) continue;
            max = x[i];
        }
        double mean = sum / (double)m;
        double var = 0.0;
        for (int i = 0; i < m; ++i) {
            var += ((double)x[i] - mean) * ((double)x[i] - mean);
        }
        if (mean >= (var /= (double)m)) {
            throw new UnsupportedOperationException("mean >= variance");
        }
        double estimGamma = mean * mean / (var - mean);
        int[] Fj = new int[(int)max];
        int j = 0;
        while ((double)j < max) {
            int prop = 0;
            for (int i = 0; i < m; ++i) {
                if (x[i] <= j) continue;
                ++prop;
            }
            Fj[j] = prop;
            ++j;
        }
        double[] param = new double[3];
        Function f2 = new Function(m, (int)max, mean, Fj);
        param[1] = RootFinder.brentDekker(estimGamma / 10.0, estimGamma * 10.0, f2, 1.0E-5);
        param[2] = param[1] / (param[1] + mean);
        double[] parameters = new double[]{param[1], param[2]};
        return parameters;
    }

    public static NegativeBinomialDist getInstanceFromMLE(int[] x, int m) {
        double[] parameters = NegativeBinomialDist.getMLE(x, m);
        return new NegativeBinomialDist(parameters[0], parameters[1]);
    }

    public static double getMean(double n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0.0) {
            throw new IllegalArgumentException("n <= 0");
        }
        return n * (1.0 - p) / p;
    }

    public static double getVariance(double n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0.0) {
            throw new IllegalArgumentException("n <= 0");
        }
        return n * (1.0 - p) / (p * p);
    }

    public static double getStandardDeviation(double n, double p) {
        return Math.sqrt(NegativeBinomialDist.getVariance(n, p));
    }

    @Deprecated
    public double getGamma() {
        return this.n;
    }

    public double getN() {
        return this.n;
    }

    public double getP() {
        return this.p;
    }

    public void setParams(double n, double p) {
        this.supportA = 0;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0.0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.p = p;
        int mode = 1 + (int)Math.floor((n * (1.0 - p) - 1.0) / p);
        if ((double)mode < 0.0 || (double)mode > MAXN) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        int Nmax = (int)(n * (1.0 - p) / p + 16.0 * Math.sqrt(n * (1.0 - p) / (p * p)));
        if (Nmax < 32) {
            Nmax = 32;
        }
        double[] P = new double[1 + Nmax];
        double epsilon = EPSILON / NegativeBinomialDist.prob(n, p, mode);
        P[mode] = 1.0;
        double sum = 1.0;
        int i = mode;
        while (i > 0 && P[i] >= epsilon) {
            P[i - 1] = P[i] * (double)i / ((1.0 - p) * (n + (double)i - 1.0));
            sum += P[--i];
        }
        int imin = i;
        i = mode;
        while (P[i] >= epsilon) {
            P[i + 1] = P[i] * (1.0 - p) * (n + (double)i) / (double)(i + 1);
            sum += P[++i];
            if (i != Nmax - 1) continue;
            double[] nT = new double[1 + (Nmax *= 2)];
            System.arraycopy(P, 0, nT, 0, P.length);
            P = nT;
        }
        int imax = i;
        i = imin;
        while (i <= imax) {
            int n2 = i++;
            P[n2] = P[n2] / sum;
        }
        double[] F = new double[1 + Nmax];
        F[imin] = P[imin];
        i = imin;
        while (i < imax && F[i] < 0.5) {
            F[++i] = F[i - 1] + P[i];
        }
        this.xmed = i;
        F[imax] = P[imax];
        i = imax - 1;
        do {
            F[i] = P[i] + F[i + 1];
        } while (--i > this.xmed);
        this.xmin = imin;
        this.xmax = imax;
        this.pdf = new double[imax + 1 - imin];
        this.cdf = new double[imax + 1 - imin];
        System.arraycopy(P, imin, this.pdf, 0, imax + 1 - imin);
        System.arraycopy(F, imin, this.cdf, 0, imax + 1 - imin);
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n, this.p};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.n + ", p = " + this.p;
    }

    private static class Function
    implements MathFunction {
        protected int m;
        protected int max;
        protected double mean;
        protected int[] Fj;

        public Function(int m, int max, double mean, int[] Fj) {
            this.m = m;
            this.max = max;
            this.mean = mean;
            this.Fj = new int[Fj.length];
            System.arraycopy(Fj, 0, this.Fj, 0, Fj.length);
        }

        public double evaluate(double s) {
            if (s <= 0.0) {
                return 1.0E100;
            }
            double sum = 0.0;
            double p = s / (s + this.mean);
            for (int j = 0; j < this.max; ++j) {
                sum += (double)this.Fj[j] / (s + (double)j);
            }
            return sum + (double)this.m * Math.log(p);
        }
    }

    private static class Func1
    implements MathFunction {
        protected int m;
        protected int[] x;
        protected double p;

        public Func1(double p, int[] x, int m) {
            this.p = p;
            this.m = m;
            this.x = x;
        }

        public double evaluate(double gam) {
            if (gam <= 0.0) {
                return 1.0E100;
            }
            double sum = 0.0;
            for (int j = 0; j < this.m; ++j) {
                sum += Num.digamma(gam + (double)this.x[j]);
            }
            return sum / (double)this.m + Math.log(this.p) - Num.digamma(gam);
        }
    }
}

